## replace-r.pl --- replace strings in a tree of files
## Time-stamp: "97/07/27 12:28:52 mik"
## Copyright (C) 1997 Christian Schenk <cschenk@berlin.snafu.de>

require "find.pl";
use Cwd;
use File::Path;
use File::Find;
use File::Basename;
use Getopt::Long;

&main;
exit 0;

sub main

{
  my ($old, $new);

  &GetOptions ("old=s" => \$old, "new=s" => \$new);
  die "have to specify the --old string\n" unless (length ($old) > 0);

  @FILES = ();
  &find (\&wanted, ".");;

  foreach $file (@FILES)
    {
      &repl ($file, $old, $new);
    }
}

sub repl

{
  my ($f, $o, $n) = @_;
  my ($text, $i, $changed);
#  $oldname = $f;
#  $f =~ s/\.snafu$//;
#  rename ($oldname, $f);
#  return 0;
  open FILE, $f || die "cannot open $f: $!\n";
  $text .= $_ while (<FILE>);
  close FILE;
  $changed = 0;
  $i = 0;
  while (($i = index ($text, $o, $i)) >= 0)
    {
      substr ($text, $i, length ($o)) = $n;
      $i += length ($n);
      $changed++;
    }
  if ($changed > 0)
    {
      print "Changing $f\n";
      die "Cannot make a backup of $f" unless (rename ($f, $f . ".in-berlin"));
      open NEWFILE, ">$f" || die "cannot open $f: $!\n";
      print NEWFILE $text;
      close NEWFILE;
    }
}

sub wanted

{
  if ($File::Find::name =~ m#(.*)\.(c|cc|cpp|h|l|rc|txt|texi|win32|win32-changes|y)$#)
#  if ($File::Find::name =~ m#(.*)\.(snafu)$#)
    {
      push @FILES, $File::Find::name;
    }
}
