// Creating a shortcut

// This file is public domain.

#undef UNICODE
#define UNICODE
#undef _UNICODE
#define _UNICODE

#include "tla_utils.h"
#include <shlobj.h>
#include <shobjidl.h>
#include <objbase.h>
#include <objidl.h>
#include <shlguid.h>

using namespace std;

/*
Collect here all the stuff that would be troublesome in plain C.

Mainly, user-specific and system-wide shortcuts.

Note. The SUCCEEDED macro is a simple numerical comparison.

To convert COM code to plain C:
- interpose '->lpVtbl' in method call;
  lpVtbl is the function array member of the interface struct
- add created instance as first parameter to method calls
- turn CLSID- and IID_ parameters of CoCreateInstance into references
- remove 'using namespace std;'
See http://stackoverflow.com/questions/35112942/
 /using-ishelllink-bloats-my-executable-to-20kb
*/

// the two trivial wrapper functions below remove the need for other modules
// to read all the COM header files, with potentially troublesome
// inlined functions

extern "C" BOOL init_com( void ) {
  HRESULT hr;
  hr = CoInitializeEx( NULL, COINIT_APARTMENTTHREADED|COINIT_DISABLE_OLE1DDE );
  return SUCCEEDED( hr );
}

extern "C" void uninit_com( void ) {
  CoUninitialize();
}

extern "C" int make_shortcut( wchar_t * target, wchar_t * parms,
    wchar_t * link_loc ) {

  HRESULT hr, hr0 = -1;
  IShellLink * psl;
  IPersistFile * ppf;
  wchar_t * knownfolder = NULL;

  if( !init_com( )) return 0;

  hr = CoCreateInstance( CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER,
      IID_IShellLink, ( LPVOID* )&psl );
  if( !SUCCEEDED( hr )) return 0;
  psl->SetPath( target );
  if( parms && parms[0] )  psl->SetArguments( parms );
  psl->SetDescription( NULL );
  // working directory for target.
  // elevated: set to %userprofile%. Undocumented, but works.
  // otherwise, i.e. for a single-user shortcut, use FOLDERID_Documents.
  if( is_elevated( )) {
    psl->SetWorkingDirectory( L"%UserProfile%" );
  } else {
    hr0 = SHGetKnownFolderPath( FOLDERID_Documents, 0, NULL, &knownfolder );
    if( SUCCEEDED( hr0 )) psl->SetWorkingDirectory( knownfolder );
  }
  // ppf is the file persona of psl
  hr = psl->QueryInterface( IID_IPersistFile, ( LPVOID* )&ppf );
  if( SUCCEEDED( hr )) {
    wchar_t * d, * p;
    // create directory beforehand, just in case
    p = wcsrchr( link_loc, L'\\' );
    if( !p ) {
      // fatal because programmer error
      wchar_t warning[] { L"make_shortcut: absolute path required" };
      // c++ does not like a string constant here
      tldie( NULL, warning );
      return 0;
    }
    d = tl_wcsncpy( link_loc, p - link_loc );
    if( is_dir( d ) || mkdir_recursive( d )) {
      hr = ppf->Save( link_loc, TRUE );
      if( !SUCCEEDED( hr )) {
        wchar_t warn2[] { L"Shortcut creation failed; error %u" };
        wr_log( warn2, GetLastError( ));
        hr = S_FALSE;
      }
    }
    ppf->Release();
  }
  psl->Release();
  if( knownfolder && SUCCEEDED( hr0 )) CoTaskMemFree( knownfolder );
  uninit_com();
  return SUCCEEDED( hr ) ? 1 : 0;
} // make_shortcut
