/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.api.localization;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/islandoftex/arara/api/localization/MPPLocale;", "", "tag", "", "<init>", "(Ljava/lang/String;)V", "locale", "Ljava/util/Locale;", "displayLanguage", "getDisplayLanguage", "()Ljava/lang/String;", "decimalSeparator", "", "getDecimalSeparator", "()C", "toJVMLocale", "hashCode", "", "toString", "equals", "", "other", "api"})
public final class MPPLocale {
    @NotNull
    private final Locale locale;
    @NotNull
    private final String displayLanguage;
    private final char decimalSeparator;

    public MPPLocale(@NotNull String tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Locale locale = Locale.forLanguageTag(tag);
        Intrinsics.checkNotNullExpressionValue(locale, "forLanguageTag(...)");
        this.locale = locale;
        String string = this.locale.getDisplayLanguage();
        Intrinsics.checkNotNullExpressionValue(string, "getDisplayLanguage(...)");
        this.displayLanguage = string;
        this.decimalSeparator = new DecimalFormatSymbols(this.locale).getDecimalSeparator();
    }

    @NotNull
    public final String getDisplayLanguage() {
        return this.displayLanguage;
    }

    public final char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    @NotNull
    public final Locale toJVMLocale() {
        return this.locale;
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.locale.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type org.islandoftex.arara.api.localization.MPPLocale");
        MPPLocale cfr_ignored_0 = (MPPLocale)other;
        return Intrinsics.areEqual(this.locale, ((MPPLocale)other).locale);
    }
}

