/**
 * Authors: Frederik Leyvraz, David Degenhardt
 * License: GNU General Public License v3.0 only
 * Version: 1.0.1
 */

package ch.bfh.ti.latexindexer;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

public class WordTest {

    Word word, subVariant, superVariant;

    @BeforeEach
    void setUp(){
        word = new Word("word", 5);
        subVariant = new Word("Subvariant");
        superVariant = new Word("supervariant");
    }

    @Test
    void simpleIndexStringTest(){
        assertEquals(word.getIndexString(), "word");
    }

    @Test
    void singleSubVariantIndexStringTest(){
        subVariant.setSuperVariant(word);
        assertEquals(subVariant.getIndexString(), "word!Subvariant");
        assertEquals(word.getIndexString(), "word");
    }

    @Test
    void doubleSubVariantIndexStringTest(){
        word.setSuperVariant(superVariant);
        subVariant.setSuperVariant(word);
        assertEquals(subVariant.getIndexString(), "supervariant!word!Subvariant");
        assertEquals(word.getIndexString(), "supervariant!word");
    }

    @Test
    void subVariantCyclesIndexStringTest1(){
        superVariant.setSuperVariant(word);
        assertEquals(superVariant.getIndexString(), "word!supervariant");
        word.setSuperVariant(superVariant);
        assertEquals(word.getIndexString(),"supervariant!word");
        assertEquals(superVariant.getIndexString(), "supervariant");
    }

    @Test
    void subVariantCyclesIndexStringTest2(){
        superVariant.setSuperVariant(word);
        word.setSuperVariant(subVariant);
        assertEquals(superVariant.getIndexString(), "Subvariant!word!supervariant");
        subVariant.setSuperVariant(superVariant);
        assertEquals(word.getIndexString(),"supervariant!Subvariant!word");
        assertEquals(subVariant.getIndexString(), "supervariant!Subvariant");
        assertEquals(superVariant.getIndexString(), "supervariant");
    }

}
