// ot2woff.cpp : This file contains the 'main' function. Program execution begins and ends there.
//


#include "ot2woff.h"


int main(int argc, char* argv[])
{
    if (argc < 3 || argc > 4)
    {
        puts(COPYRIGHT_NOTICE);

        puts("Usage: ot2woff input_font_filename[.otf|.ttf] output_font_filename.woff [compression level]\n");
        puts("       where 'compression level' is a number from 0 to 9 (highest compression)");

        return 1;
    }
    else
    {
        const char *compression_level = (argc >=4 ) ? argv[3] : nullptr;
        OT2Woff ot;
                

        if (!ot.convert(argv[1], argv[2], compression_level))
        {
            puts(ot.error().c_str());

            return 1;
        }
        else
        {
            puts("Success");

            return 0;
        }
    }
}

