# SunPRO.mk 2.9.0 92/07/06 makefile for mff -- SunPRO version

#  This Makefile uses some of the features of SunPRO(tm) make.  
#  This is because our network has a mixture of Sun-3s and Sun-4s,
#  and I need to keep the binaries produced for each type of machine
#  separate.  With SunPRO make I can arrange for the binaries to be
#  produced in subdirectories named after the architecture types.
#  The predefined macro $(TARGET_ARCH) says which architecture is 
#  being used.

#  make all 
#	to create progs in the subdirectory `arch`

#  make install IBIN=/usr/local/bin OPT=-O4 LDFLAGS=-s
#	to do "make all" and then copy progs into $(IBIN).

.KEEP_STATE:

ARCH=$(TARGET_ARCH:-%=%)
OBJ=$(ARCH)
BIN=$(OBJ)

SUFFIX=

#  MACROS THAT GO INTO THE cc COMMAND

CC=gcc -Wall
OPT=-O
NDEBUG=-DNDEBUG
CFLAGS=$(OPT)

RCDIR=/mclab/pdc/lib
#  RCDIR is the directory in which  the "system-wide" rc.mff file is 
#  to be found.  
#  The default -- if the above line is commented out --
#  is the value in config.h; by default /usr/local/lib.

CPPFLAGS=$(NDEBUG) $(MORECPPFLAGS)
LDFLAGS=

CP=cp -p
RM=rm -f

#  Tell "make" how to do compilations
#  -- removed Sun's silly -target option which confuses gcc.
COMPILE.c=$(CC) $(CFLAGS) $(CPPFLAGS) -c
LINK.c=$(CC) $(CFLAGS) $(CPPFLAGS) $(LDFLAGS)

$(OBJ)/%$(SUFFIX).o: %.c
	$(COMPILE.c) -o $@ $<
$(OBJ)/%.o: %.c
	$(COMPILE.c) -o $@ $<

#  Definitions used in maintaining the TeX file that will
#  eventually accompany this:

MAKEINDEX=/usr/local/lib/tex/bin4/makeindex
MAKEINDEXFLAGS=-rl -s /mclab/pdc/tex/idx.makeindex

IBIN=/mclab/pdc/bin/$(ARCH)
ILIB=/mclab/pdc/lib/$(ARCH)

########################################################################
#	PROGS

PROGS=mff.c searchpath.c
# source files for executables

LIBFILE=libargloop$(SUFFIX).a
LIB=$(OBJ)/$(LIBFILE)
.PRECIOUS: $(LIB)

MODULES=argloop.c al_file.c al_init.c \
	findfile.c \
	strword.c stritem.c strdup.c fgetword.c error.c
# source files for modules in the argloop library

all: $(PROGS:%.c=$(BIN)/%)
install: $(PROGS:%.c=$(IBIN)/%) install-lib
install-lib: $(ILIB)/$(LIBFILE)
#  There is an implicit rule that cp's files into install directories

#  Keywords that give certain macros different values:
debug:
	$(MAKE) all SUFFIX=-g OPT=-g LDFLAGS= NDEBUG= "CC=gcc -Wall"
install-lib-g:
	$(MAKE) install-lib \
		SUFFIX=-g OPT=-g LDFLAGS= NDEBUG= "CC=gcc -Wall"
clean: 
	$(RM) *.ln *.o $(PROGS:.c=) $(OBJ)/* $(LIB)

MFF.o=$(OBJ)/mff$(SUFFIX).o $(OBJ)/assoc$(SUFFIX).o \
	$(OBJ)/fx$(SUFFIX).o $(OBJ)/magstep$(SUFFIX).o
MFF.lib=$(LIB)
$(BIN)/mff: $(MFF.o) $(LIB)
	$(LINK.c) -o $@ $(MFF.o) $(MFF.lib)

SEARCHPATH.o=$(OBJ)/searchpath$(SUFFIX).o
SEARCHPATH.lib=$(LIB)
$(BIN)/searchpath: $(SEARCHPATH.o) $(LIB)
	$(LINK.c) -o $@ $(SEARCHPATH.o) $(SEARCHPATH.lib)

$(OBJ)/mff$(SUFFIX).o:	mff.c stdc.h config.h xstdio.h argloop.h fatal.h \
		searchpath.h assoc.h fx.h strmisc.h magstep.h \
		version.h
$(OBJ)/assoc$(SUFFIX).o:assoc.c stdc.h config.h xstdio.h strmisc.h assoc.h
$(OBJ)/fx$(SUFFIX).o:	fx.c stdc.h config.h xstdio.h fatal.h strmisc.h fx.h
$(OBJ)/magstep$(SUFFIX).o:	magstep.c stdc.h config.h magstep.h
$(OBJ)/searchpath$(SUFFIX).o:	searchpath.c xstdio.h stdc.h config.h \
	searchpath.h

$(OBJ)/al_file.o:	al_file.c config.h xstdio.h stdc.h strmisc.h argloop.h
$(OBJ)/al_init.o:	al_init.c config.h xstdio.h stdc.h strmisc.h argloop.h
$(OBJ)/argloop.o:	argloop.c config.h xstdio.h stdc.h strmisc.h argloop.h
$(OBJ)/error.o:	error.c stdc.h config.h xstdio.h argloop.h fatal.h
$(OBJ)/fgetword.o:	fgetword.c xstdio.h stdc.h config.h
$(OBJ)/findfile.o:	findfile.c config.h strmisc.h stdc.h searchpath.h
$(OBJ)/strdup.o:	strdup.c fatal.h stdc.h config.h strmisc.h
$(OBJ)/stritem.o:	stritem.c strmisc.h stdc.h config.h
$(OBJ)/strword.o:	strword.c strmisc.h stdc.h config.h

config.h: config.x
	sed 's%/usr/local/lib%$(RCDIR)%' config.x > config.h

########################################################################
#	LIBRARY

# source for modules that go in the library

$(LIB): $(LIB)($(MODULES:%.c=$(OBJ)/%.o))

#  default rule
$(LIB)($(OBJ)/%.o): %.c
	$(COMPILE.c) -o $% $<
	$(AR) $(ARFLAGS) $@ $%
	$(RM) $%
	ranlib $@

#  I can't get @#$%& make to reliably ranlib after adding one or more
#  modules, so I have to make it do so every time.

########################################################################
#	LINT SECTION (moan, moan)
#
#  sun's lint libraries often seem inconsistent with the manual pages 
#  and with reality.  
#
#  -n -lbsd -lm (BSD-compatibility check)
#    -- sprintf is given return type int not char * (!!)
#    -- void functions are given return type int
#    -- toupper is not defined
#  -lm -q (SunOS check)
#    -- errno is not defined

CFILES=$(PROGS)
LINTFILES=$(PROGS:.c=.ln)
LINTFLAGS=-abh
LINTLIB=llib-lmff.ln
LINTLIBS=-n -lbsd -lm
#LINTLIBS=-q -lm
LINTGREP=egrep -v 'constant (argument to NOT|in conditional context)'

lint: lint-mff lint-searchpath

lint-%: %.c $(LINTLIB)
	$(LINT.c) $*.c $(LINTLIB) $(LINTLIBS) | $(LINTGREP)

$(LINTLIB): $(MODULES:.c=.ln)
	$(LINT.c) -Cmff $(MODULES)

########################################################################

#  Mysterious definitions that manitain the (unfinished) docs:

DOC=mffman

$(DOC).dvi: $(DOC).ind $(DOC).tex
	tex $(DOC)

$(DOC).ind: $(DOC).idx
	$(MAKEINDEX) $(MAKEINDEXFLAGS) $(DOC)

$(DOC).idx: $(DOC).tex
	tex $(DOC)

########################################################################
# implicit rules:

.SUFFIXES: .1 .3

$(IBIN)/%: $(BIN)/%
	$(CP) $< $@

$(ILIB)/%: $(OBJ)/%
	$(CP) $< $@

########################################################################
atari: atari/mff.1 atari/searchpath.1 atari/shar.1 atari/testfont.1 \
	atari/argloop.3 atari/fatalf.3 atari/mff.3 atari/strword.3 \
	atari/findfile.3 atari/stritem.3 atari/xmalloc.3

atari-clean:
	rm atari/*.[13]

atari/%.1: man1/%.1
	man2cat $< > $@

atari/%.3: man3/%.3
	man2cat $< > $@

