/* External procedures for unix crudetype 				*/
/*   Written by RMD (nearly all copied from H.Trickey's  dvityext.c  )  */
/*   Ought to be rewritten in cleaner form... */

#include <stdio.h>
#include "site.h"
  /*Only needed to define   TEXFONTS */

#define	TRUE   1
#define	FALSE	0

char *fontpath;
extern char *getenv();

/*
 * setpaths is called to set up the pointer fontpath
 * as follows:  if the user's environment has a value for TEXFONTS
 * then use it;  otherwise, use defaultfontpath.
 */
setpaths()
{
	register char *envpath;
	
	if ((envpath = getenv("TEXFONTS")) != NULL)
	    fontpath = envpath;
	else
	    fontpath = TEXFONTS;
}

#define namelength 100   /* should agree with crudetype


/*
 *	testaccess(amode,filepath, name, realname)
 *
 *  Test whether or not the file whose name is in name
 *  can be opened for reading (if mode=READACCESS)
 *  or writing (if mode=WRITEACCESS).
 *
 *  The filepath argument is one of the ...FILEPATH constants defined below.
 *  If the filename given in name does not begin with '/', we try 
 *  prepending all the ':'-separated areanames in the appropriate path to the
 *  filename until access can be made, if it ever can.
 *
 *  The realname global array will contain the name that yielded an
 *  access success.
 */

#define READACCESS 4
#define WRITEACCESS 2

#define NOFILEPATH 0
#define FONTFILEPATH 3

testaccess(amode,filepath,name,realname)
int amode,filepath;
char *name;
char *realname;
{
    register boolean ok;
    register char *p;
    char *curpathplace;
    int f;
    
    switch(filepath) {
	case NOFILEPATH: curpathplace = NULL; break;
	case FONTFILEPATH: curpathplace = fontpath; break;
	}
    if (name[0]=='/')	/* file name has absolute path */
	curpathplace = NULL;
    do {
	packrealname(&curpathplace,name,realname);
	if (amode==READACCESS)
	    /* use system call "access" to see if we could read it */
	    if (access(realname,READACCESS)==0) ok = TRUE;
	    else ok = FALSE;
	else {
	    /* WRITEACCESS: use creat to see if we could create it, but close
	    the file again if we're OK, to let pc open it for real */
	    f = creat(realname,0666);
	    ok = (f >= 0);
	    if (ok)
		(void) close(f);
	    }
    } while (!ok && curpathplace != NULL);
    if (ok) {  /* pad realname with blanks, as Pascal wants */
	for (p = realname; *p != '\0'; p++)
	    /* nothing: find end of string */ ;
	while (p < &(realname[namelength]))
	    *p++ = ' ';
	}
    return (ok);
}

/*
 * packrealname(cpp,name,realname) makes realname contain the directory at *cpp,
 * followed by '/', followed by the characters in  name  up until the
 * first blank there, and finally a '\0'.  The cpp pointer is left pointing
 * at the next directory in the path.
 * But: if *cpp == NULL, then we are supposed to use  name  as is.
 */
static packrealname(cpp,name,realname)
    char **cpp;
    char *name, *realname;
{
    register char *p,*tempname;
    
    tempname = realname;
    if ((p = *cpp)!=NULL) {
	while ((*p != ':') && (*p != '\0')) {
	    *tempname++ = *p++;
	    if (tempname == &(realname[namelength-1]))
		break;
	    }
	if (*p == '\0') *cpp = NULL; /* at end of path now */
	else *cpp = p+1; /* else get past ':' */
	*tempname++ = '/';  /* separate the area from the name to follow */
	}
    /* now append name to tempname... */
    /* There was a very peculiar bug here, I tried to fix it. (RMD).
       Originally this said  "p = name+1 ;"  this cut off the 
       first character of the name */
    p = name ;
    while (*p != ' ') {
	if (tempname >= &(realname[namelength-1])) {
	    (void) fprintf(stderr,"! Full file name is too long\n");
	    break;
	    }
	*tempname++ = *p++;
	}
    *tempname = '\0';
}
