#*******************************************************************************
# Copyright (c) 2000, 2003 IBM Corporation and others.
# All rights reserved. This program and the accompanying materials 
# are made available under the terms of the Common Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/cpl-v10.html
# 
# Contributors:
#     IBM Corporation - initial API and implementation
#     Kevin Cornell (Rational Software Corporation)
#*******************************************************************************
#
# Usage: sh build.sh [<optional switches>] [clean]
#
#   where the optional switches are:
#       -output <PROGRAM_OUTPUT>  - executable filename ("eclipse")
#       -name   <PROGRAM_NAME>    - title of launcher   ("Eclipse")
#       -os     <DEFAULT_OS>      - default Eclipse "-os" value (qnx) 
#       -arch   <DEFAULT_OS_ARCH> - default Eclipse "-arch" value (x86) 
#       -ws     <DEFAULT_WS>      - default Eclipse "-ws" value (photon) 
#
#
#    This script can also be invoked with the "clean" argument.

#!/bin/sh

# Define default values for environment variables used in the makefiles.
programOutput="eclipse"
programName="Eclipse"
defaultOS="qnx"
defaultOSArch="x86"
defaultWS="photon"
makefile="make_photon.mak"
OS="QNX/Photon"

# Parse the command line arguments and override the default values.
extraArgs=""
while [ "$1" != "" ]; do
    if [ "$1" = "-os" ] && [ "$2" != "" ]; then
        defaultOS="$2"
        shift
    elif [ "$1" = "-arch" ] && [ "$2" != "" ]; then
        defaultOSArch="$2"
        shift
    elif [ "$1" = "-ws" ] && [ "$2" != "" ]; then
        defaultWS="$2"
        shift
    elif [ "$1" = "-output" ] && [ "$2" != "" ]; then
        programOutput="$2"
        shift
    elif [ "$1" = "-name" ] && [ "$2" != "" ]; then
        programName="$2"
        shift
    else
        extraArgs="$extraArgs $1"
    fi
    shift
done

# Set up environment variables needed by the makefile.
PROGRAM_OUTPUT="$programOutput";  export PROGRAM_OUTPUT
PROGRAM_NAME="$programName";      export PROGRAM_NAME
DEFAULT_OS="$defaultOS";          export DEFAULT_OS
DEFAULT_OS_ARCH="$defaultOSArch"; export DEFAULT_OS_ARCH
DEFAULT_WS="$defaultWS";          export DEFAULT_WS

# If the OS is supported (a makefile exists)
if [ "$makefile" != "" ]; then
    if [ "$extraArgs" != "" ]; then
        make -f $makefile $extraArgs
    else
        echo "Building $OS launcher. Defaults: -os $DEFAULT_OS -arch $DEFAULT_OS_ARCH -ws $DEFAULT_WS"
        make -f $makefile clean
        make -f $makefile all
    fi
else
    echo "Unknown OS ($OS) -- build aborted"
fi
