/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class FeatureImportOperation
implements IWorkspaceRunnable {
    private IFeatureModel[] fModels;
    private IPath fTargetPath;
    private IWorkspaceRoot fRoot;
    private IReplaceQuery fReplaceQuery;

    public FeatureImportOperation(IFeatureModel[] models, IPath targetPath, IReplaceQuery replaceQuery) {
        this.fModels = models;
        this.fTargetPath = targetPath;
        this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fReplaceQuery = replaceQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(PDEPlugin.getResourceString("FeatureImportWizard.operation.creating"), this.fModels.length);
        try {
            MultiStatus multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, PDEPlugin.getResourceString("FeatureImportWizard.operation.multiProblem"), null);
            for (int i = 0; i < this.fModels.length; ++i) {
                try {
                    this.createProject(this.fModels[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    multiStatus.merge(e.getStatus());
                }
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            if (!multiStatus.isOK()) {
                throw new CoreException((IStatus)multiStatus);
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createProject(IFeatureModel model, IProgressMonitor monitor) throws CoreException {
        String name = model.getFeature().getId() + "-feature";
        String task = PDEPlugin.getFormattedMessage("FeatureImportWizard.operation.creating2", name);
        monitor.beginTask(task, 8);
        try {
            IProject project = this.fRoot.getProject(name);
            if (project.exists()) {
                if (!this.queryReplace(project)) return;
                project.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                try {
                    RepositoryProvider.unmap((IProject)project);
                }
                catch (TeamException e) {}
            } else {
                monitor.worked(1);
            }
            IProjectDescription description = PDEPlugin.getWorkspace().newProjectDescription(name);
            description.setLocation(this.fTargetPath.append(name));
            project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!project.isOpen()) {
                project.open(null);
            }
            File featureDir = new File(model.getInstallLocation());
            this.importContent(featureDir, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
            this.setProjectNatures(project, model, monitor);
            return;
        }
        finally {
            monitor.done();
        }
    }

    private void importContent(Object source, IPath destPath, IImportStructureProvider provider, List filesToImport, IProgressMonitor monitor) throws CoreException {
        IOverwriteQuery query = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        ImportOperation op = new ImportOperation(destPath, source, provider, query);
        op.setCreateContainerStructure(false);
        if (filesToImport != null) {
            op.setFilesToImport(filesToImport);
        }
        try {
            op.run(monitor);
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            if (th instanceof CoreException) {
                throw (CoreException)th;
            }
            Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException(e.getMessage());
        }
    }

    private boolean queryReplace(IProject project) throws OperationCanceledException {
        switch (this.fReplaceQuery.doQuery(project)) {
            case 0: {
                throw new OperationCanceledException();
            }
            case 1: {
                return false;
            }
        }
        return true;
    }

    private void setProjectNatures(IProject project, IFeatureModel model, IProgressMonitor monitor) throws CoreException {
        IProjectDescription desc = project.getDescription();
        if (model.getFeature().getInstallHandler() != null) {
            desc.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.FeatureNature"});
            IJavaProject jProject = JavaCore.create((IProject)project);
            jProject.setRawClasspath(new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"))}, monitor);
        } else {
            desc.setNatureIds(new String[]{"org.eclipse.pde.FeatureNature"});
        }
        project.setDescription(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    public static interface IReplaceQuery {
        public static final int CANCEL = 0;
        public static final int NO = 1;
        public static final int YES = 2;

        public int doQuery(IProject var1);
    }
}

