/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDEPluginConverter;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.IInputContextListener;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.PackageSelectionDialog;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;
import org.osgi.framework.BundleException;

public class PluginActivationSection
extends TableSection
implements IModelChangedListener,
IInputContextListener {
    private PageBook topBook;
    private Composite topContainer;
    private Composite blankContainer;
    private TableViewer fExceptionsTableViewer;
    private Button fDoActivateButton;
    private Button fDoNotActivateButton;
    private Font fBoldFont;
    private static final String ECLIPSE_AUTOSTART = PDEPlugin.getResourceString("PluginActivationSection.autostart");

    public PluginActivationSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEPlugin.getResourceString("ManifestEditor.OSGiSection.add"), PDEPlugin.getResourceString("ManifestEditor.OSGiSection.remove")});
        this.getSection().setText(PDEPlugin.getResourceString("PluginActivationSection.title"));
        this.getSection().setDescription(PDEPlugin.getResourceString("PluginActivationSection.desc"));
    }

    private void update() {
        this.fDoActivateButton.setEnabled(this.isEditable());
        this.fDoActivateButton.setSelection(this.isAutoStart());
        this.fDoNotActivateButton.setSelection(!this.isAutoStart());
        this.fDoNotActivateButton.setEnabled(this.isEditable());
        this.enableButtons();
    }

    private boolean isAutoStart() {
        ManifestElement element = this.getManifestElement();
        return element == null ? true : !"false".equals(element.getValue());
    }

    private String[] getExceptions() {
        ManifestElement element = this.getManifestElement();
        if (element == null) {
            return new String[0];
        }
        String exceptions = element.getAttribute("exceptions");
        if (exceptions == null) {
            return new String[0];
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(exceptions, ",");
        while (tok.hasMoreTokens()) {
            tokens.add(tok.nextToken().trim());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private ManifestElement getManifestElement() {
        String value;
        IBundleModel model = this.getBundleModel();
        if (model != null && (value = model.getBundle().getHeader(ECLIPSE_AUTOSTART)) != null) {
            try {
                ManifestElement[] elements = ManifestElement.parseHeader((String)ECLIPSE_AUTOSTART, (String)value);
                if (elements != null && elements.length > 0) {
                    return elements[0];
                }
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isEditable() {
        return this.getPage().getModel().isEditable() && this.getBundleModel() != null;
    }

    public void dispose() {
        IBundleModel model;
        InputContextManager contextManager = this.getPage().getPDEEditor().getContextManager();
        if (contextManager != null) {
            contextManager.removeInputContextListener(this);
        }
        if ((model = this.getBundleModel()) != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        this.fBoldFont.dispose();
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        if (event.getChangedProperty().equals(ECLIPSE_AUTOSTART)) {
            this.refresh();
        }
    }

    public void refresh() {
        this.fExceptionsTableViewer.refresh();
        this.fDoActivateButton.setSelection(this.isAutoStart());
        this.fDoNotActivateButton.setSelection(!this.isAutoStart());
        super.refresh();
    }

    private void initializeFonts() {
        FontData[] fontData = this.getSection().getFont().getFontData();
        FontData data = fontData.length > 0 ? fontData[0] : new FontData();
        data.setStyle(1);
        this.fBoldFont = new Font((Device)this.getSection().getDisplay(), fontData);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        InputContextManager contextManager;
        this.initializeFonts();
        Composite mainContainer = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        mainContainer.setLayout((Layout)layout);
        mainContainer.setLayoutData((Object)new GridData(1808));
        if (this.getPage().getPDEEditor().getAggregateModel().isEditable()) {
            this.topBook = new PageBook(mainContainer, 0);
            this.blankContainer = toolkit.createComposite((Composite)this.topBook);
            this.blankContainer.setLayout((Layout)new GridLayout());
            Label label = toolkit.createLabel(this.blankContainer, null);
            GridData gd = new GridData();
            gd.heightHint = 1;
            gd.widthHint = 1;
            label.setLayoutData((Object)gd);
            this.topContainer = toolkit.createComposite((Composite)this.topBook);
            layout = new GridLayout();
            layout.marginWidth = 2;
            layout.marginHeight = 2;
            layout.numColumns = 2;
            layout.makeColumnsEqualWidth = false;
            this.topContainer.setLayout((Layout)layout);
            toolkit.createLabel(this.topContainer, PDEPlugin.getResourceString("PluginActivationSection.manifestRequired"));
            Hyperlink manifestLink = toolkit.createHyperlink(this.topContainer, PDEPlugin.getResourceString("PluginActivationSection.createManifest"), 0);
            manifestLink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        PluginActivationSection.this.getPage().getEditor().doSave(null);
                        IPluginModelBase model = (IPluginModelBase)PluginActivationSection.this.getPage().getPDEEditor().getAggregateModel();
                        PDEPluginConverter.convertToOSGIFormat((IProject)model.getUnderlyingResource().getProject(), (String)(model.isFragmentModel() ? "fragment.xml" : "plugin.xml"), (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkEntered(HyperlinkEvent e) {
                }
            });
            this.bundleModeChanged(this.getContextId().equals("bundle-context"));
        }
        Composite bottomContainer = toolkit.createComposite(mainContainer);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        bottomContainer.setLayout((Layout)layout);
        bottomContainer.setLayoutData((Object)new GridData(1808));
        Composite ruleContainer = toolkit.createComposite(bottomContainer);
        layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        ruleContainer.setLayout((Layout)layout);
        ruleContainer.setLayoutData((Object)new GridData(2));
        Label activateLabel = toolkit.createLabel(ruleContainer, PDEPlugin.getResourceString("PluginActivationSection.rule"));
        activateLabel.setFont(this.fBoldFont);
        this.fDoActivateButton = toolkit.createButton(ruleContainer, PDEPlugin.getResourceString("PluginActivationSection.activate"), 16);
        GridData gd = new GridData();
        gd.horizontalIndent = 5;
        this.fDoActivateButton.setLayoutData((Object)gd);
        this.fDoActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginActivationSection.this.writeHeader();
            }
        });
        this.fDoNotActivateButton = toolkit.createButton(ruleContainer, PDEPlugin.getResourceString("PluginActivationSection.noActivate"), 16);
        gd = new GridData();
        gd.horizontalIndent = 5;
        this.fDoNotActivateButton.setLayoutData((Object)gd);
        this.fDoNotActivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginActivationSection.this.writeHeader();
            }
        });
        Composite exceptionsContainer = toolkit.createComposite(bottomContainer);
        layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 3;
        exceptionsContainer.setLayout((Layout)layout);
        exceptionsContainer.setLayoutData((Object)new GridData(1808));
        Label exceptionLabel = toolkit.createLabel(exceptionsContainer, PDEPlugin.getResourceString("PluginActivationSection.exception.title"));
        exceptionLabel.setFont(this.fBoldFont);
        exceptionLabel.setLayoutData((Object)new GridData(768));
        Label label = toolkit.createLabel(exceptionsContainer, PDEPlugin.getResourceString("PluginActivationSection.exception.desc"), 64);
        gd = new GridData(768);
        gd.widthHint = 225;
        label.setLayoutData((Object)gd);
        Composite exceptionsPkgContainer = toolkit.createComposite(exceptionsContainer);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        exceptionsPkgContainer.setLayout((Layout)layout);
        exceptionsPkgContainer.setLayoutData((Object)new GridData(1808));
        this.createViewerPartControl(exceptionsPkgContainer, 65536, 2, toolkit);
        this.fExceptionsTableViewer = this.getTablePart().getTableViewer();
        this.fExceptionsTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.fExceptionsTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fExceptionsTableViewer.setInput((Object)this.getBundleModel());
        toolkit.paintBordersFor(exceptionsContainer);
        section.setClient((Control)mainContainer);
        IBundleModel model = this.getBundleModel();
        if (model != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
        if ((contextManager = this.getPage().getPDEEditor().getContextManager()) != null) {
            contextManager.addInputContextListener(this);
        }
        this.update();
    }

    protected void enableButtons() {
        this.getTablePart().setButtonEnabled(0, this.isEditable());
        this.getTablePart().setButtonEnabled(1, false);
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleAdd();
        } else if (index == 1) {
            this.handleRemove();
        }
    }

    private void handleAdd() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        IProject project = model.getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                TableItem[] existingPackages = this.fExceptionsTableViewer.getTable().getItems();
                Vector<String> existing = new Vector<String>();
                for (int i = 0; i < existingPackages.length; ++i) {
                    existing.add(existingPackages[i].getText());
                }
                JavaElementLabelProvider labelProvider = new JavaElementLabelProvider();
                PackageSelectionDialog dialog = new PackageSelectionDialog(this.fExceptionsTableViewer.getTable().getShell(), (ILabelProvider)labelProvider, JavaCore.create((IProject)project), existing);
                if (dialog.open() == 0) {
                    Object[] elements = dialog.getResult();
                    for (int i = 0; i < elements.length; ++i) {
                        this.fExceptionsTableViewer.add((Object)((IPackageFragment)elements[i]).getElementName());
                    }
                    this.writeHeader();
                }
                labelProvider.dispose();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void writeHeader() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fDoActivateButton.getSelection() ? "true" : "false");
        TableItem[] items = this.fExceptionsTableViewer.getTable().getItems();
        if (items.length > 0) {
            buffer.append(";exceptions=\"");
        }
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(items[i].getData().toString());
            if (i >= items.length - 1) continue;
            buffer.append("," + System.getProperty("line.separator"));
        }
        if (items.length > 0) {
            buffer.append("\"");
        }
        this.getBundleModel().getBundle().setHeader(ECLIPSE_AUTOSTART, buffer.toString());
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fExceptionsTableViewer.getSelection();
        Object[] items = ssel.toArray();
        for (int i = 0; i < items.length; ++i) {
            this.fExceptionsTableViewer.remove(items[i]);
        }
        this.writeHeader();
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getTablePart().setButtonEnabled(1, selection != null && !selection.isEmpty());
    }

    public String getContextId() {
        if (this.getPluginBase() instanceof IBundlePluginBase) {
            return "bundle-context";
        }
        return "plugin-context";
    }

    private IPluginBase getPluginBase() {
        IBaseModel model = this.getPage().getPDEEditor().getAggregateModel();
        return ((IPluginModelBase)model).getPluginBase();
    }

    private IBundleModel getBundleModel() {
        InputContext context = this.getPage().getPDEEditor().getContextManager().findContext("bundle-context");
        return context != null ? (IBundleModel)context.getModel() : null;
    }

    public void contextAdded(InputContext context) {
        if (!context.getId().equals("bundle-context")) {
            return;
        }
        this.bundleModeChanged(true);
    }

    public void contextRemoved(InputContext context) {
        if (!context.getId().equals("bundle-context")) {
            return;
        }
        this.bundleModeChanged(false);
    }

    private void bundleModeChanged(boolean added) {
        if (added && this.getPage().getModel().isEditable()) {
            this.topBook.showPage((Control)this.blankContainer);
        } else {
            this.topBook.showPage((Control)this.topContainer);
        }
        if (this.fDoActivateButton != null) {
            this.update();
            this.topBook.getParent().layout();
            this.getManagedForm().reflow(true);
            this.fExceptionsTableViewer.setInput((Object)this.getBundleModel());
        }
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return false;
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
        }
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return PluginActivationSection.this.getExceptions();
        }
    }
}

