/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.ContainerPlaceholder;
import org.eclipse.ui.internal.DetachedPlaceHolder;
import org.eclipse.ui.internal.DetachedWindow;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSashContainer;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartSashContainer;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSashContainer;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.misc.StringMatcher;

public class PerspectiveHelper {
    private WorkbenchPage page;
    private Composite parentWidget;
    private ViewSashContainer mainLayout;
    private IWorkbenchPartReference zoomPart;
    private ArrayList detachedWindowList = new ArrayList(1);
    private ArrayList detachedPlaceHolderList = new ArrayList(1);
    private boolean detachable = false;
    private boolean active = false;
    private static final int MIN_DETACH_WIDTH = 150;
    private static final int MIN_DETACH_HEIGHT = 250;
    private IDragOverListener dragTarget = new IDragOverListener(){

        public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
            if (!(draggedObject instanceof ViewPane) && !(draggedObject instanceof ViewStack)) {
                return null;
            }
            LayoutPart part = (LayoutPart)draggedObject;
            if (part.getWorkbenchWindow() != PerspectiveHelper.this.page.getWorkbenchWindow()) {
                return null;
            }
            return new AbstractDropTarget(this, part, dragRectangle){
                private final /* synthetic */ LayoutPart val$part;
                private final /* synthetic */ Rectangle val$dragRectangle;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                    this.val$part = val$part;
                    this.val$dragRectangle = val$dragRectangle;
                }

                public void drop() {
                    Window window = this.val$part.getWindow();
                    if (window instanceof DetachedWindow) {
                        if (this.val$part instanceof ViewStack) {
                            window.getShell().setLocation(this.val$dragRectangle.x, this.val$dragRectangle.y);
                            return;
                        }
                        ILayoutContainer container = this.val$part.getContainer();
                        if (container instanceof ViewStack && ((ViewStack)container).getItemCount() == 1) {
                            window.getShell().setLocation(this.val$dragRectangle.x, this.val$dragRectangle.y);
                            return;
                        }
                    }
                    if (1.access$100(this.this$1).isZoomed()) {
                        1.access$100(this.this$1).zoomOut();
                    }
                    PerspectiveHelper.access$200(1.access$100(this.this$1), this.val$part, this.val$dragRectangle.x, this.val$dragRectangle.y);
                }

                public Cursor getCursor() {
                    return DragCursors.getCursor(6);
                }
            };
        }

        static /* synthetic */ PerspectiveHelper access$100(1 x0) {
            return x0.PerspectiveHelper.this;
        }
    };

    public PerspectiveHelper(WorkbenchPage workbenchPage, ViewSashContainer mainLayout) {
        this.page = workbenchPage;
        this.mainLayout = mainLayout;
        this.detachable = false;
        Composite client = workbenchPage.getClientComposite();
        if (client != null) {
            Composite testChild = new Composite(client, 0);
            this.detachable = testChild.isReparentable();
            testChild.dispose();
        }
    }

    public void activate(Composite parent) {
        if (this.active) {
            return;
        }
        this.parentWidget = parent;
        Vector children = new Vector();
        this.collectViewPanes(children, this.mainLayout.getChildren());
        Enumeration enumeration = children.elements();
        while (enumeration.hasMoreElements()) {
            LayoutPart part = (LayoutPart)enumeration.nextElement();
            part.reparent(parent);
        }
        this.mainLayout.createControl(parent);
        int length = this.detachedWindowList.size();
        for (int i = 0; i < length; ++i) {
            DetachedWindow dwindow = (DetachedWindow)((Object)this.detachedWindowList.get(i));
            dwindow.open();
        }
        this.enableAllDrag();
        this.active = true;
    }

    public void addPart(LayoutPart part) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        LayoutPart placeholder = null;
        LayoutPart testPart = null;
        String primaryId = part.getID();
        String secondaryId = null;
        if (part instanceof ViewPane) {
            ViewPane pane = (ViewPane)part;
            IViewReference ref = (IViewReference)pane.getPartReference();
            secondaryId = ref.getSecondaryId();
        }
        if ((testPart = secondaryId != null ? this.findPart(primaryId, secondaryId) : this.findPart(primaryId)) != null && testPart instanceof PartPlaceholder) {
            placeholder = (PartPlaceholder)testPart;
        }
        if (placeholder == null) {
            part.reparent(this.mainLayout.getParent());
            LayoutPart relative = this.mainLayout.findBottomRight();
            if (relative != null && relative instanceof PartStack) {
                this.mainLayout.stack(part, (PartStack)relative);
            } else {
                this.mainLayout.add(part);
            }
        } else {
            ILayoutContainer container = placeholder.getContainer();
            if (container != null) {
                if (container instanceof DetachedPlaceHolder) {
                    DetachedPlaceHolder holder = (DetachedPlaceHolder)container;
                    this.detachedPlaceHolderList.remove(holder);
                    container.remove(testPart);
                    DetachedWindow window = new DetachedWindow(this.page);
                    this.detachedWindowList.add(window);
                    window.create();
                    part.createControl((Composite)window.getShell());
                    window.getShell().setBounds(holder.getBounds());
                    window.open();
                    ViewPane pane = (ViewPane)part;
                    window.getShell().setText(pane.getPartReference().getTitle());
                    window.add(pane);
                    LayoutPart[] otherChildren = holder.getChildren();
                    for (int i = 0; i < otherChildren.length; ++i) {
                        part.getContainer().add(otherChildren[i]);
                    }
                } else {
                    if (container instanceof ContainerPlaceholder) {
                        ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)container;
                        ILayoutContainer parentContainer = containerPlaceholder.getContainer();
                        container = (ILayoutContainer)((Object)containerPlaceholder.getRealContainer());
                        if (container instanceof LayoutPart) {
                            parentContainer.replace(containerPlaceholder, (LayoutPart)((Object)container));
                        }
                        containerPlaceholder.setRealContainer(null);
                    }
                    if (!(container instanceof ViewStack)) {
                        part.reparent(this.mainLayout.getParent());
                    }
                    if (((PartPlaceholder)placeholder).hasWildCard()) {
                        if (container instanceof PartSashContainer) {
                            ((PartSashContainer)container).addChildForPlaceholder(part, placeholder);
                        } else {
                            container.add(part);
                        }
                    } else {
                        container.replace(placeholder, part);
                    }
                }
            }
        }
    }

    public boolean canDetach() {
        return this.detachable;
    }

    public boolean bringPartToTop(LayoutPart part) {
        PartStack folder;
        ILayoutContainer container = part.getContainer();
        if (container != null && container instanceof PartStack && (folder = (PartStack)container).getVisiblePart() != part) {
            folder.setSelection(part);
            return true;
        }
        return false;
    }

    public boolean isPartVisible(String partId, String secondaryId) {
        LayoutPart part = secondaryId != null ? this.findPart(partId, secondaryId) : this.findPart(partId);
        if (part == null) {
            return false;
        }
        if (part instanceof PartPlaceholder) {
            return false;
        }
        ILayoutContainer container = part.getContainer();
        if (container != null && container instanceof ContainerPlaceholder) {
            return false;
        }
        if (container != null && container instanceof ViewStack) {
            ViewStack folder = (ViewStack)container;
            if (folder.getVisiblePart() == null) {
                return false;
            }
            return part.getID().equals(folder.getVisiblePart().getID());
        }
        return true;
    }

    public boolean willPartBeVisible(String partId) {
        return this.willPartBeVisible(partId, null);
    }

    public boolean willPartBeVisible(String partId, String secondaryId) {
        LayoutPart part = this.findPart(partId, secondaryId);
        if (part == null) {
            return false;
        }
        ILayoutContainer container = part.getContainer();
        if (container != null && container instanceof ContainerPlaceholder) {
            container = (ILayoutContainer)((Object)((ContainerPlaceholder)container).getRealContainer());
        }
        if (container != null && container instanceof ViewStack) {
            ViewStack folder = (ViewStack)container;
            if (folder.getVisiblePart() == null) {
                return false;
            }
            return part.getCompoundId().equals(folder.getVisiblePart().getCompoundId());
        }
        return true;
    }

    public void openTracker(ViewPane pane) {
        DragUtil.performDrag(pane, DragUtil.getDisplayBounds(pane.getControl()));
    }

    private PartPlaceholder[] collectPlaceholders() {
        PartPlaceholder[] results = this.collectPlaceholders(this.mainLayout.getChildren());
        if (this.detachable) {
            int length = this.detachedWindowList.size();
            for (int i = 0; i < length; ++i) {
                DetachedWindow win = (DetachedWindow)((Object)this.detachedWindowList.get(i));
                PartPlaceholder[] moreResults = this.collectPlaceholders(win.getChildren());
                if (moreResults.length <= 0) continue;
                int newLength = results.length + moreResults.length;
                PartPlaceholder[] newResults = new PartPlaceholder[newLength];
                System.arraycopy(results, 0, newResults, 0, results.length);
                System.arraycopy(moreResults, 0, newResults, results.length, moreResults.length);
                results = newResults;
            }
        }
        return results;
    }

    private PartPlaceholder[] collectPlaceholders(LayoutPart[] parts) {
        PartPlaceholder[] result = new PartPlaceholder[]{};
        int length = parts.length;
        for (int i = 0; i < length; ++i) {
            LayoutPart part = parts[i];
            if (part instanceof ILayoutContainer) {
                PartPlaceholder[] newParts = this.collectPlaceholders(((ILayoutContainer)((Object)part)).getChildren());
                PartPlaceholder[] newResult = new PartPlaceholder[result.length + newParts.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(newParts, 0, newResult, result.length, newParts.length);
                result = newResult;
                continue;
            }
            if (!(part instanceof PartPlaceholder)) continue;
            PartPlaceholder[] newResult = new PartPlaceholder[result.length + 1];
            System.arraycopy(result, 0, newResult, 0, result.length);
            newResult[result.length] = (PartPlaceholder)part;
            result = newResult;
        }
        return result;
    }

    public void collectViewPanes(List result) {
        this.collectViewPanes(result, this.mainLayout.getChildren());
        if (this.detachable) {
            int length = this.detachedWindowList.size();
            for (int i = 0; i < length; ++i) {
                DetachedWindow win = (DetachedWindow)((Object)this.detachedWindowList.get(i));
                this.collectViewPanes(result, win.getChildren());
            }
        }
    }

    private void collectViewPanes(List result, LayoutPart[] parts) {
        int length = parts.length;
        for (int i = 0; i < length; ++i) {
            LayoutPart part = parts[i];
            if (part instanceof ViewPane) {
                result.add(part);
                continue;
            }
            if (!(part instanceof ILayoutContainer)) continue;
            this.collectViewPanes(result, ((ILayoutContainer)((Object)part)).getChildren());
        }
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.disableAllDrag();
        Composite parent = this.mainLayout.getParent();
        Vector children = new Vector();
        this.collectViewPanes(children, this.mainLayout.getChildren());
        int length = this.detachedWindowList.size();
        for (int i = 0; i < length; ++i) {
            DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i));
            this.collectViewPanes(children, window.getChildren());
        }
        Enumeration enumeration = children.elements();
        while (enumeration.hasMoreElements()) {
            LayoutPart part = (LayoutPart)enumeration.nextElement();
            part.reparent(parent);
        }
        this.mainLayout.dispose();
        int length2 = this.detachedWindowList.size();
        for (int i = 0; i < length2; ++i) {
            DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i));
            window.close();
        }
        this.active = false;
    }

    void derefPart(LayoutPart part) {
        if (part instanceof ViewPane) {
            this.page.removeFastView(((ViewPane)part).getViewReference());
        }
        Window oldWindow = part.getWindow();
        ILayoutContainer oldContainer = part.getContainer();
        part.reparent(this.mainLayout.getParent());
        if (oldContainer == null) {
            return;
        }
        oldContainer.remove(part);
        LayoutPart[] children = oldContainer.getChildren();
        if (oldWindow instanceof WorkbenchWindow) {
            LayoutPart parent;
            ILayoutContainer parentContainer;
            boolean hasChildren;
            boolean bl = hasChildren = children != null && children.length > 0;
            if (hasChildren) {
                int childVisible = 0;
                for (int i = 0; i < children.length; ++i) {
                    if (children[i].getControl() == null) continue;
                    ++childVisible;
                }
                if (oldContainer instanceof ViewStack) {
                    ViewStack folder = (ViewStack)oldContainer;
                    if (childVisible == 0) {
                        ILayoutContainer parentContainer2 = folder.getContainer();
                        for (int i = 0; i < children.length; ++i) {
                            folder.remove(children[i]);
                            parentContainer2.add(children[i]);
                        }
                        hasChildren = false;
                    } else if (childVisible == 1) {
                        LayoutTree layout = this.mainLayout.getLayoutTree();
                        layout = layout.find(folder);
                        layout.setBounds(layout.getBounds());
                    }
                }
            }
            if (!hasChildren && oldContainer instanceof LayoutPart && (parentContainer = (parent = (LayoutPart)((Object)oldContainer)).getContainer()) != null) {
                parentContainer.remove(parent);
                parent.dispose();
            }
        } else if (oldWindow instanceof DetachedWindow) {
            if (children == null || children.length == 0) {
                oldWindow.getShell().setRedraw(true);
                oldWindow.close();
                this.detachedWindowList.remove(oldWindow);
            } else {
                boolean allInvisible = true;
                int length = children.length;
                for (int i = 0; i < length; ++i) {
                    if (children[i] instanceof PartPlaceholder) continue;
                    allInvisible = false;
                    break;
                }
                if (allInvisible) {
                    DetachedPlaceHolder placeholder = new DetachedPlaceHolder("", oldWindow.getShell().getBounds());
                    int length2 = children.length;
                    for (int i = 0; i < length2; ++i) {
                        oldContainer.remove(children[i]);
                        children[i].setContainer(placeholder);
                        placeholder.add(children[i]);
                    }
                    this.detachedPlaceHolderList.add(placeholder);
                    oldWindow.close();
                    this.detachedWindowList.remove(oldWindow);
                }
            }
        }
    }

    private void detach(LayoutPart source, int x, int y) {
        ILayoutContainer container;
        if (!this.detachable) {
            return;
        }
        LayoutPart part = source.getPart();
        Point size = part.getSize();
        if ((size.x == 0 || size.y == 0) && (container = part.getContainer()) instanceof LayoutPart) {
            size = ((LayoutPart)((Object)container)).getSize();
        }
        int width = Math.max(size.x, 150);
        int height = Math.max(size.y, 250);
        DetachedWindow window = new DetachedWindow(this.page);
        this.detachedWindowList.add(window);
        window.create();
        window.getShell().setBounds(x, y, width, height);
        window.open();
        if (part instanceof ViewStack) {
            window.getShell().setRedraw(false);
            this.parentWidget.setRedraw(false);
            PartPane visiblePart = ((ViewStack)part).getVisiblePart();
            LayoutPart[] children = ((ViewStack)part).getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof ViewPane)) continue;
                this.derefPart(children[i]);
                ViewPane pane = (ViewPane)children[i];
                window.getShell().setText(pane.getPartReference().getTitle());
                window.add(pane);
            }
            if (visiblePart != null) {
                this.bringPartToTop(visiblePart);
                ((LayoutPart)visiblePart).setFocus();
            }
            window.getShell().setRedraw(true);
            this.parentWidget.setRedraw(true);
        } else {
            this.derefPart(part);
            ViewPane pane = (ViewPane)part;
            window.getShell().setText(pane.getPartReference().getTitle());
            window.add(pane);
            part.setFocus();
        }
    }

    public void addDetachedPart(LayoutPart part) {
        if (!this.detachable) {
            this.addPart(part);
            return;
        }
        int width = 300;
        int height = 300;
        Rectangle bounds = this.parentWidget.getShell().getBounds();
        int x = bounds.x + (bounds.width - width) / 2;
        int y = bounds.y + (bounds.height - height) / 2;
        DetachedWindow window = new DetachedWindow(this.page);
        this.detachedWindowList.add(window);
        window.create();
        part.createControl((Composite)window.getShell());
        ViewPane pane = (ViewPane)part;
        window.getShell().setText(pane.getPartReference().getTitle());
        window.add(pane);
        window.getShell().setBounds(x, y, width, height);
        window.open();
        part.setFocus();
    }

    private void disableAllDrag() {
        DragUtil.removeDragTarget(null, this.dragTarget);
    }

    public void disposeSashes() {
        this.mainLayout.disposeSashes();
    }

    private void enableAllDrag() {
        DragUtil.addDragTarget(null, this.dragTarget);
    }

    private LayoutPart findPart(String id) {
        return this.findPart(id, null);
    }

    private LayoutPart findPart(String primaryId, String secondaryId) {
        int i;
        LayoutPart part;
        ArrayList matchingParts = new ArrayList();
        LayoutPart layoutPart = part = secondaryId != null ? this.findPart(primaryId, secondaryId, this.mainLayout.getChildren(), matchingParts) : this.findPart(primaryId, this.mainLayout.getChildren(), matchingParts);
        if (part != null) {
            return part;
        }
        int length = this.detachedWindowList.size();
        for (i = 0; i < length; ++i) {
            DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i));
            LayoutPart layoutPart2 = part = secondaryId != null ? this.findPart(primaryId, secondaryId, window.getChildren(), matchingParts) : this.findPart(primaryId, window.getChildren(), matchingParts);
            if (part == null) continue;
            return part;
        }
        for (i = 0; i < this.detachedPlaceHolderList.size(); ++i) {
            DetachedPlaceHolder holder = (DetachedPlaceHolder)this.detachedPlaceHolderList.get(i);
            LayoutPart layoutPart3 = part = secondaryId != null ? this.findPart(primaryId, secondaryId, holder.getChildren(), matchingParts) : this.findPart(primaryId, holder.getChildren(), matchingParts);
            if (part == null) continue;
            return part;
        }
        if (matchingParts.size() > 0) {
            Collections.sort(matchingParts);
            MatchingPart mostSignificantPart = (MatchingPart)matchingParts.get(0);
            if (mostSignificantPart != null) {
                return mostSignificantPart.part;
            }
        }
        return null;
    }

    private LayoutPart findPart(String id, LayoutPart[] parts, ArrayList matchingParts) {
        int length = parts.length;
        for (int i = 0; i < length; ++i) {
            LayoutPart part = parts[i];
            if (part.getID().equals(id)) {
                ViewPane pane;
                IViewReference ref;
                if (part instanceof ViewPane && (ref = (IViewReference)(pane = (ViewPane)part).getPartReference()).getSecondaryId() != null) continue;
                return part;
            }
            if (part instanceof PartPlaceholder && ((PartPlaceholder)part).hasWildCard()) {
                StringMatcher sm = new StringMatcher(part.getID(), true, false);
                if (!sm.match(id)) continue;
                matchingParts.add(new MatchingPart(part.getID(), null, part));
                continue;
            }
            if (part instanceof EditorSashContainer || !(part instanceof ILayoutContainer) || (part = this.findPart(id, ((ILayoutContainer)((Object)part)).getChildren(), matchingParts)) == null) continue;
            return part;
        }
        return null;
    }

    private LayoutPart findPart(String primaryId, String secondaryId, LayoutPart[] parts, ArrayList matchingParts) {
        int length = parts.length;
        for (int i = 0; i < length; ++i) {
            LayoutPart testPart;
            LayoutPart part = parts[i];
            if (part instanceof ILayoutContainer && (testPart = this.findPart(primaryId, secondaryId, ((ILayoutContainer)((Object)part)).getChildren(), matchingParts)) != null) {
                return testPart;
            }
            if (part instanceof ViewPane) {
                ViewPane pane = (ViewPane)part;
                IViewReference ref = (IViewReference)pane.getPartReference();
                if (!ref.getId().equals(primaryId) || ref.getSecondaryId() == null || !ref.getSecondaryId().equals(secondaryId)) continue;
                return part;
            }
            if (parts[i] instanceof PartPlaceholder) {
                String id = part.getID();
                String phSecondaryId = ViewFactory.extractSecondaryId(id);
                if (phSecondaryId == null) {
                    if (!id.equals(PartPlaceholder.WILD_CARD)) continue;
                    matchingParts.add(new MatchingPart(id, null, part));
                    continue;
                }
                String phPrimaryId = ViewFactory.extractPrimaryId(id);
                if (phPrimaryId.equals(primaryId) && phSecondaryId.equals(secondaryId)) {
                    return part;
                }
                StringMatcher sm = new StringMatcher(phPrimaryId, true, false);
                if (!sm.match(primaryId) || !(sm = new StringMatcher(phSecondaryId, true, false)).match(secondaryId)) continue;
                matchingParts.add(new MatchingPart(phPrimaryId, phSecondaryId, part));
                continue;
            }
            if (!(part instanceof EditorSashContainer)) continue;
        }
        return null;
    }

    public boolean hasPlaceholder(String id) {
        return this.hasPlaceholder(id, null);
    }

    public boolean hasPlaceholder(String primaryId, String secondaryId) {
        LayoutPart testPart = secondaryId == null ? this.findPart(primaryId) : this.findPart(primaryId, secondaryId);
        return testPart != null && testPart instanceof PartPlaceholder;
    }

    public ViewSashContainer getLayout() {
        return this.mainLayout;
    }

    public boolean isActive() {
        return this.active;
    }

    private boolean isFastView(IWorkbenchPartReference ref) {
        if (ref instanceof IViewReference) {
            WorkbenchPage page = (WorkbenchPage)ref.getPage();
            return page.isFastView((IViewReference)ref);
        }
        return false;
    }

    public boolean isZoomed() {
        return this.zoomPart != null;
    }

    public static float getDockingRatio(LayoutPart source, LayoutPart target) {
        if ((source instanceof ViewPane || source instanceof ViewStack) && target instanceof EditorSashContainer) {
            return 0.25f;
        }
        return 0.5f;
    }

    public boolean partChangeAffectsZoom(PartPane pane) {
        if (this.zoomPart == null) {
            return false;
        }
        if (pane.getWindow().getShell() != this.page.getWorkbenchWindow().getShell()) {
            return false;
        }
        if (pane.isZoomed()) {
            return false;
        }
        if (this.isFastView(pane.getPartReference())) {
            return false;
        }
        PartPane zoomPane = ((WorkbenchPartReference)this.zoomPart).getPane();
        return !(pane instanceof EditorPane) || !(zoomPane instanceof EditorPane) || !((EditorPane)pane).getWorkbook().equals(((EditorPane)zoomPane).getWorkbook());
    }

    public void removePart(LayoutPart part) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        Composite parent = this.mainLayout.getParent();
        part.reparent(parent);
        ILayoutContainer container = part.getContainer();
        if (container != null) {
            String placeHolderId = part.getPlaceHolderId();
            container.replace(part, new PartPlaceholder(placeHolderId));
            if (container == this.mainLayout) {
                return;
            }
            LayoutPart[] children = container.getChildren();
            if (children != null) {
                boolean allInvisible = true;
                int length = children.length;
                for (int i = 0; i < length; ++i) {
                    if (children[i] instanceof PartPlaceholder) continue;
                    allInvisible = false;
                    break;
                }
                if (allInvisible && container instanceof LayoutPart) {
                    LayoutPart cPart = (LayoutPart)((Object)container);
                    Window oldWindow = cPart.getWindow();
                    if (oldWindow instanceof WorkbenchWindow) {
                        if (container instanceof ViewStack) {
                            ((ViewStack)container).dispose();
                        }
                        ILayoutContainer parentContainer = cPart.getContainer();
                        ContainerPlaceholder placeholder = new ContainerPlaceholder(cPart.getID());
                        placeholder.setRealContainer(container);
                        parentContainer.replace(cPart, placeholder);
                    } else if (oldWindow instanceof DetachedWindow) {
                        DetachedPlaceHolder placeholder = new DetachedPlaceHolder("", oldWindow.getShell().getBounds());
                        int length2 = children.length;
                        for (int i = 0; i < length2; ++i) {
                            children[i].getContainer().remove(children[i]);
                            children[i].setContainer(placeholder);
                            placeholder.add(children[i]);
                        }
                        this.detachedPlaceHolderList.add(placeholder);
                        oldWindow.close();
                        this.detachedWindowList.remove(oldWindow);
                    }
                }
            }
        }
    }

    public void replacePlaceholderWithPart(LayoutPart part) {
        if (this.isZoomed()) {
            this.zoomOut();
        }
        PartPlaceholder[] placeholders = this.collectPlaceholders();
        int length = placeholders.length;
        for (int i = 0; i < length; ++i) {
            ILayoutContainer container;
            if (!placeholders[i].getCompoundId().equals(part.getCompoundId()) || (container = placeholders[i].getContainer()) == null) continue;
            if (container instanceof ContainerPlaceholder) {
                ContainerPlaceholder containerPlaceholder = (ContainerPlaceholder)container;
                ILayoutContainer parentContainer = containerPlaceholder.getContainer();
                container = (ILayoutContainer)((Object)containerPlaceholder.getRealContainer());
                if (container instanceof LayoutPart) {
                    parentContainer.replace(containerPlaceholder, (LayoutPart)((Object)container));
                }
                containerPlaceholder.setRealContainer(null);
            }
            container.replace(placeholders[i], part);
            return;
        }
    }

    public IStatus restoreState(IMemento memento) {
        IMemento childMem = memento.getChild("mainWindow");
        IStatus r = this.mainLayout.restoreState(childMem);
        if (this.detachable) {
            IMemento[] detachedWindows = memento.getChildren("detachedWindow");
            for (int nX = 0; nX < detachedWindows.length; ++nX) {
                DetachedWindow win = new DetachedWindow(this.page);
                this.detachedWindowList.add(win);
                win.restoreState(detachedWindows[nX]);
            }
            IMemento[] childrenMem = memento.getChildren("hiddenWindow");
            int length = childrenMem.length;
            for (int i = 0; i < length; ++i) {
                DetachedPlaceHolder holder = new DetachedPlaceHolder("", new Rectangle(0, 0, 0, 0));
                holder.restoreState(childrenMem[i]);
                this.detachedPlaceHolderList.add(holder);
            }
        }
        return r;
    }

    public IStatus saveState(IMemento memento) {
        IMemento childMem = memento.createChild("mainWindow");
        IStatus r = this.mainLayout.saveState(childMem);
        if (this.detachable) {
            int i;
            int length = this.detachedWindowList.size();
            for (i = 0; i < length; ++i) {
                DetachedWindow window = (DetachedWindow)((Object)this.detachedWindowList.get(i));
                childMem = memento.createChild("detachedWindow");
                window.saveState(childMem);
            }
            length = this.detachedPlaceHolderList.size();
            for (i = 0; i < length; ++i) {
                DetachedPlaceHolder holder = (DetachedPlaceHolder)this.detachedPlaceHolderList.get(i);
                childMem = memento.createChild("hiddenWindow");
                holder.saveState(childMem);
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void zoomIn(IWorkbenchPartReference ref) {
        PartPane pane = ((WorkbenchPartReference)ref).getPane();
        this.zoomPart = ref;
        if (pane instanceof ViewPane) {
            this.parentWidget.setRedraw(false);
            try {
                ILayoutContainer parentContainer = ((ViewPane)pane).getContainer();
                if (!(parentContainer instanceof ViewStack)) return;
                ViewStack parent = (ViewStack)parentContainer;
                Perspective persp = this.page.getActivePerspective();
                if (persp != null && ref instanceof IViewReference && this.page.isFastView((IViewReference)ref)) {
                    persp.hideFastViewSash();
                }
                this.mainLayout.zoomIn(parent);
                pane.setZoomed(true);
                return;
            }
            finally {
                this.parentWidget.setRedraw(true);
            }
        } else if (pane instanceof EditorPane) {
            this.parentWidget.setRedraw(false);
            try {
                EditorStack wb = ((EditorPane)pane).getWorkbook();
                EditorSashContainer ea = wb.getEditorArea();
                this.mainLayout.zoomIn(ea);
                ea.zoomIn(wb);
                wb.setZoomed(true);
                pane.setZoomed(true);
                return;
            }
            finally {
                this.parentWidget.setRedraw(true);
            }
        } else {
            this.zoomPart = null;
            return;
        }
    }

    public void zoomOut() {
        if (this.zoomPart == null) {
            return;
        }
        PartPane pane = ((WorkbenchPartReference)this.zoomPart).getPane();
        if (pane instanceof ViewPane) {
            this.parentWidget.setRedraw(false);
            this.mainLayout.zoomOut();
            pane.setZoomed(false);
            Perspective persp = this.page.getActivePerspective();
            if (persp != null && this.zoomPart instanceof IViewReference && this.page.isFastView((IViewReference)this.zoomPart)) {
                persp.showFastView((IViewReference)this.zoomPart);
            }
            this.parentWidget.setRedraw(true);
        } else if (pane instanceof EditorPane) {
            this.parentWidget.setRedraw(false);
            EditorStack wb = ((EditorPane)pane).getWorkbook();
            EditorSashContainer ea = wb.getEditorArea();
            wb.setZoomed(false);
            ea.zoomOut();
            this.mainLayout.zoomOut();
            pane.setZoomed(false);
            this.parentWidget.setRedraw(true);
        } else {
            this.parentWidget.setRedraw(false);
            this.mainLayout.zoomOut();
            this.parentWidget.setRedraw(true);
        }
        this.zoomPart = null;
    }

    static /* synthetic */ void access$200(PerspectiveHelper x0, LayoutPart x1, int x2, int x3) {
        x0.detach(x1, x2, x3);
    }

    private class MatchingPart
    implements Comparable {
        String pid;
        String sid;
        LayoutPart part;
        boolean hasWildcard;
        int len;

        MatchingPart(String pid, String sid, LayoutPart part) {
            this.pid = pid;
            this.sid = sid;
            this.part = part;
            this.len = (pid == null ? 0 : pid.length()) + (sid == null ? 0 : sid.length());
            this.hasWildcard = pid != null && pid.indexOf(PartPlaceholder.WILD_CARD) != -1 || sid != null && sid.indexOf(PartPlaceholder.WILD_CARD) != -1;
        }

        public int compareTo(Object a) {
            MatchingPart ma = (MatchingPart)a;
            if (this.hasWildcard && !ma.hasWildcard) {
                return -1;
            }
            if (!this.hasWildcard && ma.hasWildcard) {
                return 1;
            }
            return ma.len - this.len;
        }
    }
}

