/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.CyclePartAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.model.PerspectiveLabelProvider;

public class CyclePerspectiveAction
extends CyclePartAction
implements IPerspectiveListener {
    private PerspectiveLabelProvider labelProvider = new PerspectiveLabelProvider(false);

    public CyclePerspectiveAction(IWorkbenchWindow window, boolean forward) {
        super(window, forward);
        window.addPerspectiveListener(this);
        this.updateState();
    }

    protected void setText() {
        if (this.forward) {
            this.setText(WorkbenchMessages.getString("CyclePerspectiveAction.next.text"));
            this.setToolTipText(WorkbenchMessages.getString("CyclePerspectiveAction.next.toolTip"));
            WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.cycle_perspective_forward_action_context");
            this.setActionDefinitionId("org.eclipse.ui.window.nextPerspective");
        } else {
            this.setText(WorkbenchMessages.getString("CyclePerspectiveAction.prev.text"));
            this.setToolTipText(WorkbenchMessages.getString("CyclePerspectiveAction.prev.toolTip"));
            WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.cycle_perspective_backward_action_context");
            this.setActionDefinitionId("org.eclipse.ui.window.previousPerspective");
        }
    }

    public void dispose() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        this.getWorkbenchWindow().removePerspectiveListener(this);
        this.labelProvider.dispose();
        super.dispose();
    }

    public void activate(IWorkbenchPage page, Object selection) {
        if (selection != null) {
            IPerspectiveDescriptor persp = (IPerspectiveDescriptor)selection;
            page.setPerspective(persp);
        }
    }

    public void updateState() {
        WorkbenchPage page = (WorkbenchPage)this.getActivePage();
        if (page == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(page.getSortedPerspectives().length >= 1);
    }

    protected void addItems(Table table, WorkbenchPage page) {
        IPerspectiveDescriptor[] perspectives = page.getSortedPerspectives();
        for (int i = perspectives.length - 1; i >= 0; --i) {
            TableItem item = new TableItem(table, 0);
            IPerspectiveDescriptor desc = perspectives[i];
            item.setText(this.labelProvider.getText(desc));
            item.setImage(this.labelProvider.getImage(desc));
            item.setData((Object)desc);
        }
    }

    protected String getTableHeader() {
        return WorkbenchMessages.getString("CyclePerspectiveAction.header");
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.updateState();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }
}

