/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFile;
import org.eclipse.team.internal.ccvs.core.resources.SessionPropertySyncInfoCache;
import org.eclipse.team.internal.ccvs.core.resources.SyncInfoCache;
import org.eclipse.team.internal.ccvs.core.resources.SynchronizerSyncInfoCache;
import org.eclipse.team.internal.ccvs.core.syncinfo.BaserevInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.NotifyInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ReentrantLock;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.core.util.FileNameMatcher;
import org.eclipse.team.internal.ccvs.core.util.ResourceStateChangeListeners;
import org.eclipse.team.internal.ccvs.core.util.SyncFileWriter;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class EclipseSynchronizer
implements ReentrantLock.IFlushOperation {
    private static final String IS_DIRTY_INDICATOR = "d";
    private static final String NOT_DIRTY_INDICATOR = "c";
    private static final String RECOMPUTE_INDICATOR = "r";
    private static EclipseSynchronizer instance;
    private ILock lock = Platform.getJobManager().newLock();
    private ReentrantLock resourceLock = new ReentrantLock();
    private SynchronizerSyncInfoCache synchronizerCache = new SynchronizerSyncInfoCache();
    private SessionPropertySyncInfoCache sessionPropertyCache = new SessionPropertySyncInfoCache(this.synchronizerCache);

    EclipseSynchronizer() {
    }

    public static EclipseSynchronizer getInstance() {
        if (instance == null) {
            instance = new EclipseSynchronizer();
        }
        return instance;
    }

    public SyncInfoCache getSyncInfoCacheFor(IResource resource) {
        if (resource.exists() && resource.isLocal(0)) {
            return this.sessionPropertyCache;
        }
        return this.synchronizerCache;
    }

    private boolean isValid(IResource resource) {
        return resource.exists() || this.synchronizerCache.isPhantom(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolderSync(IContainer folder, FolderSyncInfo info) throws CVSException {
        Assert.isNotNull(info);
        if (folder.getType() == 8) {
            return;
        }
        if (!this.isValid((IResource)folder) && this.getFolderSync(folder.getParent()) == null) {
            throw new CVSException(4, -6, Policy.bind("EclipseSynchronizer.ErrorSettingFolderSync", folder.getFullPath().toString()));
        }
        ISchedulingRule rule = null;
        try {
            rule = this.beginBatching((ISchedulingRule)folder, null);
            try {
                this.beginOperation();
                FolderSyncInfo oldInfo = this.getFolderSync(folder);
                this.getSyncInfoCacheFor((IResource)folder).setCachedFolderSync(folder, info, true);
                if (oldInfo == null) {
                    this.adjustDirtyStateRecursively((IResource)folder, RECOMPUTE_INDICATOR);
                }
                this.folderChanged(folder);
            }
            finally {
                this.endOperation();
            }
            Object var7_6 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderSyncInfo getFolderSync(IContainer folder) throws CVSException {
        if (folder.getType() == 8 || !this.isValid((IResource)folder)) {
            return null;
        }
        try {
            this.beginOperation();
            this.cacheFolderSync(folder);
            FolderSyncInfo folderSyncInfo = this.getSyncInfoCacheFor((IResource)folder).getCachedFolderSync(folder);
            return folderSyncInfo;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFolderSync(IContainer folder) throws CVSException {
        if (folder.getType() == 8 || !this.isValid((IResource)folder)) {
            return;
        }
        ISchedulingRule rule = null;
        try {
            rule = this.beginBatching((ISchedulingRule)folder, null);
            try {
                this.beginOperation();
                this.cacheResourceSyncForChildren(folder, true);
                IResource[] children = folder.members(true);
                for (int i = 0; i < children.length; ++i) {
                    IResource resource = children[i];
                    this.resourceChanged(resource);
                    this.getSyncInfoCacheFor(resource).setCachedSyncBytes(resource, null, true);
                }
                this.getSyncInfoCacheFor((IResource)folder).setCachedFolderSync(folder, null, true);
                this.folderChanged(folder);
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
            finally {
                this.endOperation();
            }
            Object var8_8 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
            throw throwable;
        }
    }

    private void folderChanged(IContainer folder) {
        this.resourceLock.folderChanged(folder);
    }

    private void resourceChanged(IResource resource) {
        this.resourceLock.resourceChanged(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceSync(IResource resource, ResourceSyncInfo info) throws CVSException {
        Assert.isNotNull(info);
        IContainer parent = resource.getParent();
        if (parent == null || parent.getType() == 8 || !this.isValid((IResource)parent)) {
            throw new CVSException(4, -6, Policy.bind("EclipseSynchronizer.ErrorSettingResourceSync", resource.getFullPath().toString()));
        }
        ISchedulingRule rule = null;
        try {
            rule = this.beginBatching((ISchedulingRule)resource, null);
            try {
                this.beginOperation();
                this.cacheResourceSyncForChildren(parent, true);
                this.setCachedResourceSync(resource, info);
                this.resourceChanged(resource);
            }
            finally {
                this.endOperation();
            }
            Object var7_6 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
            throw throwable;
        }
    }

    public ResourceSyncInfo getResourceSync(IResource resource) throws CVSException {
        byte[] info = this.getSyncBytes(resource);
        if (info == null) {
            return null;
        }
        return new ResourceSyncInfo(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSyncBytes(IResource resource) throws CVSException {
        IContainer parent = resource.getParent();
        if (parent == null || parent.getType() == 8 || !this.isValid((IResource)parent)) {
            return null;
        }
        try {
            this.beginOperation();
            try {
                this.cacheResourceSyncForChildren(parent, false);
            }
            catch (CVSException e) {
                if (this.isCannotModifySynchronizer(e) || this.isResourceNotFound(e)) {
                    byte[] bytes = this.getSyncBytesFromDisk(resource);
                    if (!resource.exists() && bytes != null && !ResourceSyncInfo.isDeletion(bytes)) {
                        bytes = ResourceSyncInfo.convertToDeletion(bytes);
                    }
                    byte[] byArray = bytes;
                    this.endOperation();
                    return byArray;
                }
                throw e;
            }
            byte[] byArray = this.getCachedSyncBytes(resource);
            return byArray;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncBytes(IResource resource, byte[] syncBytes) throws CVSException {
        Assert.isNotNull(syncBytes);
        IContainer parent = resource.getParent();
        if (parent == null || parent.getType() == 8 || !this.isValid((IResource)parent)) {
            throw new CVSException(4, -6, Policy.bind("EclipseSynchronizer.ErrorSettingResourceSync", resource.getFullPath().toString()));
        }
        ISchedulingRule rule = null;
        try {
            rule = this.beginBatching((ISchedulingRule)resource, null);
            try {
                this.beginOperation();
                this.cacheResourceSyncForChildren(parent, true);
                this.setCachedSyncBytes(resource, syncBytes);
                this.resourceChanged(resource);
            }
            finally {
                this.endOperation();
            }
            Object var7_6 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResourceSync(IResource resource) throws CVSException {
        IContainer parent = resource.getParent();
        if (parent == null || parent.getType() == 8 || !this.isValid((IResource)parent)) {
            return;
        }
        ISchedulingRule rule = null;
        try {
            rule = this.beginBatching((ISchedulingRule)resource, null);
            try {
                this.beginOperation();
                this.cacheResourceSyncForChildren(parent, true);
                if (this.getCachedSyncBytes(resource) != null) {
                    this.setCachedSyncBytes(resource, null);
                    this.clearDirtyIndicator(resource);
                    this.resourceChanged(resource);
                }
            }
            finally {
                this.endOperation();
            }
            Object var6_5 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
            throw throwable;
        }
    }

    private void clearDirtyIndicator(IResource resource) throws CVSException {
        this.getSyncInfoCacheFor(resource).flushDirtyCache(resource);
        this.adjustDirtyStateRecursively((IResource)resource.getParent(), RECOMPUTE_INDICATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnored(IResource resource) throws CVSException {
        if (resource.getType() == 8 || resource.getType() == 4 || !resource.exists()) {
            return false;
        }
        try {
            this.beginOperation();
            FileNameMatcher matcher = this.cacheFolderIgnores(resource.getParent());
            boolean bl = matcher.match(resource.getName());
            return bl;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnored(IContainer folder, String pattern) throws CVSException {
        if (folder.getType() == 8 || !folder.exists()) {
            throw new CVSException(4, -6, Policy.bind("EclipseSynchronizer.ErrorSettingIgnorePattern", folder.getFullPath().toString()));
        }
        ISchedulingRule rule = null;
        try {
            rule = this.beginBatching((ISchedulingRule)folder.getFile((IPath)new Path(".cvsignore")), null);
            try {
                this.beginOperation();
                String[] ignores = SyncFileWriter.readCVSIgnoreEntries(folder);
                if (ignores != null) {
                    for (int i = 0; i < ignores.length; ++i) {
                        if (!ignores[i].equals(pattern)) continue;
                    }
                    String[] oldIgnores = ignores;
                    ignores = new String[oldIgnores.length + 1];
                    System.arraycopy(oldIgnores, 0, ignores, 0, oldIgnores.length);
                    ignores[oldIgnores.length] = pattern;
                } else {
                    ignores = new String[]{pattern};
                }
                this.setCachedFolderIgnores(folder, ignores);
                SyncFileWriter.writeCVSIgnoreEntries(folder, ignores);
                ArrayList possibleIgnores = new ArrayList();
                this.accumulateNonManagedChildren(folder, possibleIgnores);
                ResourceStateChangeListeners.getListener().resourceSyncInfoChanged(possibleIgnores.toArray(new IResource[possibleIgnores.size()]));
            }
            finally {
                this.endOperation();
            }
            Object var8_8 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResource[] members(IContainer folder) throws CVSException {
        if (!this.isValid((IResource)folder)) {
            return new IResource[0];
        }
        try {
            this.beginOperation();
            if (folder.getType() != 8) {
                this.cacheResourceSyncForChildren(folder, false);
            }
        }
        catch (CVSException e) {
            if (!this.isCannotModifySynchronizer(e) && !this.isResourceNotFound(e)) {
                throw e;
            }
        }
        finally {
            this.endOperation();
        }
        try {
            return folder.members(true);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    private boolean isCannotModifySynchronizer(CVSException e) {
        return e.getStatus().getCode() == 380 || e.getStatus().getCode() == -25;
    }

    private boolean isResourceNotFound(CVSException e) {
        return e.getStatus().getCode() == 368;
    }

    public ISchedulingRule beginBatching(ISchedulingRule resourceRule, IProgressMonitor monitor) {
        return this.resourceLock.acquire(resourceRule, this, monitor);
    }

    public void endBatching(ISchedulingRule rule, IProgressMonitor monitor) throws CVSException {
        this.resourceLock.release(rule, monitor);
    }

    public void flush(final ReentrantLock.ThreadInfo info, IProgressMonitor monitor) throws CVSException {
        if (info != null && !info.isEmpty()) {
            try {
                this.beginOperation();
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor pm) throws CoreException {
                        IStatus status = EclipseSynchronizer.this.commitCache(info, pm);
                        if (!status.isOK()) {
                            throw new CVSException(status);
                        }
                    }
                }, null, 0, monitor);
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
            finally {
                this.endOperation();
            }
        }
    }

    private void beginOperation() {
        if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
            return;
        }
        this.lock.acquire();
    }

    private void endOperation() {
        if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
            return;
        }
        this.lock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(IContainer root, boolean deep, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 10);
        ISchedulingRule rule = null;
        try {
            rule = this.beginBatching((ISchedulingRule)root, Policy.subMonitorFor(monitor, 1));
            try {
                this.beginOperation();
                try {
                    this.resourceLock.flush(Policy.subMonitorFor(monitor, 8));
                }
                finally {
                    this.sessionPropertyCache.purgeCache(root, deep);
                }
            }
            finally {
                this.endOperation();
            }
            Object var8_7 = null;
            if (rule != null) {
                this.endBatching(rule, Policy.subMonitorFor(monitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (rule != null) {
                this.endBatching(rule, Policy.subMonitorFor(monitor, 1));
            }
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deconfigure(IProject project, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        ISchedulingRule rule = null;
        try {
            rule = this.beginBatching((ISchedulingRule)project, Policy.subMonitorFor(monitor, 10));
            this.flush((IContainer)project, true, Policy.subMonitorFor(monitor, 80));
            this.purgeDirtyCache(project, Policy.subMonitorFor(monitor, 5));
            this.synchronizerCache.purgeCache((IContainer)project, true);
            Object var5_4 = null;
            if (rule != null) {
                this.endBatching(rule, Policy.subMonitorFor(monitor, 5));
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (rule != null) {
                this.endBatching(rule, Policy.subMonitorFor(monitor, 5));
            }
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreFilesChanged(IContainer[] roots) throws CVSException {
        for (int i = 0; i < roots.length; ++i) {
            Object var8_6;
            IContainer container = roots[i];
            ISchedulingRule rule = null;
            try {
                HashSet<IResource> changed = new HashSet<IResource>();
                rule = this.beginBatching((ISchedulingRule)container, null);
                try {
                    this.beginOperation();
                    changed.addAll(Arrays.asList(this.sessionPropertyCache.purgeCache(container, false)));
                }
                finally {
                    this.endOperation();
                }
                if (!changed.isEmpty()) {
                    ResourceStateChangeListeners.getListener().resourceSyncInfoChanged(changed.toArray(new IResource[changed.size()]));
                }
                var8_6 = null;
                if (rule == null) continue;
                this.endBatching(rule, null);
                continue;
            }
            catch (Throwable throwable) {
                var8_6 = null;
                if (rule != null) {
                    this.endBatching(rule, null);
                }
                throw throwable;
            }
        }
    }

    public void syncFilesChangedExternally(IContainer[] changedMetaFiles, IFile[] externalDeletions) throws CVSException {
        int i;
        ArrayList<Object> changed = new ArrayList<Object>();
        for (i = 0; i < changedMetaFiles.length; ++i) {
            IContainer container = changedMetaFiles[i];
            if (this.isWithinActiveOperationScope((IResource)container)) continue;
            changed.addAll(Arrays.asList(this.sessionPropertyCache.purgeCache(container, false)));
        }
        for (i = 0; i < externalDeletions.length; ++i) {
            IFile file = externalDeletions[i];
            if (this.isWithinActiveOperationScope((IResource)file)) continue;
            this.sessionPropertyCache.purgeCache(file.getParent(), false);
            changed.add(file);
        }
        if (!changed.isEmpty()) {
            ResourceStateChangeListeners.getListener().externalSyncInfoChange(changed.toArray(new IResource[changed.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean prepareForDeletion(IResource resource) throws CVSException {
        if (!resource.exists()) {
            return false;
        }
        ISchedulingRule rule = null;
        try {
            rule = this.beginBatching((ISchedulingRule)resource, null);
            try {
                this.beginOperation();
                this.adjustDirtyStateRecursively(resource, RECOMPUTE_INDICATOR);
                if (resource.getType() == 1) {
                    byte[] syncBytes = this.getSyncBytes(resource);
                    if (syncBytes != null) {
                        if (ResourceSyncInfo.isAddition(syncBytes)) {
                            this.deleteResourceSync(resource);
                        } else {
                            syncBytes = this.convertToDeletion(syncBytes);
                            this.synchronizerCache.setCachedSyncBytes(resource, syncBytes, true);
                        }
                        this.sessionPropertyCache.purgeResourceSyncCache(resource);
                        this.resourceChanged(resource);
                    }
                    boolean bl = false;
                    return bl;
                }
                IContainer container = (IContainer)resource;
                if (container.getType() == 4) {
                    this.synchronizerCache.flush((IProject)container);
                    boolean bl = false;
                    return bl;
                }
                FolderSyncInfo info = this.getFolderSync(container);
                if (info == null) {
                    boolean bl = false;
                    return bl;
                }
                this.synchronizerCache.setCachedFolderSync(container, info, true);
                this.folderChanged(container);
                byte[] syncBytes = this.getSyncBytes(resource);
                this.synchronizerCache.setCachedSyncBytes(resource, syncBytes, true);
                this.sessionPropertyCache.purgeResourceSyncCache((IResource)container);
                this.sessionPropertyCache.purgeCache(container, false);
                boolean bl = true;
                return bl;
            }
            finally {
                this.endOperation();
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (rule == null) throw throwable;
            this.endBatching(rule, null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeleted(IResource resource) throws CVSException {
        if (resource.exists()) {
            return;
        }
        try {
            this.beginOperation();
            this.adjustDirtyStateRecursively(resource, RECOMPUTE_INDICATOR);
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForDeletion(IResource resource, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        try {
            this.beginOperation();
            monitor.beginTask(null, 100);
            try {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource innerResource) throws CoreException {
                        try {
                            return EclipseSynchronizer.this.prepareForDeletion(innerResource);
                        }
                        catch (CVSException e) {
                            CVSProviderPlugin.log((CoreException)((Object)e));
                            throw new CoreException(e.getStatus());
                        }
                    }
                });
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
        }
        finally {
            this.endOperation();
            monitor.done();
        }
    }

    private void cacheResourceSyncForChildren(IContainer container, boolean canModifyWorkspace) throws CVSException {
        if (!this.getSyncInfoCacheFor((IResource)container).isResourceSyncInfoCached(container)) {
            byte[][] infos = this.isLinkedResource((IResource)container) ? (byte[][])null : SyncFileWriter.readAllResourceSync(container);
            try {
                if (infos != null) {
                    for (int i = 0; i < infos.length; ++i) {
                        byte[] syncBytes = infos[i];
                        Path name = new Path(this.getName(syncBytes));
                        Object resource = this.isFolder(syncBytes) ? container.getFolder((IPath)name) : container.getFile((IPath)name);
                        this.getSyncInfoCacheFor((IResource)resource).setCachedSyncBytes((IResource)resource, syncBytes, canModifyWorkspace);
                    }
                }
                this.getSyncInfoCacheFor((IResource)container).setResourceSyncInfoCached(container);
            }
            catch (CVSException e) {
                if (Policy.DEBUG_METAFILE_CHANGES) {
                    System.err.println("Failed to cache Entries for folder " + container.getFullPath());
                }
                throw e;
            }
        }
    }

    private void cacheFolderSync(IContainer container) throws CVSException {
        if (!this.getSyncInfoCacheFor((IResource)container).isFolderSyncInfoCached(container)) {
            FolderSyncInfo info = this.isLinkedResource((IResource)container) ? null : SyncFileWriter.readFolderSync(container);
            this.getSyncInfoCacheFor((IResource)container).setCachedFolderSync(container, info, false);
        }
    }

    private boolean isLinkedResource(IResource resource) {
        return CVSWorkspaceRoot.isLinkedResource(resource);
    }

    private byte[] getSyncBytesFromDisk(IResource resource) throws CVSException {
        byte[][] infos = SyncFileWriter.readAllResourceSync(resource.getParent());
        if (infos == null) {
            return null;
        }
        for (int i = 0; i < infos.length; ++i) {
            byte[] syncBytes = infos[i];
            if (!resource.getName().equals(this.getName(syncBytes))) continue;
            return syncBytes;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IStatus commitCache(ReentrantLock.ThreadInfo threadInfo, IProgressMonitor monitor) {
        if (threadInfo.isEmpty()) {
            return SyncInfoCache.STATUS_OK;
        }
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        try {
            IContainer folder;
            IResource[] changedResources = threadInfo.getChangedResources();
            IContainer[] changedFolders = threadInfo.getChangedFolders();
            HashSet<IContainer> dirtyParents = new HashSet<IContainer>();
            for (int i = 0; i < changedResources.length; ++i) {
                IResource resource = changedResources[i];
                IContainer folder2 = resource.getParent();
                dirtyParents.add(folder2);
            }
            monitor = Policy.monitorFor(monitor);
            int numDirty = dirtyParents.size();
            int numResources = changedFolders.length + numDirty;
            monitor.beginTask(null, numResources);
            if (monitor.isCanceled()) {
                monitor.subTask(Policy.bind("EclipseSynchronizer.UpdatingSyncEndOperationCancelled"));
            } else {
                monitor.subTask(Policy.bind("EclipseSynchronizer.UpdatingSyncEndOperation"));
            }
            for (int i = 0; i < changedFolders.length; ++i) {
                folder = changedFolders[i];
                if (folder.exists() && folder.getType() != 8) {
                    try {
                        FolderSyncInfo info = this.sessionPropertyCache.getCachedFolderSync(folder);
                        if (info == null) {
                            if (!this.isLinkedResource((IResource)folder)) {
                                SyncFileWriter.deleteFolderSync(folder);
                            }
                            dirtyParents.remove(folder);
                        } else {
                            SyncFileWriter.writeFolderSync(folder, info);
                        }
                    }
                    catch (CVSException e) {
                        try {
                            this.sessionPropertyCache.purgeCache(folder, true);
                        }
                        catch (CVSException pe) {
                            errors.add(pe.getStatus());
                        }
                        errors.add(e.getStatus());
                    }
                }
                monitor.worked(1);
            }
            monitor.worked(numDirty - dirtyParents.size());
            Iterator it = dirtyParents.iterator();
            while (it.hasNext()) {
                folder = (IContainer)it.next();
                if (folder.exists() && folder.getType() != 8) {
                    try {
                        ArrayList<byte[]> infos = new ArrayList<byte[]>();
                        IResource[] children = folder.members(true);
                        for (int i = 0; i < children.length; ++i) {
                            IResource resource = children[i];
                            byte[] syncBytes = this.getSyncBytes(resource);
                            if (syncBytes == null) continue;
                            infos.add(syncBytes);
                        }
                        if (infos.size() > 0 || !this.isLinkedResource((IResource)folder)) {
                            SyncFileWriter.writeAllResourceSync(folder, (byte[][])infos.toArray((T[])new byte[infos.size()][]));
                        }
                    }
                    catch (CVSException e) {
                        try {
                            this.sessionPropertyCache.purgeCache(folder, false);
                        }
                        catch (CVSException pe) {
                            errors.add(pe.getStatus());
                        }
                        errors.add(e.getStatus());
                    }
                    catch (CoreException e) {
                        try {
                            this.sessionPropertyCache.purgeCache(folder, false);
                        }
                        catch (CVSException pe) {
                            errors.add(pe.getStatus());
                        }
                        errors.add(e.getStatus());
                    }
                }
                monitor.worked(1);
            }
            monitor.subTask(Policy.bind("EclipseSynchronizer.NotifyingListeners"));
            HashSet<Object> allChanges = new HashSet<Object>();
            allChanges.addAll(Arrays.asList(changedResources));
            allChanges.addAll(Arrays.asList(changedFolders));
            allChanges.addAll(dirtyParents);
            IResource[] resources = allChanges.toArray(new IResource[allChanges.size()]);
            this.broadcastResourceStateChanges(resources);
            if (!errors.isEmpty()) {
                MultiStatus status = new MultiStatus("org.eclipse.team.cvs.core", -16, Policy.bind("EclipseSynchronizer.ErrorCommitting"), null);
                for (int i = 0; i < errors.size(); ++i) {
                    status.merge((IStatus)errors.get(i));
                }
                MultiStatus multiStatus = status;
                return multiStatus;
            }
            IStatus iStatus = SyncInfoCache.STATUS_OK;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    void broadcastResourceStateChanges(IResource[] resources) {
        if (resources.length > 0) {
            ResourceStateChangeListeners.getListener().resourceSyncInfoChanged(resources);
        }
    }

    private byte[] getCachedSyncBytes(IResource resource) throws CVSException {
        return this.getSyncInfoCacheFor(resource).getCachedSyncBytes(resource);
    }

    private void setCachedSyncBytes(IResource resource, byte[] syncBytes) throws CVSException {
        this.getSyncInfoCacheFor(resource).setCachedSyncBytes(resource, syncBytes, true);
        this.resourceChanged(resource);
    }

    private void setCachedResourceSync(IResource resource, ResourceSyncInfo info) throws CVSException {
        byte[] syncBytes = null;
        if (info != null) {
            syncBytes = info.getBytes();
        }
        this.getSyncInfoCacheFor(resource).setCachedSyncBytes(resource, syncBytes, true);
    }

    private FileNameMatcher cacheFolderIgnores(IContainer container) throws CVSException {
        return this.sessionPropertyCache.cacheFolderIgnores(container);
    }

    private void setCachedFolderIgnores(IContainer container, String[] ignores) throws CVSException {
        this.sessionPropertyCache.setCachedFolderIgnores(container, ignores);
    }

    private void accumulateNonManagedChildren(IContainer folder, List possibleIgnores) throws CVSException {
        try {
            IResource child;
            this.cacheResourceSyncForChildren(folder, true);
            IResource[] children = folder.members();
            ArrayList<IResource> folders = new ArrayList<IResource>();
            for (int i = 0; i < children.length; ++i) {
                child = children[i];
                if (this.getCachedSyncBytes(child) == null) {
                    possibleIgnores.add(child);
                }
                if (child.getType() == 1) continue;
                folders.add(child);
            }
            Iterator iter = folders.iterator();
            while (iter.hasNext()) {
                child = (IContainer)iter.next();
                this.accumulateNonManagedChildren((IContainer)child, possibleIgnores);
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    public void setNotifyInfo(IResource resource, NotifyInfo info) throws CVSException {
        NotifyInfo[] infos = SyncFileWriter.readAllNotifyInfo(resource.getParent());
        if (infos == null) {
            if (info == null) {
                return;
            }
            infos = new NotifyInfo[]{info};
        } else {
            HashMap<String, NotifyInfo> infoMap = new HashMap<String, NotifyInfo>();
            for (int i = 0; i < infos.length; ++i) {
                NotifyInfo notifyInfo = infos[i];
                infoMap.put(notifyInfo.getName(), notifyInfo);
            }
            if (info == null) {
                infoMap.remove(resource.getName());
            } else {
                infoMap.put(info.getName(), info);
            }
            NotifyInfo[] newInfos = new NotifyInfo[infoMap.size()];
            int i = 0;
            Iterator iter = infoMap.values().iterator();
            while (iter.hasNext()) {
                newInfos[i++] = (NotifyInfo)iter.next();
            }
            infos = newInfos;
        }
        SyncFileWriter.writeAllNotifyInfo(resource.getParent(), infos);
    }

    public NotifyInfo getNotifyInfo(IResource resource) throws CVSException {
        NotifyInfo[] infos = SyncFileWriter.readAllNotifyInfo(resource.getParent());
        if (infos == null) {
            return null;
        }
        for (int i = 0; i < infos.length; ++i) {
            NotifyInfo notifyInfo = infos[i];
            if (!notifyInfo.getName().equals(resource.getName())) continue;
            return notifyInfo;
        }
        return null;
    }

    public void deleteNotifyInfo(IResource resource) throws CVSException {
        NotifyInfo[] infos = SyncFileWriter.readAllNotifyInfo(resource.getParent());
        if (infos == null) {
            return;
        }
        HashMap<String, NotifyInfo> infoMap = new HashMap<String, NotifyInfo>();
        for (int i = 0; i < infos.length; ++i) {
            NotifyInfo notifyInfo = infos[i];
            infoMap.put(notifyInfo.getName(), notifyInfo);
        }
        infoMap.remove(resource.getName());
        NotifyInfo[] newInfos = new NotifyInfo[infoMap.size()];
        int i = 0;
        Iterator iter = infoMap.values().iterator();
        while (iter.hasNext()) {
            newInfos[i++] = (NotifyInfo)iter.next();
        }
        SyncFileWriter.writeAllNotifyInfo(resource.getParent(), newInfos);
    }

    public void setBaserevInfo(IResource resource, BaserevInfo info) throws CVSException {
        BaserevInfo[] infos = SyncFileWriter.readAllBaserevInfo(resource.getParent());
        if (infos == null) {
            infos = new BaserevInfo[]{info};
        } else {
            HashMap<String, BaserevInfo> infoMap = new HashMap<String, BaserevInfo>();
            for (int i = 0; i < infos.length; ++i) {
                infoMap.put(infos[i].getName(), infos[i]);
            }
            infoMap.put(info.getName(), info);
            BaserevInfo[] newInfos = new BaserevInfo[infoMap.size()];
            int i = 0;
            Iterator iter = infoMap.values().iterator();
            while (iter.hasNext()) {
                newInfos[i++] = (BaserevInfo)iter.next();
            }
            infos = newInfos;
        }
        SyncFileWriter.writeAllBaserevInfo(resource.getParent(), infos);
    }

    public BaserevInfo getBaserevInfo(IResource resource) throws CVSException {
        BaserevInfo[] infos = SyncFileWriter.readAllBaserevInfo(resource.getParent());
        if (infos == null) {
            return null;
        }
        for (int i = 0; i < infos.length; ++i) {
            BaserevInfo info = infos[i];
            if (!info.getName().equals(resource.getName())) continue;
            return info;
        }
        return null;
    }

    public void deleteBaserevInfo(IResource resource) throws CVSException {
        BaserevInfo[] infos = SyncFileWriter.readAllBaserevInfo(resource.getParent());
        if (infos == null) {
            return;
        }
        HashMap<String, BaserevInfo> infoMap = new HashMap<String, BaserevInfo>();
        for (int i = 0; i < infos.length; ++i) {
            infoMap.put(infos[i].getName(), infos[i]);
        }
        infoMap.remove(resource.getName());
        BaserevInfo[] newInfos = new BaserevInfo[infoMap.size()];
        int i = 0;
        Iterator iter = infoMap.values().iterator();
        while (iter.hasNext()) {
            newInfos[i++] = (BaserevInfo)iter.next();
        }
        SyncFileWriter.writeAllBaserevInfo(resource.getParent(), newInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFileToBaseDirectory(IFile file, IProgressMonitor monitor) throws CVSException {
        ISchedulingRule rule;
        block5: {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100);
            rule = null;
            try {
                block6: {
                    rule = this.beginBatching((ISchedulingRule)file, Policy.subMonitorFor(monitor, 10));
                    ResourceSyncInfo info = this.getResourceSync((IResource)file);
                    if (info == null || info.isAdded()) break block6;
                    if (!info.isDeleted()) break block7;
                }
                Object var6_5 = null;
                if (rule == null) break block5;
                this.endBatching(rule, Policy.subMonitorFor(monitor, 10));
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (rule != null) {
                    this.endBatching(rule, Policy.subMonitorFor(monitor, 10));
                }
                monitor.done();
                throw throwable;
            }
        }
        monitor.done();
        {
            block7: {
                return;
            }
            SyncFileWriter.writeFileToBaseDirectory(file, Policy.subMonitorFor(monitor, 80));
            this.resourceChanged((IResource)file);
        }
        Object var6_6 = null;
        if (rule != null) {
            this.endBatching(rule, Policy.subMonitorFor(monitor, 10));
        }
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreFileFromBaseDirectory(IFile file, IProgressMonitor monitor) throws CVSException {
        ISchedulingRule rule;
        block5: {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100);
            rule = null;
            try {
                block6: {
                    rule = this.beginBatching((ISchedulingRule)file, Policy.subMonitorFor(monitor, 10));
                    ResourceSyncInfo info = this.getResourceSync((IResource)file);
                    if (info == null) break block6;
                    if (!info.isAdded()) break block7;
                }
                Object var6_5 = null;
                if (rule == null) break block5;
                this.endBatching(rule, Policy.subMonitorFor(monitor, 10));
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (rule != null) {
                    this.endBatching(rule, Policy.subMonitorFor(monitor, 10));
                }
                monitor.done();
                throw throwable;
            }
        }
        monitor.done();
        {
            block7: {
                return;
            }
            SyncFileWriter.restoreFileFromBaseDirectory(file, Policy.subMonitorFor(monitor, 80));
            this.resourceChanged((IResource)file);
        }
        Object var6_6 = null;
        if (rule != null) {
            this.endBatching(rule, Policy.subMonitorFor(monitor, 10));
        }
        monitor.done();
    }

    public void deleteFileFromBaseDirectory(IFile file, IProgressMonitor monitor) throws CVSException {
        ResourceSyncInfo info = this.getResourceSync((IResource)file);
        if (info == null || info.isAdded()) {
            return;
        }
        SyncFileWriter.deleteFileFromBaseDirectory(file, monitor);
    }

    public boolean isSyncInfoLoaded(IResource[] resources, int depth) throws CVSException {
        IContainer[] folders = this.getParentFolders(resources, depth);
        for (int i = 0; i < folders.length; ++i) {
            IContainer parent = folders[i];
            if (this.getSyncInfoCacheFor((IResource)parent).isSyncInfoLoaded(parent)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureSyncInfoLoaded(IResource[] resources, int depth) throws CVSException {
        IContainer[] folders = this.getParentFolders(resources, depth);
        for (int i = 0; i < folders.length; ++i) {
            Object var9_7;
            IContainer parent = folders[i];
            ISchedulingRule rule = null;
            try {
                rule = this.beginBatching((ISchedulingRule)parent, null);
                try {
                    this.beginOperation();
                    this.cacheResourceSyncForChildren(parent, true);
                    this.cacheFolderSync(parent);
                    this.cacheFolderIgnores(parent);
                }
                finally {
                    this.endOperation();
                }
                var9_7 = null;
                if (rule == null) continue;
                this.endBatching(rule, null);
                continue;
            }
            catch (Throwable throwable) {
                var9_7 = null;
                if (rule != null) {
                    this.endBatching(rule, null);
                }
                throw throwable;
            }
        }
    }

    private IContainer[] getParentFolders(IResource[] resources, int depth) throws CVSException {
        final HashSet<Object> folders = new HashSet<Object>();
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            folders.add(resource.getProject());
            if (resource.getType() != 4) {
                folders.add(resource.getParent());
            }
            if (depth == 0) continue;
            try {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource innerResource) throws CoreException {
                        if (innerResource.getType() == 2) {
                            folders.add(innerResource);
                        }
                        return true;
                    }
                }, depth, false);
                continue;
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
        }
        return folders.toArray(new IContainer[folders.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ISchedulingRule resourceRule, ICVSRunnable runnable, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        ISchedulingRule rule = this.beginBatching(resourceRule, Policy.subMonitorFor(monitor, 10));
        try {
            runnable.run(Policy.subMonitorFor(monitor, 80));
            Object var6_5 = null;
            if (rule != null) {
                this.endBatching(rule, Policy.subMonitorFor(monitor, 10));
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (rule != null) {
                this.endBatching(rule, Policy.subMonitorFor(monitor, 10));
            }
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public void run(ICVSRunnable runnable, IProgressMonitor monitor) throws CVSException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.run((ISchedulingRule)root, runnable, monitor);
    }

    public boolean isEdited(IFile resource) {
        return SyncFileWriter.isEdited(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustDirtyStateRecursively(IResource resource, String indicator) throws CVSException {
        if (resource.getType() == 8) {
            return;
        }
        try {
            this.beginOperation();
            if (this.getSyncInfoCacheFor(resource).cachesDirtyState()) {
                if (indicator == this.getDirtyIndicator(resource)) {
                    return;
                }
                this.getSyncInfoCacheFor(resource).setDirtyIndicator(resource, indicator);
            }
            if (Policy.DEBUG_DIRTY_CACHING) {
                EclipseSynchronizer.debug(resource, indicator, "adjusting dirty state");
            }
            IContainer parent = resource.getParent();
            if (indicator == NOT_DIRTY_INDICATOR) {
                this.adjustDirtyStateRecursively((IResource)parent, RECOMPUTE_INDICATOR);
            }
            if (indicator == RECOMPUTE_INDICATOR) {
                this.adjustDirtyStateRecursively((IResource)parent, RECOMPUTE_INDICATOR);
            }
            if (indicator == IS_DIRTY_INDICATOR) {
                this.adjustDirtyStateRecursively((IResource)parent, indicator);
            }
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDirtyIndicator(IResource resource) throws CVSException {
        try {
            this.beginOperation();
            String string = this.getSyncInfoCacheFor(resource).getDirtyIndicator(resource);
            return string;
        }
        finally {
            this.endOperation();
        }
    }

    protected void setDirtyIndicator(IResource resource, boolean modified) throws CVSException {
        String indicator = modified ? IS_DIRTY_INDICATOR : NOT_DIRTY_INDICATOR;
        this.adjustDirtyStateRecursively(resource, indicator);
    }

    private String getName(byte[] syncBytes) throws CVSException {
        return ResourceSyncInfo.getName(syncBytes);
    }

    private boolean isFolder(byte[] syncBytes) {
        return ResourceSyncInfo.isFolder(syncBytes);
    }

    private byte[] convertToDeletion(byte[] syncBytes) throws CVSException {
        return ResourceSyncInfo.convertToDeletion(syncBytes);
    }

    public void createdByMove(IFile file) throws CVSException {
        this.deleteResourceSync((IResource)file);
    }

    public static void debug(IResource resource, String indicator, String string) {
        String di = IS_DIRTY_INDICATOR;
        di = indicator == IS_DIRTY_INDICATOR ? "dirty" : (indicator == NOT_DIRTY_INDICATOR ? "clean" : "needs recomputing");
        System.out.println("[" + string + ":" + di + "]  " + resource.getFullPath());
    }

    public static void debug(IResource resource, boolean modified, String string) {
        EclipseSynchronizer.debug(resource, modified ? IS_DIRTY_INDICATOR : NOT_DIRTY_INDICATOR, string);
    }

    public int getModificationState(IResource resource) throws CVSException {
        String indicator = this.getDirtyIndicator(resource);
        if (Policy.DEBUG_DIRTY_CACHING) {
            EclipseSynchronizer.debug(resource, indicator, "getModificationState");
        }
        if (indicator == null || indicator == RECOMPUTE_INDICATOR) {
            return 0;
        }
        if (indicator == IS_DIRTY_INDICATOR) {
            return 2;
        }
        if (indicator == NOT_DIRTY_INDICATOR) {
            return 1;
        }
        return 0;
    }

    public boolean isWithinActiveOperationScope(IResource resource) {
        return this.resourceLock.isWithinActiveOperationScope(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeStamp(EclipseFile cvsFile, long time) throws CVSException {
        ISchedulingRule rule = null;
        IFile file = (IFile)cvsFile.getIResource();
        try {
            rule = this.beginBatching((ISchedulingRule)file, null);
            try {
                this.beginOperation();
                try {
                    file.setLocalTimeStamp(time);
                    this.setModified(cvsFile, 1);
                }
                catch (CoreException e) {
                    throw CVSException.wrapException(e);
                }
                this.resourceChanged((IResource)file);
            }
            finally {
                this.endOperation();
            }
            Object var9_7 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (rule != null) {
                this.endBatching(rule, null);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMove(IResource resource) throws CVSException {
        block6: {
            try {
                this.beginOperation();
                if (resource.getType() == 1) {
                    this.sessionPropertyCache.purgeResourceSyncCache(resource);
                    break block6;
                }
                IContainer container = (IContainer)resource;
                this.sessionPropertyCache.purgeCache(container, true);
                try {
                    container.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (EclipseSynchronizer.this.getSyncBytes(resource) != null) {
                                EclipseSynchronizer.this.resourceChanged(resource);
                            }
                            if (resource.getType() != 1 && EclipseSynchronizer.this.getFolderSync((IContainer)resource) != null) {
                                EclipseSynchronizer.this.folderChanged((IContainer)resource);
                                return true;
                            }
                            return false;
                        }
                    });
                }
                catch (CoreException e) {
                    throw CVSException.wrapException(e);
                }
                this.flush(container, true, null);
            }
            finally {
                this.endOperation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMoveDelete(ICVSRunnable runnable, IProgressMonitor monitor) throws CVSException {
        ISchedulingRule rule = null;
        try {
            monitor.beginTask(null, 100);
            rule = this.beginBatching(null, null);
            try {
                this.beginOperation();
                runnable.run(Policy.subMonitorFor(monitor, 95));
            }
            finally {
                this.endOperation();
            }
            Object var6_5 = null;
            if (rule != null) {
                this.endBatching(rule, Policy.subMonitorFor(monitor, 5));
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (rule != null) {
                this.endBatching(rule, Policy.subMonitorFor(monitor, 5));
            }
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setModified(EclipseFile cvsFile, int modificationState) throws CVSException {
        try {
            this.beginOperation();
            boolean dirty = modificationState == 0 ? cvsFile.isDirty() : modificationState == 2;
            this.setDirtyIndicator(cvsFile.getIResource(), dirty);
            boolean bl = dirty;
            return bl;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModified(ICVSFolder cvsFolder, boolean modified) throws CVSException {
        try {
            this.beginOperation();
            IContainer folder = (IContainer)cvsFolder.getIResource();
            boolean okToSet = !modified;
            ICVSResource[] children = cvsFolder.members(123);
            for (int i = 0; i < children.length; ++i) {
                IResource resource = children[i].getIResource();
                if (modified) {
                    if (this.getDirtyIndicator(resource) != IS_DIRTY_INDICATOR) continue;
                    okToSet = true;
                    break;
                }
                if (this.getDirtyIndicator(resource) == NOT_DIRTY_INDICATOR) continue;
                okToSet = false;
                break;
            }
            if (okToSet) {
                this.setDirtyIndicator((IResource)folder, modified);
            }
        }
        finally {
            this.endOperation();
        }
    }

    public boolean wasPhantom(IResource resource) {
        if (resource.exists()) {
            try {
                return this.synchronizerCache.getCachedSyncBytes(resource) != null || resource.getType() == 2 && this.synchronizerCache.hasCachedFolderSync((IContainer)resource);
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourcesRecreated(IResource[] resources, IProgressMonitor monitor) throws CVSException {
        if (resources.length == 0) {
            return;
        }
        ISchedulingRule rule = null;
        ISchedulingRule projectsRule = this.getProjectRule(resources);
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100);
            rule = this.beginBatching(projectsRule, monitor);
            for (int i = 0; i < resources.length; ++i) {
                IResource resource = resources[i];
                try {
                    this.created(resource);
                    continue;
                }
                catch (CVSException e) {
                    CVSProviderPlugin.log((CoreException)((Object)e));
                }
            }
            Object var9_8 = null;
            if (rule != null) {
                this.endBatching(rule, Policy.subMonitorFor(monitor, 5));
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (rule != null) {
                this.endBatching(rule, Policy.subMonitorFor(monitor, 5));
            }
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private ISchedulingRule getProjectRule(IResource[] resources) {
        HashSet<IProject> set = new HashSet<IProject>();
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            set.add(resource.getProject());
        }
        IProject[] projects = set.toArray(new IProject[set.size()]);
        if (projects.length == 1) {
            return projects[0];
        }
        return new MultiRule((ISchedulingRule[])projects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void created(IResource resource) throws CVSException {
        try {
            this.beginOperation();
            if (resource.exists()) {
                this.restoreResourceSync(resource);
                if (resource.getType() == 2) {
                    this.restoreFolderSync((IFolder)resource);
                }
            }
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreFolderSync(IFolder folder) throws CVSException {
        try {
            this.beginOperation();
            FolderSyncInfo folderInfo = this.synchronizerCache.getCachedFolderSync((IContainer)folder);
            if (folderInfo != null) {
                FolderSyncInfo newFolderInfo;
                if (!(!folder.getFolder("CVS").exists() || (newFolderInfo = this.getFolderSync((IContainer)folder)).getRoot().equals(folderInfo.getRoot()) && newFolderInfo.getRepository().equals(folderInfo.getRepository()))) {
                    ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)folder);
                    ICVSResource[] children = cvsFolder.members(16);
                    for (int i = 0; i < children.length; ++i) {
                        ICVSResource resource = children[i];
                        this.deleteResourceSync(resource.getIResource());
                    }
                }
                this.setFolderSync((IContainer)folder, folderInfo);
                this.sessionPropertyCache.purgeDirtyCache((IResource)folder);
                IResource[] members = this.members((IContainer)folder);
                for (int i = 0; i < members.length; ++i) {
                    IResource resource = members[i];
                    if (this.getSyncBytes(resource) == null) continue;
                    this.resourceChanged(resource);
                    break;
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                this.endOperation();
            }
            finally {
                this.synchronizerCache.flush(folder);
            }
            throw throwable;
        }
        try {
            this.endOperation();
        }
        finally {
            this.synchronizerCache.flush(folder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreResourceSync(IResource resource) throws CVSException {
        try {
            this.beginOperation();
            byte[] syncBytes = this.synchronizerCache.getCachedSyncBytes(resource);
            if (syncBytes != null) {
                byte[] newBytes;
                if (!ResourceSyncInfo.isFolder(syncBytes)) {
                    syncBytes = ResourceSyncInfo.convertFromDeletion(syncBytes);
                }
                if ((newBytes = this.getSyncBytes(resource)) != null && !ResourceSyncInfo.isFolder(newBytes)) {
                    newBytes = ResourceSyncInfo.convertFromDeletion(newBytes);
                }
                if (newBytes == null || Util.equals(syncBytes, newBytes)) {
                    this.setSyncBytes(resource, syncBytes);
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.endOperation();
            }
            finally {
                this.synchronizerCache.setCachedSyncBytes(resource, null, true);
            }
            throw throwable;
        }
        try {
            this.endOperation();
        }
        finally {
            this.synchronizerCache.setCachedSyncBytes(resource, null, true);
        }
    }

    private void purgeDirtyCache(IProject project, IProgressMonitor monitor) throws CVSException {
        this.sessionPropertyCache.purgeDirtyCache((IResource)project);
    }
}

