/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.standalone.CmdLineArgs;
import org.eclipse.update.standalone.ScriptedCommand;

public class StandaloneUpdateApplication
implements IPlatformRunnable {
    public static final Integer EXIT_ERROR = new Integer(1);
    private static boolean loggedException = false;

    public Object run(Object args) throws Exception {
        if (args == null) {
            return EXIT_ERROR;
        }
        if (args instanceof String[]) {
            String[] params = (String[])args;
            CmdLineArgs cmdLineArgs = new CmdLineArgs(params);
            ScriptedCommand cmd = cmdLineArgs.getCommand();
            if (cmd == null) {
                System.out.println(Policy.bind("Standalone.cmdFailed", Platform.getLogFileLocation().toOSString()));
                return EXIT_ERROR;
            }
            loggedException = false;
            boolean result = cmd.run();
            if (result) {
                if (loggedException) {
                    System.out.println(Policy.bind("Standalone.cmdCompleteWithErrors", Platform.getLogFileLocation().toOSString()));
                } else {
                    System.out.println(Policy.bind("Standalone.cmdOK"));
                }
                return IPlatformRunnable.EXIT_OK;
            }
            if (loggedException) {
                System.out.println(Policy.bind("Standalone.cmdFailed", Platform.getLogFileLocation().toOSString()));
            } else {
                System.out.println(Policy.bind("Standalone.cmdFailedNoLog"));
            }
            return EXIT_ERROR;
        }
        return EXIT_ERROR;
    }

    public static void exceptionLogged() {
        loggedException = true;
    }
}

