/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class OpenWorkspaceAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String PROP_EXIT_DATA = "eclipse.exitdata";
    private static final String CMD_DATA = "-data";
    private static final String CMD_VMARGS = "-vmargs";
    private static final String NEW_LINE = "\n";
    private IWorkbenchWindow window;

    public OpenWorkspaceAction(IWorkbenchWindow window) {
        super(IDEWorkbenchMessages.getString("OpenWorkspaceAction.text"));
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
        this.setToolTipText(IDEWorkbenchMessages.getString("OpenWorkspaceAction.toolTip"));
        this.setActionDefinitionId("org.eclipse.ui.file.openWorkspace");
    }

    public void run() {
        String path = this.promptForWorkspace();
        if (path == null) {
            return;
        }
        String command_line = this.buildCommandLine(path);
        if (command_line == null) {
            return;
        }
        System.setProperty(PROP_EXIT_CODE, Integer.toString(24));
        System.setProperty(PROP_EXIT_DATA, command_line);
        this.window.getWorkbench().restart();
    }

    private String promptForWorkspace() {
        ChooseWorkspaceData data = new ChooseWorkspaceData(Platform.getInstanceLocation().getURL());
        ChooseWorkspaceDialog dialog = new ChooseWorkspaceDialog(this.window.getShell(), data, true);
        dialog.prompt(true);
        String selection = data.getSelection();
        if (selection == null) {
            return null;
        }
        data.writePersistedData();
        return selection;
    }

    private String buildCommandLine(String workspace) {
        String property = System.getProperty(PROP_VM);
        if (property == null) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)IDEWorkbenchMessages.getString("OpenWorkspaceAction.errorTitle"), (String)IDEWorkbenchMessages.format("OpenWorkspaceAction.errorMessage", new Object[]{PROP_VM}));
            return null;
        }
        StringBuffer result = new StringBuffer(512);
        result.append(property);
        result.append(NEW_LINE);
        String vmargs = System.getProperty(PROP_VMARGS);
        if (vmargs != null) {
            result.append(vmargs);
        }
        if ((property = System.getProperty(PROP_COMMANDS)) == null) {
            result.append(CMD_DATA);
            result.append(NEW_LINE);
            result.append(workspace);
            result.append(NEW_LINE);
        } else {
            int cmd_data_pos = property.indexOf(CMD_DATA);
            if (cmd_data_pos != -1) {
                result.append(property.substring(0, cmd_data_pos += CMD_DATA.length() + 1));
                result.append(workspace);
                result.append(property.substring(property.indexOf(10, cmd_data_pos)));
            } else {
                result.append(CMD_DATA);
                result.append(NEW_LINE);
                result.append(workspace);
                result.append(NEW_LINE);
                result.append(property);
            }
        }
        if (vmargs != null) {
            result.append(CMD_VMARGS);
            result.append(NEW_LINE);
            result.append(vmargs);
        }
        return result.toString();
    }

    public void dispose() {
        this.window = null;
    }
}

