/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class ClassScope
extends Scope {
    public TypeDeclaration referenceContext;

    public ClassScope(Scope parent, TypeDeclaration context) {
        super(3, parent);
        this.referenceContext = context;
    }

    void buildAnonymousTypeBinding(SourceTypeBinding enclosingType, ReferenceBinding supertype) {
        LocalTypeBinding anonymousType = this.buildLocalType(enclosingType, enclosingType.fPackage);
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (supertype.isInterface()) {
            sourceType.superclass = this.getJavaLangObject();
            sourceType.superInterfaces = new ReferenceBinding[]{supertype};
        } else {
            sourceType.superclass = supertype;
            sourceType.superInterfaces = TypeConstants.NoSuperInterfaces;
        }
        this.connectMemberTypes();
        this.buildFieldsAndMethods();
        anonymousType.faultInTypesForFieldsAndMethods();
        sourceType.verifyMethods(this.environment().methodVerifier());
    }

    private void buildFields() {
        FieldBinding fieldBinding;
        int i;
        if (this.referenceContext.fields == null) {
            this.referenceContext.binding.fields = TypeConstants.NoFields;
            return;
        }
        FieldDeclaration[] fields = this.referenceContext.fields;
        int size = fields.length;
        int count = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            if (!fields[i2].isField()) continue;
            ++count;
        }
        FieldBinding[] fieldBindings = new FieldBinding[count];
        HashtableOfObject knownFieldNames = new HashtableOfObject(count);
        boolean duplicate = false;
        count = 0;
        for (i = 0; i < size; ++i) {
            FieldDeclaration field = fields[i];
            if (!field.isField()) {
                if (!this.referenceContext.binding.isInterface()) continue;
                this.problemReporter().interfaceCannotHaveInitializers(this.referenceContext.binding, field);
                continue;
            }
            fieldBinding = new FieldBinding(field, null, field.modifiers | 0x2000000, this.referenceContext.binding);
            this.checkAndSetModifiersForField(fieldBinding, field);
            if (knownFieldNames.containsKey(field.name)) {
                duplicate = true;
                FieldBinding previousBinding = (FieldBinding)knownFieldNames.get(field.name);
                if (previousBinding != null) {
                    for (int f = 0; f < i; ++f) {
                        FieldDeclaration previousField = fields[f];
                        if (previousField.binding != previousBinding) continue;
                        this.problemReporter().duplicateFieldInType(this.referenceContext.binding, previousField);
                        previousField.binding = null;
                        break;
                    }
                }
                knownFieldNames.put(field.name, null);
                this.problemReporter().duplicateFieldInType(this.referenceContext.binding, field);
                field.binding = null;
                continue;
            }
            knownFieldNames.put(field.name, fieldBinding);
            if (fieldBinding == null) continue;
            fieldBindings[count++] = fieldBinding;
        }
        if (duplicate) {
            FieldBinding[] newFieldBindings = new FieldBinding[knownFieldNames.size() - 1];
            size = count;
            count = 0;
            for (int i3 = 0; i3 < size; ++i3) {
                fieldBinding = fieldBindings[i3];
                if (knownFieldNames.get(fieldBinding.name) == null) continue;
                newFieldBindings[count++] = fieldBinding;
            }
            fieldBindings = newFieldBindings;
        }
        if (count != fieldBindings.length) {
            FieldBinding[] fieldBindingArray = fieldBindings;
            fieldBindings = new FieldBinding[count];
            System.arraycopy(fieldBindingArray, 0, fieldBindings, 0, count);
        }
        for (i = 0; i < count; ++i) {
            fieldBindings[i].id = i;
        }
        this.referenceContext.binding.fields = fieldBindings;
    }

    void buildFieldsAndMethods() {
        this.buildFields();
        this.buildMethods();
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (sourceType.isMemberType() && !sourceType.isLocalType()) {
            ((MemberTypeBinding)sourceType).checkSyntheticArgsAndFields();
        }
        ReferenceBinding[] memberTypes = sourceType.memberTypes;
        int length = memberTypes.length;
        for (int i = 0; i < length; ++i) {
            ((SourceTypeBinding)memberTypes[i]).scope.buildFieldsAndMethods();
        }
    }

    private LocalTypeBinding buildLocalType(SourceTypeBinding enclosingType, PackageBinding packageBinding) {
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        LocalTypeBinding localType = new LocalTypeBinding(this, enclosingType, this.switchCase());
        this.referenceContext.binding = localType;
        this.checkAndSetModifiers();
        ReferenceBinding[] memberTypeBindings = TypeConstants.NoMemberTypes;
        if (this.referenceContext.memberTypes != null) {
            int size = this.referenceContext.memberTypes.length;
            memberTypeBindings = new ReferenceBinding[size];
            int count = 0;
            block0: for (int i = 0; i < size; ++i) {
                TypeDeclaration memberContext = this.referenceContext.memberTypes[i];
                if (memberContext.isInterface()) {
                    this.problemReporter().nestedClassCannotDeclareInterface(memberContext);
                    continue;
                }
                ReferenceBinding type = localType;
                do {
                    if (!CharOperation.equals(type.sourceName, memberContext.name)) continue;
                    this.problemReporter().hidingEnclosingType(memberContext);
                    continue block0;
                } while ((type = ((ReferenceBinding)type).enclosingType()) != null);
                for (int j = 0; j < i; ++j) {
                    if (!CharOperation.equals(this.referenceContext.memberTypes[j].name, memberContext.name)) continue;
                    this.problemReporter().duplicateNestedType(memberContext);
                    continue block0;
                }
                ClassScope memberScope = new ClassScope(this, this.referenceContext.memberTypes[i]);
                LocalTypeBinding memberBinding = memberScope.buildLocalType(localType, packageBinding);
                memberBinding.setAsMemberType();
                memberTypeBindings[count++] = memberBinding;
            }
            if (count != size) {
                ReferenceBinding[] referenceBindingArray = memberTypeBindings;
                memberTypeBindings = new ReferenceBinding[count];
                System.arraycopy(referenceBindingArray, 0, memberTypeBindings, 0, count);
            }
        }
        localType.memberTypes = memberTypeBindings;
        return localType;
    }

    void buildLocalTypeBinding(SourceTypeBinding enclosingType) {
        LocalTypeBinding localType = this.buildLocalType(enclosingType, enclosingType.fPackage);
        this.connectTypeHierarchy();
        this.buildFieldsAndMethods();
        localType.faultInTypesForFieldsAndMethods();
        this.referenceContext.binding.verifyMethods(this.environment().methodVerifier());
    }

    private void buildMethods() {
        if (this.referenceContext.methods == null) {
            this.referenceContext.binding.methods = TypeConstants.NoMethods;
            return;
        }
        AbstractMethodDeclaration[] methods = this.referenceContext.methods;
        int size = methods.length;
        int clinitIndex = -1;
        for (int i = 0; i < size; ++i) {
            if (!(methods[i] instanceof Clinit)) continue;
            clinitIndex = i;
            break;
        }
        MethodBinding[] methodBindings = new MethodBinding[clinitIndex == -1 ? size : size - 1];
        int count = 0;
        for (int i = 0; i < size; ++i) {
            MethodScope scope;
            MethodBinding methodBinding;
            if (i == clinitIndex || (methodBinding = (scope = new MethodScope(this, methods[i], false)).createMethod(methods[i])) == null) continue;
            methodBindings[count++] = methodBinding;
        }
        if (count != methodBindings.length) {
            MethodBinding[] methodBindingArray = methodBindings;
            methodBindings = new MethodBinding[count];
            System.arraycopy(methodBindingArray, 0, methodBindings, 0, count);
        }
        this.referenceContext.binding.methods = methodBindings;
        this.referenceContext.binding.modifiers |= 0x2000000;
    }

    SourceTypeBinding buildType(SourceTypeBinding enclosingType, PackageBinding packageBinding) {
        char[][] className;
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        if (enclosingType == null) {
            className = CharOperation.arrayConcat(packageBinding.compoundName, this.referenceContext.name);
            this.referenceContext.binding = new SourceTypeBinding(className, packageBinding, this);
        } else {
            className = CharOperation.deepCopy(enclosingType.compoundName);
            className[className.length - 1] = CharOperation.concat(className[className.length - 1], this.referenceContext.name, '$');
            this.referenceContext.binding = new MemberTypeBinding(className, this, enclosingType);
        }
        SourceTypeBinding sourceType = this.referenceContext.binding;
        sourceType.fPackage.addType(sourceType);
        this.checkAndSetModifiers();
        ReferenceBinding[] memberTypeBindings = TypeConstants.NoMemberTypes;
        if (this.referenceContext.memberTypes != null) {
            int size = this.referenceContext.memberTypes.length;
            memberTypeBindings = new ReferenceBinding[size];
            int count = 0;
            block0: for (int i = 0; i < size; ++i) {
                TypeDeclaration memberContext = this.referenceContext.memberTypes[i];
                if (memberContext.isInterface() && sourceType.isNestedType() && sourceType.isClass() && !sourceType.isStatic()) {
                    this.problemReporter().nestedClassCannotDeclareInterface(memberContext);
                    continue;
                }
                ReferenceBinding type = sourceType;
                do {
                    if (!CharOperation.equals(type.sourceName, memberContext.name)) continue;
                    this.problemReporter().hidingEnclosingType(memberContext);
                    continue block0;
                } while ((type = type.enclosingType()) != null);
                for (int j = 0; j < i; ++j) {
                    if (!CharOperation.equals(this.referenceContext.memberTypes[j].name, memberContext.name)) continue;
                    this.problemReporter().duplicateNestedType(memberContext);
                    continue block0;
                }
                ClassScope memberScope = new ClassScope(this, memberContext);
                memberTypeBindings[count++] = memberScope.buildType(sourceType, packageBinding);
            }
            if (count != size) {
                ReferenceBinding[] referenceBindingArray = memberTypeBindings;
                memberTypeBindings = new ReferenceBinding[count];
                System.arraycopy(referenceBindingArray, 0, memberTypeBindings, 0, count);
            }
        }
        sourceType.memberTypes = memberTypeBindings;
        return sourceType;
    }

    private void checkAndSetModifiers() {
        int unexpectedModifiers;
        int realModifiers;
        SourceTypeBinding sourceType = this.referenceContext.binding;
        int modifiers = sourceType.modifiers;
        if ((modifiers & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForType(sourceType);
        }
        ReferenceBinding enclosingType = sourceType.enclosingType();
        boolean isMemberType = sourceType.isMemberType();
        if (isMemberType) {
            if (enclosingType.isStrictfp()) {
                modifiers |= 0x800;
            }
            if (enclosingType.isViewedAsDeprecated() && !sourceType.isDeprecated()) {
                modifiers |= 0x200000;
            }
            if (enclosingType.isInterface()) {
                modifiers |= 1;
            }
        } else if (sourceType.isLocalType()) {
            if (sourceType.isAnonymousType()) {
                modifiers |= 0x10;
            }
            Scope scope = this;
            block4: do {
                switch (scope.kind) {
                    case 2: {
                        MethodScope methodScope = (MethodScope)scope;
                        if (methodScope.isInsideInitializer()) {
                            SourceTypeBinding type = ((TypeDeclaration)methodScope.referenceContext).binding;
                            if (methodScope.initializedField != null) {
                                if (!methodScope.initializedField.isViewedAsDeprecated() || sourceType.isDeprecated()) continue block4;
                                modifiers |= 0x200000;
                                break;
                            }
                            if (type.isStrictfp()) {
                                modifiers |= 0x800;
                            }
                            if (!type.isViewedAsDeprecated() || sourceType.isDeprecated()) continue block4;
                            modifiers |= 0x200000;
                            break;
                        }
                        MethodBinding method = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                        if (method == null) continue block4;
                        if (method.isStrictfp()) {
                            modifiers |= 0x800;
                        }
                        if (!method.isViewedAsDeprecated() || sourceType.isDeprecated()) continue block4;
                        modifiers |= 0x200000;
                        break;
                    }
                    case 3: {
                        if (enclosingType.isStrictfp()) {
                            modifiers |= 0x800;
                        }
                        if (!enclosingType.isViewedAsDeprecated() || sourceType.isDeprecated()) continue block4;
                        modifiers |= 0x200000;
                    }
                }
            } while ((scope = scope.parent) != null);
        }
        if (((realModifiers = modifiers & 0xFFFF) & 0x200) != 0) {
            if (isMemberType) {
                unexpectedModifiers = -3600;
                if ((realModifiers & unexpectedModifiers) != 0) {
                    this.problemReporter().illegalModifierForMemberInterface(sourceType);
                }
            } else {
                unexpectedModifiers = -3586;
                if ((realModifiers & unexpectedModifiers) != 0) {
                    this.problemReporter().illegalModifierForInterface(sourceType);
                }
            }
            modifiers |= 0x400;
        } else {
            if (isMemberType) {
                unexpectedModifiers = -3104;
                if ((realModifiers & unexpectedModifiers) != 0) {
                    this.problemReporter().illegalModifierForMemberClass(sourceType);
                }
            } else if (sourceType.isLocalType()) {
                unexpectedModifiers = -3089;
                if ((realModifiers & unexpectedModifiers) != 0) {
                    this.problemReporter().illegalModifierForLocalClass(sourceType);
                }
            } else {
                unexpectedModifiers = -3090;
                if ((realModifiers & unexpectedModifiers) != 0) {
                    this.problemReporter().illegalModifierForClass(sourceType);
                }
            }
            if ((realModifiers & 0x410) == 1040) {
                this.problemReporter().illegalModifierCombinationFinalAbstractForClass(sourceType);
            }
        }
        if (isMemberType) {
            if (enclosingType.isInterface()) {
                if ((realModifiers & 6) != 0) {
                    this.problemReporter().illegalVisibilityModifierForInterfaceMemberType(sourceType);
                    if ((realModifiers & 4) != 0) {
                        modifiers ^= 4;
                    }
                    if ((realModifiers & 2) != 0) {
                        modifiers ^= 2;
                    }
                }
            } else {
                int accessorBits = realModifiers & 7;
                if ((accessorBits & accessorBits - 1) > 1) {
                    this.problemReporter().illegalVisibilityModifierCombinationForMemberType(sourceType);
                    if ((accessorBits & 1) != 0) {
                        if ((accessorBits & 4) != 0) {
                            modifiers ^= 4;
                        }
                        if ((accessorBits & 2) != 0) {
                            modifiers ^= 2;
                        }
                    }
                    if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                        modifiers ^= 2;
                    }
                }
            }
            if ((realModifiers & 8) == 0) {
                if (enclosingType.isInterface()) {
                    modifiers |= 8;
                }
            } else if (!enclosingType.isStatic()) {
                this.problemReporter().illegalStaticModifierForMemberType(sourceType);
            }
        }
        sourceType.modifiers = modifiers;
    }

    private void checkAndSetModifiersForField(FieldBinding fieldBinding, FieldDeclaration fieldDecl) {
        int accessorBits;
        int modifiers = fieldBinding.modifiers;
        if ((modifiers & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForField(fieldBinding.declaringClass, fieldDecl);
        }
        if (fieldBinding.declaringClass.isInterface()) {
            int expectedValue = 25;
            if (((modifiers |= expectedValue) & 0xFFFF) != expectedValue) {
                this.problemReporter().illegalModifierForInterfaceField(fieldBinding.declaringClass, fieldDecl);
            }
            fieldBinding.modifiers = modifiers;
            return;
        }
        int realModifiers = modifiers & 0xFFFF;
        int unexpectedModifiers = -224;
        if ((realModifiers & unexpectedModifiers) != 0) {
            this.problemReporter().illegalModifierForField(fieldBinding.declaringClass, fieldDecl);
        }
        if (((accessorBits = realModifiers & 7) & accessorBits - 1) > 1) {
            this.problemReporter().illegalVisibilityModifierCombinationForField(fieldBinding.declaringClass, fieldDecl);
            if ((accessorBits & 1) != 0) {
                if ((accessorBits & 4) != 0) {
                    modifiers ^= 4;
                }
                if ((accessorBits & 2) != 0) {
                    modifiers ^= 2;
                }
            }
            if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                modifiers ^= 2;
            }
        }
        if ((realModifiers & 0x50) == 80) {
            this.problemReporter().illegalModifierCombinationFinalVolatileForField(fieldBinding.declaringClass, fieldDecl);
        }
        if (fieldDecl.initialization == null && (modifiers & 0x10) != 0) {
            modifiers |= 0x4000000;
        }
        fieldBinding.modifiers = modifiers;
    }

    private void checkForInheritedMemberTypes(SourceTypeBinding sourceType) {
        ReferenceBinding currentType = sourceType;
        ReferenceBinding[][] interfacesToVisit = null;
        int lastPosition = -1;
        while ((currentType.tagBits & 0x4000) == 0) {
            if (currentType.hasMemberTypes()) {
                return;
            }
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = new ReferenceBinding[5][];
                }
                if (++lastPosition == interfacesToVisit.length) {
                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                }
                interfacesToVisit[lastPosition] = itsInterfaces;
            }
            if ((currentType = currentType.superclass()) != null) continue;
        }
        boolean hasMembers = false;
        if (interfacesToVisit != null) {
            int j;
            int length;
            ReferenceBinding[] interfaces;
            int i;
            block1: for (i = 0; i <= lastPosition; ++i) {
                interfaces = interfacesToVisit[i];
                length = interfaces.length;
                for (j = 0; j < length; ++j) {
                    ReferenceBinding anInterface = interfaces[j];
                    if ((anInterface.tagBits & 0x800) != 0) continue;
                    anInterface.tagBits |= 0x800;
                    if ((anInterface.tagBits & 0x4000) != 0) continue;
                    if (anInterface.memberTypes() != TypeConstants.NoMemberTypes) {
                        hasMembers = true;
                        break block1;
                    }
                    ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                    if (itsInterfaces == TypeConstants.NoSuperInterfaces) continue;
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
            }
            for (i = 0; i <= lastPosition; ++i) {
                interfaces = interfacesToVisit[i];
                length = interfaces.length;
                for (j = 0; j < length; ++j) {
                    interfaces[j].tagBits &= 0xFFFFF7FF;
                    if (hasMembers) continue;
                    interfaces[j].tagBits |= 0x4000;
                }
            }
        }
        if (!hasMembers) {
            currentType = sourceType;
            do {
                currentType.tagBits |= 0x4000;
            } while ((currentType = currentType.superclass()) != null);
        }
    }

    private void connectMemberTypes() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (sourceType.memberTypes != TypeConstants.NoMemberTypes) {
            int size = sourceType.memberTypes.length;
            for (int i = 0; i < size; ++i) {
                ((SourceTypeBinding)sourceType.memberTypes[i]).scope.connectTypeHierarchy();
            }
        }
    }

    private boolean connectSuperclass() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (sourceType.id == 1) {
            sourceType.superclass = null;
            sourceType.superInterfaces = TypeConstants.NoSuperInterfaces;
            if (this.referenceContext.superclass != null || this.referenceContext.superInterfaces != null) {
                this.problemReporter().objectCannotHaveSuperTypes(sourceType);
            }
            return true;
        }
        if (this.referenceContext.superclass == null) {
            sourceType.superclass = this.getJavaLangObject();
            return !this.detectCycle(sourceType, sourceType.superclass, null);
        }
        ReferenceBinding superclass = this.findSupertype(this.referenceContext.superclass);
        if (superclass != null) {
            this.referenceContext.superclass.resolvedType = superclass;
            if (!superclass.isValidBinding()) {
                this.problemReporter().invalidSuperclass(sourceType, this.referenceContext.superclass, superclass);
            } else if (superclass.isInterface()) {
                this.problemReporter().superclassMustBeAClass(sourceType, this.referenceContext.superclass, superclass);
            } else if (superclass.isFinal()) {
                this.problemReporter().classExtendFinalClass(sourceType, this.referenceContext.superclass, superclass);
            } else {
                sourceType.superclass = superclass;
                return true;
            }
        }
        sourceType.tagBits |= 0x8000;
        sourceType.superclass = this.getJavaLangObject();
        if ((sourceType.superclass.tagBits & 0x100) == 0) {
            this.detectCycle(sourceType, sourceType.superclass, null);
        }
        return false;
    }

    private boolean connectSuperInterfaces() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        sourceType.superInterfaces = TypeConstants.NoSuperInterfaces;
        if (this.referenceContext.superInterfaces == null) {
            return true;
        }
        if (sourceType.id == 1) {
            return true;
        }
        boolean noProblems = true;
        int length = this.referenceContext.superInterfaces.length;
        ReferenceBinding[] interfaceBindings = new ReferenceBinding[length];
        int count = 0;
        block0: for (int i = 0; i < length; ++i) {
            ReferenceBinding superInterface = this.findSupertype(this.referenceContext.superInterfaces[i]);
            if (superInterface == null) {
                noProblems = false;
                continue;
            }
            this.referenceContext.superInterfaces[i].resolvedType = superInterface;
            if (!superInterface.isValidBinding()) {
                this.problemReporter().invalidSuperinterface(sourceType, this.referenceContext.superInterfaces[i], superInterface);
                sourceType.tagBits |= 0x8000;
                noProblems = false;
                continue;
            }
            for (int k = 0; k < count; ++k) {
                if (interfaceBindings[k] != superInterface) continue;
                this.problemReporter().duplicateSuperinterface(sourceType, this.referenceContext, superInterface);
                continue block0;
            }
            if (superInterface.isClass()) {
                this.problemReporter().superinterfaceMustBeAnInterface(sourceType, this.referenceContext, superInterface);
                sourceType.tagBits |= 0x8000;
                noProblems = false;
                continue;
            }
            interfaceBindings[count++] = superInterface;
        }
        if (count > 0) {
            if (count != length) {
                ReferenceBinding[] referenceBindingArray = interfaceBindings;
                interfaceBindings = new ReferenceBinding[count];
                System.arraycopy(referenceBindingArray, 0, interfaceBindings, 0, count);
            }
            sourceType.superInterfaces = interfaceBindings;
        }
        return noProblems;
    }

    void connectTypeHierarchy() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if ((sourceType.tagBits & 0x100) == 0) {
            boolean noProblems = true;
            sourceType.tagBits |= 0x100;
            if (sourceType.isClass()) {
                noProblems &= this.connectSuperclass();
            }
            sourceType.tagBits |= 0x200;
            if ((noProblems &= this.connectSuperInterfaces()) && sourceType.isHierarchyInconsistent()) {
                this.problemReporter().hierarchyHasProblems(sourceType);
            }
        }
        this.connectMemberTypes();
        try {
            this.checkForInheritedMemberTypes(sourceType);
        }
        catch (AbortCompilation e) {
            e.updateContext(this.referenceContext, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    private void connectTypeHierarchyWithoutMembers() {
        if (this.parent instanceof CompilationUnitScope) {
            if (((CompilationUnitScope)this.parent).imports == null) {
                ((CompilationUnitScope)this.parent).checkAndSetImports();
            }
        } else if (this.parent instanceof ClassScope) {
            ((ClassScope)this.parent).connectTypeHierarchyWithoutMembers();
        }
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if ((sourceType.tagBits & 0x100) != 0) {
            return;
        }
        boolean noProblems = true;
        sourceType.tagBits |= 0x100;
        if (sourceType.isClass()) {
            noProblems &= this.connectSuperclass();
        }
        sourceType.tagBits |= 0x200;
        if ((noProblems &= this.connectSuperInterfaces()) && sourceType.isHierarchyInconsistent()) {
            this.problemReporter().hierarchyHasProblems(sourceType);
        }
    }

    private boolean detectCycle(SourceTypeBinding sourceType, ReferenceBinding superType, TypeReference reference) {
        if (sourceType == superType) {
            this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
            sourceType.tagBits |= 0x8000;
            return true;
        }
        if (superType.isBinaryBinding()) {
            ReferenceBinding[] itsInterfaces;
            boolean hasCycle = false;
            if (superType.superclass() != null) {
                if (sourceType == superType.superclass()) {
                    this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
                    sourceType.tagBits |= 0x8000;
                    superType.tagBits |= 0x8000;
                    return true;
                }
                hasCycle |= this.detectCycle(sourceType, superType.superclass(), reference);
                if ((superType.superclass().tagBits & 0x8000) != 0) {
                    sourceType.tagBits |= 0x8000;
                    superType.tagBits |= 0x8000;
                }
            }
            if ((itsInterfaces = superType.superInterfaces()) != TypeConstants.NoSuperInterfaces) {
                int length = itsInterfaces.length;
                for (int i = 0; i < length; ++i) {
                    ReferenceBinding anInterface = itsInterfaces[i];
                    if (sourceType == anInterface) {
                        this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
                        sourceType.tagBits |= 0x8000;
                        superType.tagBits |= 0x8000;
                        return true;
                    }
                    hasCycle |= this.detectCycle(sourceType, anInterface, reference);
                    if ((anInterface.tagBits & 0x8000) == 0) continue;
                    sourceType.tagBits |= 0x8000;
                    superType.tagBits |= 0x8000;
                }
            }
            return hasCycle;
        }
        if ((superType.tagBits & 0x200) == 0 && (superType.tagBits & 0x100) != 0) {
            this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
            sourceType.tagBits |= 0x8000;
            superType.tagBits |= 0x8000;
            return true;
        }
        if ((superType.tagBits & 0x100) == 0) {
            ((SourceTypeBinding)superType).scope.connectTypeHierarchyWithoutMembers();
        }
        if ((superType.tagBits & 0x8000) != 0) {
            sourceType.tagBits |= 0x8000;
        }
        return false;
    }

    private ReferenceBinding findSupertype(TypeReference typeReference) {
        try {
            ReferenceBinding superType;
            block11: {
                int n;
                typeReference.aboutToResolve(this);
                char[][] compoundName = typeReference.getTypeName();
                this.compilationUnitScope().recordQualifiedReference(compoundName);
                SourceTypeBinding sourceType = this.referenceContext.binding;
                int size = compoundName.length;
                if (CharOperation.equals(compoundName[0], sourceType.sourceName)) {
                    superType = sourceType;
                } else {
                    Binding typeOrPackage = this.parent.getTypeOrPackage(compoundName[0], 20);
                    if (typeOrPackage == null || !typeOrPackage.isValidBinding()) {
                        return new ProblemReferenceBinding(compoundName[0], typeOrPackage == null ? 1 : typeOrPackage.problemId());
                    }
                    boolean checkVisibility = false;
                    for (n = 1; n < size && typeOrPackage instanceof PackageBinding; ++n) {
                        PackageBinding packageBinding = (PackageBinding)typeOrPackage;
                        if ((typeOrPackage = packageBinding.getTypeOrPackage(compoundName[n])) == null || !typeOrPackage.isValidBinding()) {
                            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, n + 1), typeOrPackage == null ? 1 : typeOrPackage.problemId());
                        }
                        checkVisibility = true;
                    }
                    if (typeOrPackage instanceof PackageBinding) {
                        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, n), 1);
                    }
                    superType = (ReferenceBinding)typeOrPackage;
                    this.compilationUnitScope().recordTypeReference(superType);
                    if (checkVisibility && n == size && !superType.canBeSeenBy(sourceType.fPackage)) {
                        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, n), superType, 2);
                    }
                }
                do {
                    char[] typeName;
                    if (this.detectCycle(sourceType, superType, typeReference)) {
                        return null;
                    }
                    if (n >= size) break block11;
                    if ((superType = this.findMemberType(typeName = compoundName[n++], superType)) != null) continue;
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, n), 1);
                } while (superType.isValidBinding());
                superType.compoundName = CharOperation.subarray(compoundName, 0, n);
                return superType;
            }
            return superType;
        }
        catch (AbortCompilation e) {
            e.updateContext(typeReference, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    public ProblemReporter problemReporter() {
        MethodScope outerMethodScope = this.outerMostMethodScope();
        if (outerMethodScope == null) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return outerMethodScope.problemReporter();
    }

    public TypeDeclaration referenceType() {
        return this.referenceContext;
    }

    public String toString() {
        if (this.referenceContext != null) {
            return "--- Class Scope ---\n\n" + this.referenceContext.binding.toString();
        }
        return "--- Class Scope ---\n\n Binding not initialized";
    }
}

