/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CastExpression
extends Expression {
    public Expression expression;
    public Expression type;

    public CastExpression(Expression expression, Expression type) {
        this.expression = expression;
        this.type = type;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
    }

    public final boolean checkCastTypesCompatibility(BlockScope scope, TypeBinding castType, TypeBinding expressionType) {
        if (castType == null || expressionType == null) {
            return true;
        }
        if (castType.isBaseType()) {
            if (expressionType.isBaseType()) {
                if (expressionType == castType) {
                    this.expression.implicitWidening(castType, expressionType);
                    this.constant = this.expression.constant;
                    return false;
                }
                boolean necessary = false;
                if (expressionType.isCompatibleWith(castType) || (necessary = BaseTypeBinding.isNarrowing(castType.id, expressionType.id))) {
                    this.expression.implicitConversion = (castType.id << 4) + expressionType.id;
                    if (this.expression.constant != Constant.NotAConstant) {
                        this.constant = this.expression.constant.castTo(this.expression.implicitConversion);
                    }
                    return necessary;
                }
            }
            scope.problemReporter().typeCastError(this, castType, expressionType);
            return true;
        }
        if (expressionType == BaseTypes.NullBinding) {
            return false;
        }
        if (expressionType.isBaseType()) {
            scope.problemReporter().typeCastError(this, castType, expressionType);
            return true;
        }
        if (expressionType.isArrayType()) {
            if (castType == expressionType) {
                return false;
            }
            if (castType.isArrayType()) {
                TypeBinding exprElementType = ((ArrayBinding)expressionType).elementsType(scope);
                if (exprElementType.isBaseType()) {
                    if (((ArrayBinding)castType).elementsType(scope) == exprElementType) {
                        this.bits |= 0x40;
                    } else {
                        scope.problemReporter().typeCastError(this, castType, expressionType);
                    }
                    return true;
                }
                return this.checkCastTypesCompatibility(scope, ((ArrayBinding)castType).elementsType(scope), exprElementType);
            }
            if (castType.isClass()) {
                if (castType.id == 1) {
                    return false;
                }
            } else if (castType.id == 36 || castType.id == 37) {
                this.bits |= 0x40;
                return true;
            }
            scope.problemReporter().typeCastError(this, castType, expressionType);
            return true;
        }
        if (expressionType.isClass()) {
            if (castType.isArrayType()) {
                if (expressionType.id == 1) {
                    this.bits |= 0x40;
                    return true;
                }
            } else if (castType.isClass()) {
                if (expressionType.isCompatibleWith(castType)) {
                    if (castType.id == 11) {
                        this.constant = this.expression.constant;
                    }
                    return false;
                }
                if (castType.isCompatibleWith(expressionType)) {
                    this.bits |= 0x40;
                    return true;
                }
            } else {
                if (expressionType.isCompatibleWith(castType)) {
                    return false;
                }
                if (!((ReferenceBinding)expressionType).isFinal()) {
                    this.bits |= 0x40;
                    return true;
                }
            }
            scope.problemReporter().typeCastError(this, castType, expressionType);
            return true;
        }
        if (castType.isArrayType()) {
            if (expressionType.id == 36 || expressionType.id == 37) {
                this.bits |= 0x40;
            } else {
                scope.problemReporter().typeCastError(this, castType, expressionType);
            }
            return true;
        }
        if (castType.isClass()) {
            if (castType.id == 1) {
                return false;
            }
            if (((ReferenceBinding)castType).isFinal() && !castType.isCompatibleWith(expressionType)) {
                scope.problemReporter().typeCastError(this, castType, expressionType);
                return true;
            }
        } else {
            if (expressionType.isCompatibleWith(castType)) {
                return false;
            }
            if (!castType.isCompatibleWith(expressionType)) {
                MethodBinding[] castTypeMethods = ((ReferenceBinding)castType).methods();
                MethodBinding[] expressionTypeMethods = ((ReferenceBinding)expressionType).methods();
                int exprMethodsLength = expressionTypeMethods.length;
                int castMethodsLength = castTypeMethods.length;
                for (int i = 0; i < castMethodsLength; ++i) {
                    for (int j = 0; j < exprMethodsLength; ++j) {
                        if (castTypeMethods[i].returnType == expressionTypeMethods[j].returnType || !CharOperation.equals(castTypeMethods[i].selector, expressionTypeMethods[j].selector) || !castTypeMethods[i].areParametersEqual(expressionTypeMethods[j])) continue;
                        scope.problemReporter().typeCastError(this, castType, expressionType);
                    }
                }
            }
        }
        this.bits |= 0x40;
        return true;
    }

    public static void checkNeedForEnclosingInstanceCast(BlockScope scope, Expression enclosingInstance, TypeBinding enclosingInstanceType, TypeBinding memberType) {
        if (scope.environment().options.getSeverity(0x4000000L) == -1) {
            return;
        }
        TypeBinding castedExpressionType = ((CastExpression)enclosingInstance).expression.resolvedType;
        if (castedExpressionType == null) {
            return;
        }
        if (castedExpressionType == enclosingInstanceType) {
            scope.problemReporter().unnecessaryCast((CastExpression)enclosingInstance);
        } else {
            if (castedExpressionType == BaseTypes.NullBinding) {
                return;
            }
            TypeBinding alternateEnclosingInstanceType = castedExpressionType;
            if (castedExpressionType.isBaseType() || castedExpressionType.isArrayType()) {
                return;
            }
            if (memberType == scope.getMemberType(memberType.sourceName(), (ReferenceBinding)alternateEnclosingInstanceType)) {
                scope.problemReporter().unnecessaryCast((CastExpression)enclosingInstance);
            }
        }
    }

    public static void checkNeedForArgumentCast(BlockScope scope, int operator, int operatorSignature, Expression expression, int expressionTypeId) {
        if (scope.environment().options.getSeverity(0x4000000L) == -1) {
            return;
        }
        int alternateLeftTypeId = expressionTypeId;
        if ((expression.bits & 0x4000) == 0 && expression.resolvedType.isBaseType()) {
            return;
        }
        TypeBinding alternateLeftType = ((CastExpression)expression).expression.resolvedType;
        if (alternateLeftType == null) {
            return;
        }
        alternateLeftTypeId = alternateLeftType.id;
        if (alternateLeftTypeId == expressionTypeId) {
            scope.problemReporter().unnecessaryCast((CastExpression)expression);
            return;
        }
        if (alternateLeftTypeId == 12) {
            alternateLeftTypeId = expressionTypeId;
            return;
        }
    }

    public static void checkNeedForArgumentCasts(BlockScope scope, Expression receiver, TypeBinding receiverType, MethodBinding binding, Expression[] arguments, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        if (scope.environment().options.getSeverity(0x4000000L) == -1) {
            return;
        }
        int length = argumentTypes.length;
        TypeBinding[] rawArgumentTypes = argumentTypes;
        for (int i = 0; i < length; ++i) {
            Expression argument = arguments[i];
            if (!(argument instanceof CastExpression) || (argument.bits & 0x4000) == 0 && argument.resolvedType.isBaseType()) continue;
            TypeBinding castedExpressionType = ((CastExpression)argument).expression.resolvedType;
            if (castedExpressionType == null) {
                return;
            }
            if (castedExpressionType == argumentTypes[i]) {
                scope.problemReporter().unnecessaryCast((CastExpression)argument);
                continue;
            }
            if (castedExpressionType == BaseTypes.NullBinding) continue;
            if (rawArgumentTypes == argumentTypes) {
                TypeBinding[] typeBindingArray = rawArgumentTypes;
                rawArgumentTypes = new TypeBinding[length];
                System.arraycopy(typeBindingArray, 0, rawArgumentTypes, 0, length);
            }
            rawArgumentTypes[i] = castedExpressionType;
        }
        if (rawArgumentTypes != argumentTypes) {
            CastExpression.checkAlternateBinding(scope, receiver, receiverType, binding, arguments, argumentTypes, rawArgumentTypes, invocationSite);
        }
    }

    public static void checkNeedForArgumentCasts(BlockScope scope, int operator, int operatorSignature, Expression left, int leftTypeId, boolean leftIsCast, Expression right, int rightTypeId, boolean rightIsCast) {
        if (scope.environment().options.getSeverity(0x4000000L) == -1) {
            return;
        }
        int alternateLeftTypeId = leftTypeId;
        if (leftIsCast) {
            if ((left.bits & 0x4000) == 0 && left.resolvedType.isBaseType()) {
                leftIsCast = false;
            } else {
                TypeBinding alternateLeftType = ((CastExpression)left).expression.resolvedType;
                if (alternateLeftType == null) {
                    return;
                }
                alternateLeftTypeId = alternateLeftType.id;
                if (alternateLeftTypeId == leftTypeId) {
                    scope.problemReporter().unnecessaryCast((CastExpression)left);
                    leftIsCast = false;
                } else if (alternateLeftTypeId == 12) {
                    alternateLeftTypeId = leftTypeId;
                    leftIsCast = false;
                }
            }
        }
        int alternateRightTypeId = rightTypeId;
        if (rightIsCast) {
            if ((right.bits & 0x4000) == 0 && right.resolvedType.isBaseType()) {
                rightIsCast = false;
            } else {
                TypeBinding alternateRightType = ((CastExpression)right).expression.resolvedType;
                if (alternateRightType == null) {
                    return;
                }
                alternateRightTypeId = alternateRightType.id;
                if (alternateRightTypeId == rightTypeId) {
                    scope.problemReporter().unnecessaryCast((CastExpression)right);
                    rightIsCast = false;
                } else if (alternateRightTypeId == 12) {
                    alternateRightTypeId = rightTypeId;
                    rightIsCast = false;
                }
            }
        }
        if (leftIsCast || rightIsCast) {
            if (alternateLeftTypeId > 15 || alternateRightTypeId > 15) {
                if (alternateLeftTypeId == 11) {
                    alternateRightTypeId = 1;
                } else if (alternateRightTypeId == 11) {
                    alternateLeftTypeId = 1;
                } else {
                    return;
                }
            }
            int alternateOperatorSignature = OperatorExpression.OperatorSignatures[operator][(alternateLeftTypeId << 4) + alternateRightTypeId];
            int CompareMASK = 986895;
            if ((operatorSignature & 0xF0F0F) == (alternateOperatorSignature & 0xF0F0F)) {
                if (leftIsCast) {
                    scope.problemReporter().unnecessaryCastForArgument((CastExpression)left, TypeBinding.wellKnownType(scope, left.implicitConversion >> 4));
                }
                if (rightIsCast) {
                    scope.problemReporter().unnecessaryCastForArgument((CastExpression)right, TypeBinding.wellKnownType(scope, right.implicitConversion >> 4));
                }
            }
        }
    }

    private static void checkAlternateBinding(BlockScope scope, Expression receiver, TypeBinding receiverType, MethodBinding binding, Expression[] arguments, TypeBinding[] originalArgumentTypes, TypeBinding[] alternateArgumentTypes, final InvocationSite invocationSite) {
        MethodBinding bindingIfNoCast;
        InvocationSite fakeInvocationSite = new InvocationSite(){

            public boolean isSuperAccess() {
                return invocationSite.isSuperAccess();
            }

            public boolean isTypeAccess() {
                return invocationSite.isTypeAccess();
            }

            public void setActualReceiverType(ReferenceBinding actualReceiverType) {
            }

            public void setDepth(int depth) {
            }

            public void setFieldIndex(int depth) {
            }

            public int sourceStart() {
                return 0;
            }

            public int sourceEnd() {
                return 0;
            }
        };
        if (binding.isConstructor()) {
            bindingIfNoCast = scope.getConstructor((ReferenceBinding)receiverType, alternateArgumentTypes, fakeInvocationSite);
        } else {
            MethodBinding methodBinding = bindingIfNoCast = receiver.isImplicitThis() ? scope.getImplicitMethod(binding.selector, alternateArgumentTypes, fakeInvocationSite) : scope.getMethod(receiverType, binding.selector, alternateArgumentTypes, fakeInvocationSite);
        }
        if (bindingIfNoCast == binding) {
            int length = originalArgumentTypes.length;
            for (int i = 0; i < length; ++i) {
                if (originalArgumentTypes[i] == alternateArgumentTypes[i]) continue;
                scope.problemReporter().unnecessaryCastForArgument((CastExpression)arguments[i], binding.parameters[i]);
            }
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        boolean needRuntimeCheckcast;
        int pc = codeStream.position;
        boolean bl = needRuntimeCheckcast = (this.bits & 0x40) != 0;
        if (this.constant != NotAConstant) {
            if (valueRequired || needRuntimeCheckcast) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
                if (needRuntimeCheckcast) {
                    codeStream.checkcast(this.resolvedType);
                    if (!valueRequired) {
                        codeStream.pop();
                    }
                }
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        this.expression.generateCode(currentScope, codeStream, valueRequired || needRuntimeCheckcast);
        if (needRuntimeCheckcast) {
            codeStream.checkcast(this.resolvedType);
            if (!valueRequired) {
                codeStream.pop();
            }
        } else if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public Expression innermostCastedExpression() {
        Expression current = this.expression;
        while (current instanceof CastExpression) {
            current = ((CastExpression)current).expression;
        }
        return current;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('(');
        this.type.print(0, output).append(") ");
        return this.expression.printExpression(0, output);
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        this.implicitConversion = 0;
        if (this.type instanceof TypeReference || this.type instanceof NameReference && (this.type.bits & 0x1FE00000) >> 21 == 0) {
            boolean necessary;
            this.resolvedType = this.type.resolveType(scope);
            TypeBinding expressionType = this.expression.resolveType(scope);
            if (this.resolvedType != null && expressionType != null && !(necessary = this.checkCastTypesCompatibility(scope, this.resolvedType, expressionType)) && this.expression.resolvedType != null) {
                this.bits |= 0x4000;
                if ((this.bits & 0x20) == 0) {
                    scope.problemReporter().unnecessaryCast(this);
                }
            }
            return this.resolvedType;
        }
        TypeBinding expressionType = this.expression.resolveType(scope);
        if (expressionType == null) {
            return null;
        }
        scope.problemReporter().invalidTypeReference(this.type);
        return null;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.type.traverse(visitor, blockScope);
            this.expression.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

