/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.Filter;
import org.eclipse.jdt.internal.debug.ui.FilterLabelProvider;
import org.eclipse.jdt.internal.debug.ui.FilterViewerSorter;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class SelectImportsDialog
extends TitleAreaDialog {
    private String[] fImports;
    private Button fAddPackageButton;
    private Button fAddTypeButton;
    private Button fRemoveImportsButton;
    private TableViewer fImportsViewer;
    private Table fImportsTable;
    private JavaSnippetEditor fEditor;
    private ImportsContentProvider fImportContentProvider;

    public SelectImportsDialog(JavaSnippetEditor editor, String[] imports) {
        super(editor.getShell());
        this.fEditor = editor;
        this.fImports = imports;
    }

    private void createImportButtons(Composite container) {
        WorkbenchHelp.setHelp((Control)container, (String)IJavaDebugHelpContextIds.SNIPPET_IMPORTS_DIALOG);
        Font font = container.getFont();
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(258);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddTypeButton = new Button(buttonContainer, 8);
        this.fAddTypeButton.setText(SnippetMessages.getString("SelectImportsDialog.Add_&Type_1"));
        this.fAddTypeButton.setToolTipText(SnippetMessages.getString("SelectImportsDialog.Choose_a_Type_to_Add_as_an_Import_2"));
        gd = this.getButtonGridData(this.fAddTypeButton);
        this.fAddTypeButton.setLayoutData((Object)gd);
        this.fAddTypeButton.setFont(font);
        this.fAddTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                SelectImportsDialog.this.addType();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.fAddPackageButton = new Button(buttonContainer, 8);
        this.fAddPackageButton.setText(SnippetMessages.getString("SelectImportsDialog.Add_&Package_3"));
        this.fAddPackageButton.setToolTipText(SnippetMessages.getString("SelectImportsDialog.Choose_a_Package_to_Add_as_an_Import_4"));
        gd = this.getButtonGridData(this.fAddPackageButton);
        this.fAddPackageButton.setLayoutData((Object)gd);
        this.fAddPackageButton.setFont(font);
        this.fAddPackageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                SelectImportsDialog.this.addPackage();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.fRemoveImportsButton = new Button(buttonContainer, 8);
        this.fRemoveImportsButton.setText(SnippetMessages.getString("SelectImportsDialog.&Remove_5"));
        this.fRemoveImportsButton.setToolTipText(SnippetMessages.getString("SelectImportsDialog.Remove_All_Selected_Imports_6"));
        gd = this.getButtonGridData(this.fRemoveImportsButton);
        this.fRemoveImportsButton.setLayoutData((Object)gd);
        this.fRemoveImportsButton.setFont(font);
        this.fRemoveImportsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                SelectImportsDialog.this.removeImports();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.fRemoveImportsButton.setEnabled(false);
    }

    private GridData getButtonGridData(Button button) {
        GridData gd = new GridData(770);
        button.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)button);
        return gd;
    }

    private void removeImports() {
        IStructuredSelection selection = (IStructuredSelection)this.fImportsViewer.getSelection();
        this.fImportContentProvider.removeImports(selection.toArray());
    }

    private void addPackage() {
        Shell shell = this.fAddPackageButton.getDisplay().getActiveShell();
        ElementListSelectionDialog dialog = null;
        try {
            IJavaProject project = this.fEditor.getJavaProject();
            ArrayList<Object> projects = new ArrayList<Object>();
            projects.add(project);
            IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
            for (int i = 0; i < roots.length; ++i) {
                IPackageFragmentRoot root = roots[i];
                projects.add(root.getParent());
            }
            dialog = JDIDebugUIPlugin.createAllPackagesDialog(shell, projects.toArray(new IJavaProject[projects.size()]), false);
        }
        catch (JavaModelException jme) {
            String title = SnippetMessages.getString("SelectImportsDialog.Add_package_as_import_7");
            String message = SnippetMessages.getString("SelectImportsDialog.Could_not_open_package_selection_dialog_8");
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        if (dialog == null) {
            return;
        }
        dialog.setTitle(SnippetMessages.getString("SelectImportsDialog.Add_package_as_import_7"));
        dialog.setMessage(SnippetMessages.getString("SelectImportsDialog.&Select_a_package_to_add_as_an_Import_10"));
        dialog.setMultipleSelection(true);
        if (dialog.open() == 1) {
            return;
        }
        Object[] packages = dialog.getResult();
        if (packages != null) {
            for (int i = 0; i < packages.length; ++i) {
                IJavaElement pkg = (IJavaElement)packages[i];
                String filter = pkg.getElementName();
                filter = filter + ".*";
                this.fImportContentProvider.addImport(filter);
            }
        }
    }

    private void addType() {
        Shell shell = this.fAddTypeButton.getDisplay().getActiveShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.fEditor.getJavaProject()}, (boolean)true), (int)6, (boolean)false);
        }
        catch (JavaModelException jme) {
            String title = SnippetMessages.getString("SelectImportsDialog.Add_Type_as_Import_12");
            String message = SnippetMessages.getString("SelectImportsDialog.Could_not_open_class_selection_dialog_13");
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        dialog.setTitle(SnippetMessages.getString("SelectImportsDialog.Add_Type_as_Import_12"));
        dialog.setMessage(SnippetMessages.getString("SelectImportsDialog.&Select_a_type_to_add_to_add_as_an_import_15"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = (IType)types[0];
            this.fImportContentProvider.addImport(type.getFullyQualifiedName());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite dialogComp = (Composite)super.createDialogArea(parent);
        Composite outer = new Composite(dialogComp, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        outer.setLayout((Layout)topLayout);
        outer.setFont(font);
        this.setTitle(MessageFormat.format(SnippetMessages.getString("SelectImportsDialog.Manage_the_Java_Snippet_Editor_Imports_for___{0}__1"), this.fEditor.getEditorInput().getName()));
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        outer.setLayoutData((Object)gd);
        this.fImportsTable = new Table(outer, 67586);
        TableLayout tableLayout = new TableLayout();
        ColumnLayoutData[] columnLayoutData = new ColumnLayoutData[]{new ColumnWeightData(100)};
        tableLayout.addColumnData(columnLayoutData[0]);
        this.fImportsTable.setLayout((Layout)tableLayout);
        this.fImportsTable.setFont(font);
        new TableColumn(this.fImportsTable, 0);
        this.fImportsViewer = new TableViewer(this.fImportsTable);
        this.fImportsViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fImportsViewer.setSorter((ViewerSorter)new FilterViewerSorter());
        this.fImportContentProvider = new ImportsContentProvider(this.fImportsViewer);
        this.fImportsViewer.setContentProvider((IContentProvider)this.fImportContentProvider);
        this.fImportsViewer.setInput((Object)this);
        gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 300;
        this.fImportsViewer.getTable().setLayoutData((Object)gd);
        this.fImportsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    SelectImportsDialog.this.fRemoveImportsButton.setEnabled(false);
                } else {
                    SelectImportsDialog.this.fRemoveImportsButton.setEnabled(true);
                }
            }
        });
        this.createImportButtons(outer);
        SelectImportsDialog.applyDialogFont((Control)outer);
        return outer;
    }

    protected void okPressed() {
        String[] imports = null;
        Object[] results = this.fImportContentProvider.getElements(null);
        if (results != null && results.length > 0) {
            imports = new String[results.length];
            for (int i = 0; i < results.length; ++i) {
                Filter imprt = (Filter)results[i];
                imports[i] = imprt.getName();
            }
        }
        this.fEditor.setImports(imports);
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SnippetMessages.getString("SelectImportsDialog.Java_Snippet_Imports_18"));
    }

    protected class ImportsContentProvider
    implements IStructuredContentProvider {
        private TableViewer fViewer;
        private List fImportNames;

        public ImportsContentProvider(TableViewer viewer) {
            this.fViewer = viewer;
            this.populateImports();
        }

        protected void populateImports() {
            this.fImportNames = new ArrayList(1);
            if (SelectImportsDialog.this.fImports != null) {
                for (int i = 0; i < SelectImportsDialog.this.fImports.length; ++i) {
                    String name = SelectImportsDialog.this.fImports[i];
                    this.addImport(name);
                }
            }
        }

        protected void addImport(String name) {
            Filter imprt = new Filter(name, false);
            if (!this.fImportNames.contains(imprt)) {
                this.fImportNames.add(imprt);
                this.fViewer.add((Object)imprt);
            }
        }

        protected void removeImports(Object[] imports) {
            for (int i = 0; i < imports.length; ++i) {
                Filter imprt = (Filter)imports[i];
                this.fImportNames.remove(imprt);
            }
            this.fViewer.remove(imports);
        }

        public Object[] getElements(Object inputElement) {
            return this.fImportNames.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

