/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaClassPrepareBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.JDTDebugRefactoringUtil;
import org.eclipse.jdt.internal.debug.core.refactoring.JavaClassPrepareBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.JavaExceptionBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.JavaLineBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.JavaMethodBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.JavaWatchpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class JavaBreakpointTypeChange
extends Change {
    public static final int TYPE_RENAME = 1;
    public static final int TYPE_MOVE = 2;
    public static final int PROJECT_RENAME = 3;
    public static final int PACKAGE_RENAME = 4;
    public static final int PACKAGE_MOVE = 5;
    private IJavaBreakpoint fBreakpoint;
    private Object fChangedElement;
    private Object fArgument;
    private int fChangeType;
    private IType fDeclaringType;
    private boolean fIsEnable;
    private Map fAttributes;
    private int fHitCount;

    public static Change createChangesForTypeRename(IType type, String newName) throws CoreException {
        return JavaBreakpointTypeChange.createChangesForTypeChange(type, newName, 1);
    }

    public static Change createChangesForTypeMove(IType type, Object destination) throws CoreException {
        return JavaBreakpointTypeChange.createChangesForTypeChange(type, destination, 2);
    }

    public static Change createChangesForProjectRename(IJavaProject project, String newName) throws CoreException {
        ArrayList<Change> changes = new ArrayList<Change>();
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
        for (int i = 0; i < breakpoints.length; ++i) {
            IJavaBreakpoint javaBreakpoint;
            IType breakpointType;
            IBreakpoint breakpoint = breakpoints[i];
            if (!(breakpoint instanceof IJavaBreakpoint) || (breakpointType = BreakpointUtils.getType(javaBreakpoint = (IJavaBreakpoint)breakpoint)) == null || !project.equals(breakpointType.getJavaProject())) continue;
            changes.add(JavaBreakpointTypeChange.createChange(javaBreakpoint, null, newName, 3));
        }
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.getString("JavaBreakpointTypeChange.0"));
    }

    public static Change createChangesForPackageRename(IPackageFragment packageFragment, String newName) throws CoreException {
        return JavaBreakpointTypeChange.createChangesForPackageChange(packageFragment, newName, 4);
    }

    public static Change createChangesForPackageMove(IPackageFragment packageFragment, IPackageFragmentRoot destination) throws CoreException {
        return JavaBreakpointTypeChange.createChangesForPackageChange(packageFragment, destination, 5);
    }

    private static Change createChangesForTypeChange(IType changedType, Object argument, int changeType) throws CoreException {
        ArrayList<Change> changes = new ArrayList<Change>();
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
        String typeName = changedType.getFullyQualifiedName();
        for (int i = 0; i < breakpoints.length; ++i) {
            IJavaBreakpoint javaBreakpoint;
            IType breakpointType;
            IBreakpoint breakpoint = breakpoints[i];
            if (!(breakpoint instanceof IJavaBreakpoint) || (breakpointType = BreakpointUtils.getType(javaBreakpoint = (IJavaBreakpoint)breakpoint)) == null || !javaBreakpoint.getTypeName().startsWith(typeName)) continue;
            if (changedType.equals(breakpointType)) {
                changes.add(JavaBreakpointTypeChange.createChange(javaBreakpoint, changedType, argument, changeType));
                continue;
            }
            Change change = JavaBreakpointTypeChange.createChangesForOuterTypeChange(javaBreakpoint, changedType, changedType, argument, changeType);
            if (change == null) continue;
            changes.add(change);
        }
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.getString("JavaBreakpointTypeChange.0"));
    }

    private static Change createChangesForOuterTypeChange(IJavaBreakpoint javaBreakpoint, IType type, IType changedType, Object argument, int changeType) throws CoreException {
        IType[] innerTypes = type.getTypes();
        String breakpointTypeName = javaBreakpoint.getTypeName();
        IType breakpointType = BreakpointUtils.getType(javaBreakpoint);
        for (int i = 0; i < innerTypes.length; ++i) {
            IType innerType = innerTypes[i];
            if (!breakpointTypeName.startsWith(innerType.getFullyQualifiedName())) continue;
            if (innerType.equals(breakpointType)) {
                return JavaBreakpointTypeChange.createChange(javaBreakpoint, changedType, argument, changeType);
            }
            return JavaBreakpointTypeChange.createChangesForOuterTypeChange(javaBreakpoint, innerType, changedType, argument, changeType);
        }
        return null;
    }

    private static Change createChangesForPackageChange(IPackageFragment packageFragment, Object argument, int changeType) throws CoreException {
        ArrayList<Change> changes = new ArrayList<Change>();
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
        for (int i = 0; i < breakpoints.length; ++i) {
            IJavaBreakpoint javaBreakpoint;
            IType breakpointType;
            IBreakpoint breakpoint = breakpoints[i];
            if (!(breakpoint instanceof IJavaBreakpoint) || (breakpointType = BreakpointUtils.getType(javaBreakpoint = (IJavaBreakpoint)breakpoint)) == null || !packageFragment.equals(breakpointType.getPackageFragment())) continue;
            changes.add(JavaBreakpointTypeChange.createChange(javaBreakpoint, packageFragment, argument, changeType));
        }
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.getString("JavaBreakpointTypeChange.0"));
    }

    private static Change createChange(IJavaBreakpoint javaBreakpoint, Object changedElement, Object argument, int changeType) throws CoreException {
        if (javaBreakpoint instanceof IJavaClassPrepareBreakpoint) {
            return new JavaClassPrepareBreakpointTypeChange((IJavaClassPrepareBreakpoint)javaBreakpoint, changedElement, argument, changeType);
        }
        if (javaBreakpoint instanceof IJavaExceptionBreakpoint) {
            return new JavaExceptionBreakpointTypeChange((IJavaExceptionBreakpoint)javaBreakpoint, changedElement, argument, changeType);
        }
        if (javaBreakpoint instanceof IJavaMethodBreakpoint) {
            return new JavaMethodBreakpointTypeChange((IJavaMethodBreakpoint)javaBreakpoint, changedElement, argument, changeType);
        }
        if (javaBreakpoint instanceof IJavaWatchpoint) {
            return new JavaWatchpointTypeChange((IJavaWatchpoint)javaBreakpoint, changedElement, argument, changeType);
        }
        if (javaBreakpoint instanceof IJavaLineBreakpoint) {
            return new JavaLineBreakpointTypeChange((IJavaLineBreakpoint)javaBreakpoint, changedElement, argument, changeType);
        }
        return null;
    }

    protected JavaBreakpointTypeChange(IJavaBreakpoint breakpoint, Object changedElement, Object argument, int changeType) throws CoreException {
        this.fBreakpoint = breakpoint;
        this.fChangedElement = changedElement;
        this.fArgument = argument;
        this.fChangeType = changeType;
        this.fDeclaringType = BreakpointUtils.getType(breakpoint);
        this.fAttributes = breakpoint.getMarker().getAttributes();
        this.fIsEnable = breakpoint.isEnabled();
        this.fHitCount = breakpoint.getHitCount();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        if (!this.fBreakpoint.isRegistered()) {
            status.addFatalError(this.getErrorMessageNoMoreExists());
        }
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        switch (this.fChangeType) {
            case 1: {
                return this.performTypeRename();
            }
            case 2: {
                return this.performTypeMove();
            }
            case 3: {
                return this.performProjectRename();
            }
            case 4: {
                return this.performPackageRename();
            }
            case 5: {
                return this.performPackageMove();
            }
        }
        return null;
    }

    private Change performTypeRename() throws CoreException {
        IType newChangedType;
        IType newType;
        IType changedType = this.getChangedType();
        String oldChangedTypeName = changedType.getFullyQualifiedName();
        IType parent = changedType.getDeclaringType();
        String newChangedTypeName = parent == null ? changedType.getPackageFragment().getElementName() + '.' + this.getNewName() : parent.getFullyQualifiedName() + '$' + this.getNewName();
        IJavaProject project = this.fDeclaringType.getJavaProject();
        if (changedType == this.fDeclaringType) {
            newChangedType = newType = project.findType(newChangedTypeName);
        } else {
            String typeNameSuffix = this.fDeclaringType.getFullyQualifiedName().substring(oldChangedTypeName.length());
            String newTypeName = newChangedTypeName + typeNameSuffix;
            newType = project.findType(newTypeName);
            newChangedType = project.findType(newChangedTypeName);
        }
        this.performChange(newType, newChangedType, changedType.getElementName(), 1);
        return new NullChange();
    }

    private Change performTypeMove() throws CoreException {
        IType newChangedType;
        IType newType;
        IPackageFragment packageDestination;
        IType changedType = this.getChangedType();
        Object destination = this.getDestination();
        String newChangedTypeName = destination instanceof IPackageFragment ? ((packageDestination = (IPackageFragment)destination).isDefaultPackage() ? changedType.getElementName() : ((IPackageFragment)destination).getElementName() + '.' + changedType.getElementName()) : ((IType)destination).getFullyQualifiedName() + '$' + changedType.getElementName();
        IJavaProject project = this.fDeclaringType.getJavaProject();
        if (changedType == this.fDeclaringType) {
            newChangedType = newType = project.findType(newChangedTypeName);
        } else {
            String oldChangedTypeName = changedType.getFullyQualifiedName();
            String typeNameSuffix = this.fDeclaringType.getFullyQualifiedName().substring(oldChangedTypeName.length());
            String newTypeName = newChangedTypeName + typeNameSuffix;
            newType = project.findType(newTypeName);
            newChangedType = project.findType(newChangedTypeName);
        }
        IType oldDestination = changedType.getDeclaringType();
        if (oldDestination == null) {
            oldDestination = changedType.getPackageFragment();
        }
        this.performChange(newType, newChangedType, oldDestination, 2);
        return new NullChange();
    }

    private Change performProjectRename() throws CoreException {
        IJavaProject project = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(this.getNewName()));
        IType newType = project.findType(this.fDeclaringType.getFullyQualifiedName());
        this.performChange(newType, null, this.fDeclaringType.getJavaProject().getElementName(), 3);
        return new NullChange();
    }

    private Change performPackageRename() throws CoreException {
        IPackageFragment changedPackage = this.getChangePackage();
        IJavaProject project = this.fDeclaringType.getJavaProject();
        String newTypeName = this.getNewName() + this.fDeclaringType.getFullyQualifiedName().substring(changedPackage.getElementName().length());
        IType newType = project.findType(newTypeName);
        this.performChange(newType, newType.getPackageFragment(), changedPackage.getElementName(), 4);
        return new NullChange();
    }

    private Change performPackageMove() throws CoreException {
        IPackageFragmentRoot destination = this.getPackageRootDestination();
        IPackageFragment changedPackage = this.getChangePackage();
        IJavaProject project = destination.getJavaProject();
        IType newType = project.findType(this.fDeclaringType.getFullyQualifiedName());
        this.performChange(newType, newType.getPackageFragment(), changedPackage.getParent(), 3);
        return new NullChange();
    }

    public Object getModifiedElement() {
        return this.getBreakpoint();
    }

    public IJavaBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    public String getNewName() {
        if (this.fChangeType == 1 || this.fChangeType == 3 || this.fChangeType == 4) {
            return (String)this.fArgument;
        }
        return null;
    }

    private Object getDestination() {
        if (this.fChangeType == 2) {
            return this.fArgument;
        }
        return null;
    }

    private IPackageFragmentRoot getPackageRootDestination() {
        if (this.fChangeType == 5) {
            return (IPackageFragmentRoot)this.fArgument;
        }
        return null;
    }

    public IType getDeclaringType() {
        return this.fDeclaringType;
    }

    public IType getChangedType() {
        if (this.fChangeType == 1 || this.fChangeType == 2) {
            return (IType)this.fChangedElement;
        }
        return null;
    }

    public IPackageFragment getChangePackage() {
        if (this.fChangeType == 4 || this.fChangeType == 5) {
            return (IPackageFragment)this.fChangedElement;
        }
        return null;
    }

    public boolean getEnable() {
        return this.fIsEnable;
    }

    public Map getAttributes() {
        return this.fAttributes;
    }

    public int getHitCount() {
        return this.fHitCount;
    }

    public abstract String getErrorMessageNoMoreExists();

    public abstract Change performChange(IType var1, Object var2, Object var3, int var4) throws CoreException;
}

