/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public class BreakpointsViewEventHandler
implements IBreakpointsListener,
IActivityManagerListener {
    private BreakpointsView fView;

    public BreakpointsViewEventHandler(BreakpointsView view) {
        this.fView = view;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        if (activitySupport != null) {
            activitySupport.getActivityManager().addActivityManagerListener((IActivityManagerListener)this);
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        if (activitySupport != null) {
            activitySupport.getActivityManager().removeActivityManagerListener((IActivityManagerListener)this);
        }
    }

    public void breakpointsAdded(final IBreakpoint[] breakpoints) {
        if (this.fView.isAvailable() && this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    if (BreakpointsViewEventHandler.this.fView.isAvailable()) {
                        CheckboxTableViewer viewer = (CheckboxTableViewer)BreakpointsViewEventHandler.this.fView.getViewer();
                        MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 4, DebugUIViewsMessages.getString("BreakpointsViewEventHandler.4"), null);
                        for (int i = 0; i < breakpoints.length; ++i) {
                            IBreakpoint breakpoint = breakpoints[i];
                            if (!DebugPlugin.getDefault().getBreakpointManager().isRegistered(breakpoint)) continue;
                            viewer.add((Object)breakpoint);
                            try {
                                boolean enabled = breakpoint.isEnabled();
                                if (viewer.getChecked((Object)breakpoint) != enabled) {
                                    viewer.setChecked((Object)breakpoint, breakpoint.isEnabled());
                                }
                                if (DebugPlugin.getDefault().getBreakpointManager().isEnabled()) continue;
                                BreakpointsViewEventHandler.this.fView.updateViewerBackground();
                                continue;
                            }
                            catch (CoreException e) {
                                status.add(DebugUIPlugin.newErrorStatus(DebugUIViewsMessages.getString("BreakpointsViewEventHandler.5"), e));
                                DebugUIPlugin.log(e);
                            }
                        }
                        if (!status.isOK()) {
                            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIViewsMessages.getString("BreakpointsViewEventHandler.1"), DebugUIViewsMessages.getString("BreakpointsViewEventHandler.2"), (IStatus)status);
                        }
                        BreakpointsViewEventHandler.this.fView.updateObjects();
                    }
                }
            });
        }
    }

    public void breakpointsRemoved(final IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.fView.isAvailable() && this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    if (BreakpointsViewEventHandler.this.fView.isAvailable()) {
                        TableViewer viewer = (TableViewer)BreakpointsViewEventHandler.this.fView.getViewer();
                        int[] indices = viewer.getTable().getSelectionIndices();
                        viewer.getControl().setRedraw(false);
                        viewer.remove((Object[])breakpoints);
                        viewer.getControl().setRedraw(true);
                        if (viewer.getSelection().isEmpty()) {
                            if (indices.length > 0) {
                                int index = indices[0];
                                viewer.getTable().select(Math.min(index, viewer.getTable().getItemCount() - 1));
                            }
                            viewer.setSelection(viewer.getSelection());
                        }
                        BreakpointsViewEventHandler.this.fView.updateObjects();
                    }
                }
            });
        }
    }

    public void breakpointsChanged(final IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.fView.isAvailable() & this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    if (BreakpointsViewEventHandler.this.fView.isAvailable()) {
                        CheckboxTableViewer viewer = (CheckboxTableViewer)BreakpointsViewEventHandler.this.fView.getViewer();
                        viewer.getControl().setRedraw(false);
                        for (int i = 0; i < breakpoints.length; ++i) {
                            IBreakpoint breakpoint = breakpoints[i];
                            IMarker marker = breakpoint.getMarker();
                            if (marker == null || !marker.exists()) continue;
                            try {
                                boolean enabled = breakpoint.isEnabled();
                                if (viewer.getChecked((Object)breakpoint) != enabled) {
                                    viewer.setChecked((Object)breakpoint, breakpoint.isEnabled());
                                }
                            }
                            catch (CoreException e) {
                                DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIViewsMessages.getString("BreakpointsViewEventHandler.1"), DebugUIViewsMessages.getString("BreakpointsViewEventHandler.2"), e);
                                DebugUIPlugin.log(e);
                            }
                            viewer.refresh((Object)breakpoint);
                        }
                        viewer.getControl().setRedraw(true);
                        BreakpointsViewEventHandler.this.fView.updateObjects();
                    }
                }
            });
        }
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (this.fView.isAvailable() & this.fView.isVisible() && activityManagerEvent.haveEnabledActivityIdsChanged()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    BreakpointsViewEventHandler.this.fView.getViewer().refresh();
                    BreakpointsViewEventHandler.this.fView.initializeCheckedState();
                }
            });
        }
    }
}

