/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

 
/**
 * Pushes a boolean literal onto the stack.
 */
public class PushBoolean extends SimpleInstruction {
	private boolean fValue;
	
	public PushBoolean(boolean value) {
		fValue= value;
	}
	
	public void execute() {
		pushNewValue(fValue);
	}

	public String toString() {
		return InstructionsEvaluationMessages.getString("PushBoolean.push__1") + fValue; //$NON-NLS-1$
	}
}

