/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

public abstract class ResponseHandler {
    public abstract String getResponseID();

    public abstract void handle(Session var1, String var2, IProgressMonitor var3) throws CVSException;

    protected static ICVSFolder createFolder(Session session, String localDir, String repositoryDir) throws CVSException {
        ICVSFolder folder = session.getLocalRoot().getFolder(localDir);
        if (!(folder.exists() || CVSProviderPlugin.getPlugin().getPruneEmptyDirectories() && folder.getParent().isCVSFolder())) {
            folder.mkdir();
        }
        if (!folder.isCVSFolder()) {
            folder.setFolderSyncInfo(new FolderSyncInfo(Util.getRelativePath(session.getRepositoryRoot(), repositoryDir), session.getCVSRepositoryLocation().getLocation(), null, false));
        }
        return folder;
    }

    protected ICVSFolder getExistingFolder(Session session, String localDir) throws CVSException {
        IContainer container;
        ICVSFolder mParent = session.getLocalRoot().getFolder(localDir);
        if (!mParent.exists() && (container = (IContainer)mParent.getIResource()) != null) {
            this.recreatePhatomFolders(mParent);
        }
        return mParent;
    }

    private void recreatePhatomFolders(ICVSFolder folder) throws CVSException {
        ICVSFolder parent = folder.getParent();
        if (!parent.exists()) {
            this.recreatePhatomFolders(parent);
        }
        folder.mkdir();
    }

    ResponseHandler getInstance() {
        return this;
    }
}

