/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.core.BackgroundEventHandler;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.subscribers.SyncSetInputFromSubscriber;

public class SubscriberEventHandler
extends BackgroundEventHandler {
    private SyncSetInputFromSubscriber syncSetInput;
    private List resultCache = new ArrayList();
    private boolean started = false;
    private boolean initializing = true;
    private IProgressMonitor progressGroup;
    private int ticks;
    private IResource[] roots;

    public SubscriberEventHandler(Subscriber subscriber, IResource[] roots) {
        super(Policy.bind("SubscriberEventHandler.jobName", subscriber.getName()), Policy.bind("SubscriberEventHandler.errors", subscriber.getName()));
        this.roots = roots;
        this.syncSetInput = new SyncSetInputFromSubscriber(subscriber, this);
    }

    public synchronized void start() {
        this.started = true;
        IResource[] resources = this.roots;
        if (resources == null) {
            resources = this.syncSetInput.getSubscriber().roots();
        }
        this.reset(resources, 3);
        this.initializing = false;
    }

    protected synchronized void queueEvent(BackgroundEventHandler.Event event, boolean front) {
        if (this.started) {
            super.queueEvent(event, front);
        }
    }

    public void schedule() {
        Job job = this.getEventHandlerJob();
        if (job.getState() == 0) {
            if (this.progressGroup != null) {
                job.setSystem(false);
                job.setProgressGroup(this.progressGroup, this.ticks);
            } else {
                job.setSystem(!this.initializing);
            }
        }
        this.getEventHandlerJob().schedule();
    }

    protected void jobDone(IJobChangeEvent event) {
        super.jobDone(event);
        this.progressGroup = null;
    }

    public synchronized void reset(IResource[] roots) {
        if (roots == null) {
            roots = this.syncSetInput.getSubscriber().roots();
        } else {
            this.roots = roots;
        }
        this.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubscriberEventHandler.this.syncSetInput.reset(monitor);
            }
        }, false);
        this.reset(roots, 2);
    }

    public void change(IResource resource, int depth) {
        this.queueEvent(new SubscriberEvent(resource, 2, depth), false);
    }

    public void remove(IResource resource) {
        this.queueEvent(new SubscriberEvent(resource, 1, 2), false);
    }

    private void collect(IResource resource, int depth, IProgressMonitor monitor) {
        this.handlePreemptiveEvents(monitor);
        if (resource.getType() != 1 && depth != 0) {
            try {
                IResource[] members = this.syncSetInput.getSubscriber().members(resource);
                for (int i = 0; i < members.length; ++i) {
                    this.collect(members[i], depth == 2 ? 2 : 0, monitor);
                }
            }
            catch (TeamException e) {
                this.handleException(e, resource, 2, Policy.bind("SubscriberEventHandler.8", resource.getFullPath().toString(), e.getMessage()));
            }
        }
        monitor.subTask(Policy.bind("SubscriberEventHandler.2", resource.getFullPath().toString()));
        try {
            SyncInfo info = this.syncSetInput.getSubscriber().getSyncInfo(resource);
            if (info == null) {
                this.resultCache.add(new SubscriberEvent(resource, 1, 0));
            } else {
                this.resultCache.add(new SubscriberEvent(resource, 2, 0, info));
            }
            this.handlePendingDispatch(monitor);
        }
        catch (TeamException e) {
            this.handleException(e, resource, 1, Policy.bind("SubscriberEventHandler.9", resource.getFullPath().toString(), e.getMessage()));
        }
        monitor.worked(1);
    }

    private void handlePendingDispatch(IProgressMonitor monitor) {
        if (this.isReadyForDispatch(false)) {
            try {
                this.dispatchEvents(Policy.subMonitorFor(monitor, 5));
            }
            catch (TeamException e) {
                this.handleException(e, null, 2, e.getMessage());
            }
        }
    }

    private void handleException(CoreException e, IResource resource, int code, String message) {
        this.handleException(e);
        this.syncSetInput.handleError(new TeamStatus(4, "org.eclipse.team.core", code, message, e, resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectAll(IResource resource, int depth, IProgressMonitor monitor) {
        monitor.beginTask(null, -1);
        try {
            SubProgressMonitor collectionMonitor = new SubProgressMonitor(monitor, -1){
                boolean dispatching = false;

                public void subTask(String name) {
                    this.dispatch();
                    super.subTask(name);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void dispatch() {
                    if (this.dispatching) {
                        return;
                    }
                    try {
                        this.dispatching = true;
                        SubscriberEventHandler.this.handlePreemptiveEvents((IProgressMonitor)this);
                        SubscriberEventHandler.this.handlePendingDispatch((IProgressMonitor)this);
                    }
                    finally {
                        this.dispatching = false;
                    }
                }

                public void worked(int work) {
                    this.dispatch();
                    super.worked(work);
                }
            };
            SyncInfoSet collectionSet = new SyncInfoSet(){

                public void add(SyncInfo info) {
                    super.add(info);
                    SubscriberEventHandler.this.resultCache.add(new SubscriberEvent(info.getLocal(), 2, 0, info));
                }

                public void addError(ITeamStatus status) {
                    super.addError(status);
                    TeamPlugin.getPlugin().getLog().log((IStatus)status);
                    SubscriberEventHandler.this.syncSetInput.handleError(status);
                }

                public void remove(IResource resource) {
                    super.remove(resource);
                    SubscriberEventHandler.this.resultCache.add(new SubscriberEvent(resource, 1, 0));
                }
            };
            this.syncSetInput.getSubscriber().collectOutOfSync(new IResource[]{resource}, depth, collectionSet, (IProgressMonitor)collectionMonitor);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvents(SubscriberEvent[] events, IProgressMonitor monitor) {
        try {
            this.syncSetInput.getSyncSet().beginInput();
            block7: for (int i = 0; i < events.length; ++i) {
                SubscriberEvent event = events[i];
                switch (event.getType()) {
                    case 2: {
                        this.syncSetInput.collect(event.getResult(), monitor);
                        continue block7;
                    }
                    case 1: {
                        this.syncSetInput.getSyncSet().remove(event.getResource(), event.getDepth());
                    }
                }
            }
        }
        finally {
            this.syncSetInput.getSyncSet().endInput(monitor);
        }
    }

    private void reset(IResource[] roots, int type) {
        IResource[] resources = roots;
        for (int i = 0; i < resources.length; ++i) {
            this.queueEvent(new SubscriberEvent(resources[i], type, 2), false);
        }
    }

    protected void processEvent(BackgroundEventHandler.Event event, IProgressMonitor monitor) {
        try {
            int type = event.getType();
            switch (type) {
                case 1000: {
                    this.executeRunnable(event, monitor);
                    break;
                }
                case 1: {
                    this.resultCache.add(event);
                    break;
                }
                case 2: {
                    this.collect(event.getResource(), event.getDepth(), monitor);
                    break;
                }
                case 3: {
                    monitor.subTask(Policy.bind("SubscriberEventHandler.2", event.getResource().getFullPath().toString()));
                    this.collectAll(event.getResource(), event.getDepth(), Policy.subMonitorFor(monitor, 64));
                }
            }
        }
        catch (OperationCanceledException e) {
            this.resultCache.clear();
            this.syncSetInput.handleError(new TeamStatus(4, "org.eclipse.team.core", 3, Policy.bind("SubscriberEventHandler.12"), e, (IResource)ResourcesPlugin.getWorkspace().getRoot()));
        }
        catch (RuntimeException e) {
            this.handleException(new TeamException(Policy.bind("SubscriberEventHandler.10"), e), event.getResource(), 2, Policy.bind("SubscriberEventHandler.11", event.getResource().getFullPath().toString(), e.getMessage()));
        }
    }

    private void executeRunnable(BackgroundEventHandler.Event event, IProgressMonitor monitor) {
        try {
            this.dispatchEvents(Policy.subMonitorFor(monitor, 1));
        }
        catch (TeamException e) {
            this.handleException(e, event.getResource(), 2, e.getMessage());
        }
        try {
            ((RunnableEvent)event).run(Policy.subMonitorFor(monitor, 1));
        }
        catch (CoreException e) {
            this.handleException(e, event.getResource(), 2, e.getMessage());
        }
    }

    protected boolean doDispatchEvents(IProgressMonitor monitor) {
        if (!this.resultCache.isEmpty()) {
            this.dispatchEvents(this.resultCache.toArray(new SubscriberEvent[this.resultCache.size()]), monitor);
            this.resultCache.clear();
            return true;
        }
        return false;
    }

    public void run(IWorkspaceRunnable runnable, boolean frontOnQueue) {
        this.queueEvent(new RunnableEvent(runnable, frontOnQueue), frontOnQueue);
    }

    public SyncSetInputFromSubscriber getSyncSetInput() {
        return this.syncSetInput;
    }

    public void setProgressGroupHint(IProgressMonitor progressGroup, int ticks) {
        this.progressGroup = progressGroup;
        this.ticks = ticks;
    }

    protected boolean isStarted() {
        return this.started;
    }

    private void handlePreemptiveEvents(IProgressMonitor monitor) {
        BackgroundEventHandler.Event event = this.peek();
        if (event instanceof RunnableEvent && ((RunnableEvent)event).isPreemtive()) {
            this.executeRunnable(this.nextElement(), monitor);
        }
    }

    public class RunnableEvent
    extends BackgroundEventHandler.Event {
        static final int RUNNABLE = 1000;
        private IWorkspaceRunnable runnable;
        private boolean preemtive;

        public RunnableEvent(IWorkspaceRunnable runnable, boolean preemtive) {
            super((IResource)ResourcesPlugin.getWorkspace().getRoot(), 1000, 0);
            this.runnable = runnable;
            this.preemtive = preemtive;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            this.runnable.run(monitor);
        }

        public boolean isPreemtive() {
            return this.preemtive;
        }
    }

    class SubscriberEvent
    extends BackgroundEventHandler.Event {
        static final int REMOVAL = 1;
        static final int CHANGE = 2;
        static final int INITIALIZE = 3;
        SyncInfo result;

        SubscriberEvent(IResource resource, int type, int depth) {
            super(resource, type, depth);
        }

        public SubscriberEvent(IResource resource, int type, int depth, SyncInfo result) {
            this(resource, type, depth);
            this.result = result;
        }

        public SyncInfo getResult() {
            return this.result;
        }

        protected String getTypeString() {
            switch (this.getType()) {
                case 1: {
                    return "REMOVAL";
                }
                case 2: {
                    return "CHANGE";
                }
                case 3: {
                    return "INITIALIZE";
                }
            }
            return "INVALID";
        }
    }
}

