/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.team.internal.core.InfiniteSubProgressMonitor;
import org.eclipse.team.internal.core.TeamPlugin;

public class Policy {
    protected static ResourceBundle bundle = null;
    public static boolean DEBUG_STREAMS = false;
    public static boolean DEBUG_REFRESH_JOB = true;
    public static boolean DEBUG_BACKGROUND_EVENTS = false;

    public static void localize(String bundleName) {
        bundle = ResourceBundle.getBundle(bundleName);
    }

    public static String bind(String id, String binding) {
        return Policy.bind(id, new String[]{binding});
    }

    public static String bind(String id, String binding1, String binding2) {
        return Policy.bind(id, new String[]{binding1, binding2});
    }

    public static String bind(String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        catch (NullPointerException e) {
            return "!" + key + "!";
        }
    }

    public static String bind(String key, Object[] args) {
        try {
            return MessageFormat.format(Policy.bind(key), args);
        }
        catch (MissingResourceException e) {
            return key;
        }
        catch (NullPointerException e) {
            return "!" + key + "!";
        }
    }

    public static void checkCanceled(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    public static IProgressMonitor infiniteSubMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new InfiniteSubProgressMonitor(monitor, ticks);
    }

    static {
        if (TeamPlugin.getPlugin().isDebugging()) {
            DEBUG_STREAMS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.team.core/streams"));
            DEBUG_REFRESH_JOB = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.team.core/refreshjob"));
            DEBUG_BACKGROUND_EVENTS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.team.core/backgroundevents"));
        }
    }
}

