/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.participants;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.internal.core.refactoring.Assert;
import org.eclipse.ltk.internal.core.refactoring.ParticipantDescriptor;

public abstract class RefactoringParticipant
extends PlatformObject {
    private RefactoringProcessor fProcessor;
    private ParticipantDescriptor fDescriptor;

    public RefactoringProcessor getProcessor() {
        return this.fProcessor;
    }

    public boolean initialize(RefactoringProcessor processor, Object element, RefactoringArguments arguments) {
        Assert.isNotNull((Object)processor);
        Assert.isNotNull(arguments);
        this.fProcessor = processor;
        this.initialize(arguments);
        return this.initialize(element);
    }

    protected abstract boolean initialize(Object var1);

    protected abstract void initialize(RefactoringArguments var1);

    public abstract String getName();

    public abstract RefactoringStatus checkConditions(IProgressMonitor var1, CheckConditionsContext var2) throws OperationCanceledException;

    public abstract Change createChange(IProgressMonitor var1) throws CoreException, OperationCanceledException;

    void setDescriptor(ParticipantDescriptor descriptor) {
        Assert.isNotNull(descriptor);
        this.fDescriptor = descriptor;
    }

    ParticipantDescriptor getDescriptor() {
        return this.fDescriptor;
    }
}

