/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.internal.core.refactoring.Assert;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

public abstract class TextChange
extends Change {
    private String fName;
    private List fTextEditChangeGroups;
    private TextEditCopier fCopier;
    private TextEdit fEdit;
    private boolean fTrackEdits;
    private String fTextType;
    private static final TextEditChangeGroup[] ALL_EDITS = new TextEditChangeGroup[0];

    protected TextChange(String name) {
        Assert.isNotNull(name);
        this.fName = name;
        this.fTextEditChangeGroups = new ArrayList(5);
        this.fTextType = "txt";
    }

    public String getName() {
        return this.fName;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Iterator iter = this.fTextEditChangeGroups.iterator();
        while (iter.hasNext()) {
            TextEditChangeGroup element = (TextEditChangeGroup)iter.next();
            element.setEnabled(enabled);
        }
    }

    public void setTextType(String type) {
        if (type == null) {
            type = "txt";
        }
        this.fTextType = type;
    }

    public String getTextType() {
        return this.fTextType;
    }

    public void setEdit(TextEdit edit) {
        Assert.isTrue(this.fEdit == null, "Root edit can only be set once");
        Assert.isTrue(edit != null);
        this.fEdit = edit;
    }

    public TextEdit getEdit() {
        return this.fEdit;
    }

    public void addTextEditGroup(TextEditGroup group) {
        this.addTextEditChangeGroup(new TextEditChangeGroup(this, group));
    }

    public void addTextEditChangeGroup(TextEditChangeGroup group) {
        Assert.isTrue(this.fEdit != null, "Can only add a description if a root edit exists");
        Assert.isTrue(group != null);
        this.fTextEditChangeGroups.add(group);
    }

    public TextEditChangeGroup[] getTextEditChangeGroups() {
        return this.fTextEditChangeGroups.toArray(new TextEditChangeGroup[this.fTextEditChangeGroups.size()]);
    }

    protected abstract IDocument acquireDocument(IProgressMonitor var1) throws CoreException;

    protected abstract void commit(IDocument var1, IProgressMonitor var2) throws CoreException;

    protected abstract void releaseDocument(IDocument var1, IProgressMonitor var2) throws CoreException;

    protected abstract Change createUndoChange(UndoEdit var1);

    public Change perform(IProgressMonitor pm) throws CoreException {
        Change change;
        block5: {
            pm.beginTask("", 3);
            IDocument document = null;
            try {
                document = this.acquireDocument((IProgressMonitor)new SubProgressMonitor(pm, 1));
                TextEditProcessor processor = this.createTextEditProcessor(document, 1, false);
                UndoEdit undo = processor.performEdits();
                this.commit(document, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                change = this.createUndoChange(undo);
                Object var7_7 = null;
                if (document == null) break block5;
            }
            catch (BadLocationException e) {
                try {
                    throw Changes.asCoreException(e);
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (document != null) {
                        this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    }
                    pm.done();
                    throw throwable;
                }
            }
            this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        pm.done();
        return change;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDocument getCurrentDocument(IProgressMonitor pm) throws CoreException {
        IDocument result;
        block4: {
            if (pm == null) {
                pm = new NullProgressMonitor();
            }
            result = null;
            pm.beginTask("", 2);
            try {
                result = this.acquireDocument((IProgressMonitor)new SubProgressMonitor(pm, 1));
                Object var4_3 = null;
                if (result == null) break block4;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (result != null) {
                    this.releaseDocument(result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                throw throwable;
            }
            this.releaseDocument(result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        pm.done();
        return result;
    }

    public String getCurrentContent(IProgressMonitor pm) throws CoreException {
        return this.getCurrentDocument(pm).get();
    }

    public String getCurrentContent(IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        Assert.isNotNull(region);
        Assert.isTrue(surroundingLines >= 0);
        IDocument document = this.getCurrentDocument(pm);
        Assert.isTrue(document.getLength() >= region.getOffset() + region.getLength());
        return this.getContent(document, region, expandRegionToFullLine, surroundingLines);
    }

    public void setKeepPreviewEdits(boolean keep) {
        this.fTrackEdits = keep;
        if (!this.fTrackEdits) {
            this.fCopier = null;
        }
    }

    public boolean getKeepPreviewEdits() {
        return this.fTrackEdits;
    }

    public TextEdit getPreviewEdit(TextEdit original) {
        Assert.isTrue(this.fTrackEdits && this.fCopier != null && original != null);
        return this.fCopier.getCopy(original);
    }

    public TextEdit[] getPreviewEdits(TextEdit[] originals) {
        Assert.isTrue(this.fTrackEdits && this.fCopier != null && originals != null);
        if (originals.length == 0) {
            return new TextEdit[0];
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>(originals.length);
        for (int i = 0; i < originals.length; ++i) {
            TextEdit copy = this.fCopier.getCopy(originals[i]);
            if (copy == null) continue;
            result.add(copy);
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    public IDocument getPreviewDocument(IProgressMonitor pm) throws CoreException {
        PreviewAndRegion result = this.getPreviewDocument(ALL_EDITS, pm);
        return result.document;
    }

    public String getPreviewContent(IProgressMonitor pm) throws CoreException {
        return this.getPreviewDocument(pm).get();
    }

    public String getPreviewContent(TextEditChangeGroup[] changeGroups, IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        IRegion currentRegion = this.getRegion(changeGroups);
        Assert.isTrue(region.getOffset() <= currentRegion.getOffset() && currentRegion.getOffset() + currentRegion.getLength() <= region.getOffset() + region.getLength());
        PreviewAndRegion result = this.getPreviewDocument(changeGroups, pm);
        int delta = result.region.getLength() - currentRegion.getLength();
        return this.getContent(result.document, (IRegion)new Region(region.getOffset(), region.getLength() + delta), expandRegionToFullLine, surroundingLines);
    }

    private PreviewAndRegion getPreviewDocument(TextEditChangeGroup[] changes, IProgressMonitor pm) throws CoreException {
        Document document = new Document(this.getCurrentDocument(pm).get());
        boolean trackChanges = this.fTrackEdits;
        this.setKeepPreviewEdits(true);
        TextEditProcessor processor = changes == ALL_EDITS ? this.createTextEditProcessor((IDocument)document, 0, true) : this.createTextEditProcessor((IDocument)document, 0, changes);
        try {
            processor.performEdits();
            PreviewAndRegion previewAndRegion = new PreviewAndRegion((IDocument)document, this.getNewRegion(changes));
            return previewAndRegion;
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException(e);
        }
        finally {
            this.setKeepPreviewEdits(trackChanges);
        }
    }

    private TextEditProcessor createTextEditProcessor(IDocument document, int flags, boolean preview) {
        if (this.fEdit == null) {
            return new TextEditProcessor(document, (TextEdit)new MultiTextEdit(0, 0), flags);
        }
        ArrayList<TextEdit> excludes = new ArrayList<TextEdit>(0);
        Iterator iter = this.fTextEditChangeGroups.iterator();
        while (iter.hasNext()) {
            TextEditChangeGroup edit = (TextEditChangeGroup)iter.next();
            if (edit.isEnabled()) continue;
            excludes.addAll(Arrays.asList(edit.getTextEditGroup().getTextEdits()));
        }
        if (preview) {
            this.fCopier = new TextEditCopier(this.fEdit);
            TextEdit copiedEdit = this.fCopier.perform();
            if (this.fTrackEdits) {
                flags |= 2;
            }
            LocalTextEditProcessor result = new LocalTextEditProcessor(document, copiedEdit, flags);
            result.setExcludes(this.mapEdits(excludes.toArray(new TextEdit[excludes.size()]), this.fCopier));
            if (!this.fTrackEdits) {
                this.fCopier = null;
            }
            return result;
        }
        LocalTextEditProcessor result = new LocalTextEditProcessor(document, this.fEdit, flags | 2);
        result.setExcludes(excludes.toArray(new TextEdit[excludes.size()]));
        return result;
    }

    private TextEditProcessor createTextEditProcessor(IDocument document, int flags, TextEditChangeGroup[] changes) {
        if (this.fEdit == null) {
            return new TextEditProcessor(document, (TextEdit)new MultiTextEdit(0, 0), flags);
        }
        ArrayList<TextEdit> includes = new ArrayList<TextEdit>(0);
        for (int c = 0; c < changes.length; ++c) {
            TextEditChangeGroup change = changes[c];
            Assert.isTrue(change.getTextChange() == this);
            if (!change.isEnabled()) continue;
            includes.addAll(Arrays.asList(change.getTextEditGroup().getTextEdits()));
        }
        this.fCopier = new TextEditCopier(this.fEdit);
        TextEdit copiedEdit = this.fCopier.perform();
        if (this.fTrackEdits) {
            flags |= 2;
        }
        LocalTextEditProcessor result = new LocalTextEditProcessor(document, copiedEdit, flags);
        result.setIncludes(this.mapEdits(includes.toArray(new TextEdit[includes.size()]), this.fCopier));
        if (!this.fTrackEdits) {
            this.fCopier = null;
        }
        return result;
    }

    private TextEdit[] mapEdits(TextEdit[] edits, TextEditCopier copier) {
        if (edits == null) {
            return null;
        }
        for (int i = 0; i < edits.length; ++i) {
            edits[i] = copier.getCopy(edits[i]);
        }
        return edits;
    }

    private String getContent(IDocument document, IRegion region, boolean expandRegionToFullLine, int surroundingLines) throws CoreException {
        try {
            if (expandRegionToFullLine) {
                int startLine = Math.max(document.getLineOfOffset(region.getOffset()) - surroundingLines, 0);
                int endLine = region.getLength() == 0 ? Math.min(document.getLineOfOffset(region.getOffset()) + surroundingLines, document.getNumberOfLines() - 1) : Math.min(document.getLineOfOffset(region.getOffset() + region.getLength() - 1) + surroundingLines, document.getNumberOfLines() - 1);
                int offset = document.getLineInformation(startLine).getOffset();
                IRegion endLineRegion = document.getLineInformation(endLine);
                int length = endLineRegion.getOffset() + endLineRegion.getLength() - offset;
                return document.get(offset, length);
            }
            return document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException(e);
        }
    }

    private IRegion getRegion(TextEditChangeGroup[] changes) {
        if (changes == ALL_EDITS) {
            if (this.fEdit == null) {
                return null;
            }
            return this.fEdit.getRegion();
        }
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        for (int i = 0; i < changes.length; ++i) {
            edits.addAll(Arrays.asList(changes[i].getTextEditGroup().getTextEdits()));
        }
        if (edits.size() == 0) {
            return null;
        }
        return TextEdit.getCoverage((TextEdit[])edits.toArray(new TextEdit[edits.size()]));
    }

    private IRegion getNewRegion(TextEditChangeGroup[] changes) {
        if (changes == ALL_EDITS) {
            if (this.fEdit == null) {
                return null;
            }
            return this.fCopier.getCopy(this.fEdit).getRegion();
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        for (int c = 0; c < changes.length; ++c) {
            TextEdit[] edits = changes[c].getTextEditGroup().getTextEdits();
            for (int e = 0; e < edits.length; ++e) {
                TextEdit copy = this.fCopier.getCopy(edits[e]);
                if (copy == null) continue;
                result.add(copy);
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return TextEdit.getCoverage((TextEdit[])result.toArray(new TextEdit[result.size()]));
    }

    private static class PreviewAndRegion {
        public IDocument document;
        public IRegion region;

        public PreviewAndRegion(IDocument d, IRegion r) {
            this.document = d;
            this.region = r;
        }
    }

    private static class LocalTextEditProcessor
    extends TextEditProcessor {
        public static final int EXCLUDE = 1;
        public static final int INCLUDE = 2;
        private TextEdit[] fExcludes;
        private TextEdit[] fIncludes;

        public LocalTextEditProcessor(IDocument document, TextEdit root, int flags) {
            super(document, root, flags);
        }

        public void setIncludes(TextEdit[] includes) {
            Assert.isNotNull(includes);
            Assert.isTrue(this.fExcludes == null);
            this.fIncludes = this.flatten(includes);
        }

        public void setExcludes(TextEdit[] excludes) {
            Assert.isNotNull(excludes);
            Assert.isTrue(this.fIncludes == null);
            this.fExcludes = excludes;
        }

        protected boolean considerEdit(TextEdit edit) {
            if (this.fExcludes != null) {
                for (int i = 0; i < this.fExcludes.length; ++i) {
                    if (!edit.equals((Object)this.fExcludes[i])) continue;
                    return false;
                }
                return true;
            }
            if (this.fIncludes != null) {
                for (int i = 0; i < this.fIncludes.length; ++i) {
                    if (!edit.equals((Object)this.fIncludes[i])) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        private TextEdit[] flatten(TextEdit[] edits) {
            ArrayList result = new ArrayList(5);
            for (int i = 0; i < edits.length; ++i) {
                this.flatten(result, edits[i]);
            }
            return result.toArray(new TextEdit[result.size()]);
        }

        private void flatten(List result, TextEdit edit) {
            result.add(edit);
            TextEdit[] children = edit.getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.flatten(result, children[i]);
            }
        }
    }
}

