/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.BaseSiteFactory;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.FeaturePackagedContentProvider;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SiteFile;
import org.eclipse.update.internal.core.SiteFileContentProvider;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.model.BundleManifest;
import org.eclipse.update.internal.model.DefaultPluginParser;
import org.xml.sax.SAXException;

public class SiteFileFactory
extends BaseSiteFactory {
    private SiteFile site;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISite createSite(URL url) throws CoreException, InvalidSiteTypeException {
        Site site = null;
        InputStream siteStream = null;
        SiteFileFactory factory = this;
        try {
            try {
                String path = url.getFile();
                File siteLocation = new File(path);
                if (siteLocation.isDirectory()) {
                    url = siteLocation.toURL();
                    File siteXMLFile = new File(siteLocation, "site.xml");
                    if (siteXMLFile.exists()) {
                        siteStream = new FileInputStream(siteXMLFile);
                        site = (Site)factory.parseSite(siteStream);
                    } else {
                        site = this.parseSite(siteLocation);
                    }
                } else {
                    try {
                        URL resolvedURL = URLEncoder.encode(url);
                        siteStream = this.openStream(resolvedURL);
                        site = (Site)factory.parseSite(siteStream);
                    }
                    catch (IOException e) {
                        File file = new File(url.getFile());
                        File parentDirectory = file.getParentFile();
                        if (parentDirectory != null && !parentDirectory.exists()) {
                            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.DirectoryDoesNotExist", file.getAbsolutePath()), null);
                        }
                        if (parentDirectory == null) throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToObtainParentDirectory", file.getAbsolutePath()), null);
                        if (!parentDirectory.isDirectory()) {
                            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToObtainParentDirectory", file.getAbsolutePath()), null);
                        }
                        site = this.parseSite(parentDirectory);
                    }
                }
                SiteFileContentProvider contentProvider = new SiteFileContentProvider(url);
                site.setSiteContentProvider(contentProvider);
                contentProvider.setSite(site);
                site.resolve(url, url);
            }
            catch (MalformedURLException e) {
                String string;
                if (url == null) {
                    string = "";
                    throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToCreateURL", string), e);
                }
                string = url.toExternalForm();
                throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToCreateURL", string), e);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToAccessSite"), 42, e);
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {
                if (siteStream == null) throw throwable;
                siteStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (siteStream == null) return site;
        siteStream.close();
        return site;
    }

    private Site parseSite(File directory) throws CoreException {
        this.site = (SiteFile)this.createSiteMapModel();
        if (!directory.exists()) {
            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.FileDoesNotExist", directory.getAbsolutePath()), null);
        }
        File pluginPath = new File(directory, "plugins/");
        this.parsePackagedFeature(directory);
        this.parsePackagedPlugins(pluginPath);
        this.parseInstalledFeature(directory);
        this.parseInstalledPlugins(pluginPath);
        return this.site;
    }

    private void parseInstalledFeature(File directory) throws CoreException {
        File featureDir = new File(directory, "features/");
        if (featureDir.exists()) {
            String newFilePath = null;
            try {
                String[] dir = featureDir.list();
                for (int index = 0; index < dir.length; ++index) {
                    newFilePath = dir[index] + (dir[index].endsWith("/") ? "/" : "");
                    File currentFeatureDir = new File(featureDir, newFilePath);
                    File featureXMLFile = new File(currentFeatureDir, "feature.xml");
                    if (!featureXMLFile.exists()) {
                        UpdateCore.warn("Unable to find feature.xml in directory:" + currentFeatureDir);
                        continue;
                    }
                    URL featureURL = currentFeatureDir.toURL();
                    SiteFeatureReferenceModel featureRef = this.createFeatureReferenceModel();
                    featureRef.setSiteModel(this.site);
                    featureRef.setURLString(featureURL.toExternalForm());
                    featureRef.setType("org.eclipse.update.core.installed");
                    this.site.addFeatureReferenceModel(featureRef);
                }
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToCreateURLForFile", newFilePath), e);
            }
        }
    }

    private void parsePackagedFeature(File directory) throws CoreException {
        File featureDir = new File(directory, "features/");
        if (featureDir.exists()) {
            String newFilePath = null;
            try {
                String[] dir = featureDir.list(FeaturePackagedContentProvider.filter);
                for (int index = 0; index < dir.length; ++index) {
                    File currentFeatureFile = new File(featureDir, dir[index]);
                    JarContentReference ref = new JarContentReference("", currentFeatureFile);
                    ContentReference result = null;
                    try {
                        result = ref.peek("feature.xml", null, null);
                    }
                    catch (IOException e) {
                        UpdateCore.warn("Exception retrieving feature.xml in file:" + currentFeatureFile, e);
                    }
                    if (result == null) {
                        UpdateCore.warn("Unable to find feature.xml in file:" + currentFeatureFile);
                        continue;
                    }
                    URL featureURL = currentFeatureFile.toURL();
                    SiteFeatureReferenceModel featureRef = this.createFeatureReferenceModel();
                    featureRef.setSiteModel(this.site);
                    featureRef.setURLString(featureURL.toExternalForm());
                    featureRef.setType("org.eclipse.update.core.packaged");
                    this.site.addFeatureReferenceModel(featureRef);
                }
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToCreateURLForFile", newFilePath), e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseInstalledPlugins(File pluginsDir) throws CoreException {
        if (!pluginsDir.exists()) return;
        if (!pluginsDir.isDirectory()) {
            return;
        }
        File[] dirs = pluginsDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        DefaultPluginParser parser = new DefaultPluginParser();
        int i = 0;
        while (i < dirs.length) {
            block14: {
                IOException e4;
                Object var10_11;
                File pluginFile = new File(dirs[i], "META-INF/MANIFEST.MF");
                InputStream in = null;
                try {
                    block13: {
                        String pluginFileString;
                        try {
                            PluginEntry entry;
                            BundleManifest bundleManifest = new BundleManifest(pluginFile);
                            if (bundleManifest.exists()) {
                                entry = bundleManifest.getPluginEntry();
                                this.addParsedPlugin(entry, dirs[i]);
                                break block13;
                            }
                            pluginFile = new File(dirs[i], "plugin.xml");
                            if (!pluginFile.exists()) {
                                pluginFile = new File(dirs[i], "fragment.xml");
                            }
                            if (pluginFile != null && pluginFile.exists() && !pluginFile.isDirectory()) {
                                in = new FileInputStream(pluginFile);
                                entry = parser.parse(in);
                                this.addParsedPlugin(entry, dirs[i]);
                            }
                        }
                        catch (IOException e2) {
                            pluginFileString = pluginFile == null ? null : pluginFile.getAbsolutePath();
                            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.ErrorAccessing", pluginFileString), e2);
                        }
                        catch (SAXException e3) {
                            pluginFileString = pluginFile == null ? null : pluginFile.getAbsolutePath();
                            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.ErrorParsingFile", pluginFileString), e3);
                        }
                    }
                    var10_11 = null;
                    if (in == null) break block14;
                }
                catch (Throwable throwable) {
                    var10_11 = null;
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e4) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e4) {}
                in.close();
            }
            ++i;
        }
    }

    private void addParsedPlugin(PluginEntry entry, File file) throws CoreException {
        String location = null;
        try {
            if (entry != null) {
                ((Site)this.site).addPluginEntry(entry);
                ArchiveReferenceModel archive = this.createArchiveReferenceModel();
                String id = entry.getVersionedIdentifier().toString();
                String pluginID = "plugins/" + id + ".jar";
                archive.setPath(pluginID);
                location = file.toURL().toExternalForm();
                archive.setURLString(location);
                this.site.addArchiveReferenceModel(archive);
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
                    UpdateCore.debug("Added archive to site:" + pluginID + " pointing to: " + location);
                }
            }
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToCreateURLForFile", location), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parsePackagedPlugins(File pluginDir) throws CoreException {
        if (!pluginDir.exists()) {
            return;
        }
        String[] dir = pluginDir.list(FeaturePackagedContentProvider.filter);
        int i = 0;
        while (i < dir.length) {
            block18: {
                IOException ce2;
                Object var11_14;
                InputStream in;
                block20: {
                    block19: {
                        ContentReference ref = null;
                        String refString = null;
                        in = null;
                        try {
                            try {
                                BundleManifest manifest;
                                File file = new File(pluginDir, dir[i]);
                                JarContentReference jarReference = new JarContentReference(null, file);
                                ref = jarReference.peek("META-INF/MANIFEST.MF", null, null);
                                if (ref != null && (manifest = new BundleManifest(in = ref.getInputStream())).exists()) {
                                    this.addParsedPlugin(manifest.getPluginEntry(), file);
                                    var11_14 = null;
                                    if (in == null) break block18;
                                    break block19;
                                }
                                ref = jarReference.peek("plugin.xml", null, null);
                                if (ref == null) {
                                    ref = jarReference.peek("fragment.xml", null, null);
                                }
                                if (ref == null) break block20;
                                in = ref.getInputStream();
                                PluginEntry entry = new DefaultPluginParser().parse(in);
                                this.addParsedPlugin(entry, file);
                                break block20;
                            }
                            catch (IOException e) {
                                try {
                                    refString = ref == null ? null : ref.asURL().toExternalForm();
                                    throw Utilities.newCoreException(Policy.bind("SiteFileFactory.ErrorAccessing", refString), e);
                                }
                                catch (IOException ioe) {
                                    // empty catch block
                                }
                                throw Utilities.newCoreException(Policy.bind("SiteFileFactory.ErrorAccessing", refString), e);
                            }
                            catch (SAXException e) {
                                try {
                                    refString = ref == null ? null : ref.asURL().toExternalForm();
                                    throw Utilities.newCoreException(Policy.bind("SiteFileFactory.ErrorParsingFile", refString), e);
                                }
                                catch (IOException ioe) {
                                    // empty catch block
                                }
                                throw Utilities.newCoreException(Policy.bind("SiteFileFactory.ErrorParsingFile", refString), e);
                            }
                        }
                        catch (Throwable throwable) {
                            var11_14 = null;
                            if (in == null) throw throwable;
                            try {
                                in.close();
                                throw throwable;
                            }
                            catch (IOException ce2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                    try {}
                    catch (IOException ce2) {}
                    in.close();
                    break block18;
                }
                var11_14 = null;
                if (in != null) {
                    try {}
                    catch (IOException ce2) {}
                    in.close();
                }
            }
            ++i;
        }
    }

    public SiteModel createSiteMapModel() {
        return new SiteFile();
    }

    public boolean canParseSiteType(String type) {
        return super.canParseSiteType(type) || "org.eclipse.update.core.file".equalsIgnoreCase(type);
    }
}

