/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.internal.core.UpdateCore;

public class InstallRegistry
extends Properties {
    private File file = null;
    private static final String REGISTRY = "registry";
    private static InstallRegistry instance;
    private HashMap justInstalledPlugins = new HashMap();

    private InstallRegistry() {
        String configFile = ConfiguratorUtils.getCurrentPlatformConfiguration().getConfigurationLocation().getFile();
        this.file = new File(configFile);
        this.file = this.file.getParentFile();
        this.file = new File(this.file, REGISTRY);
        this.restore();
    }

    public static InstallRegistry getInstance() {
        if (instance == null) {
            instance = new InstallRegistry();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean restore() {
        FileInputStream in = null;
        boolean loaded = false;
        this.clear();
        if (!this.file.exists()) {
            return loaded;
        }
        in = new FileInputStream(this.file);
        super.load(in);
        loaded = true;
        Object var5_3 = null;
        if (in == null) return loaded;
        try {
            ((InputStream)in).close();
            return loaded;
        }
        catch (IOException e2) {}
        return loaded;
        {
            catch (IOException e) {
                UpdateCore.log(e);
                Object var5_4 = null;
                if (in == null) return loaded;
                try {
                    ((InputStream)in).close();
                    return loaded;
                }
                catch (IOException e2) {}
                return loaded;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized boolean save() {
        boolean ret;
        block11: {
            FileOutputStream out = null;
            ret = false;
            out = new FileOutputStream(this.file);
            super.store(out, "This is a generated file; do not edit.");
            ret = true;
            Object var5_3 = null;
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
                break block11;
            }
            catch (IOException e2) {}
            break block11;
            {
                catch (IOException e) {
                    UpdateCore.log(e);
                    Object var5_4 = null;
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                        break block11;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return ret;
    }

    public static synchronized void registerFeature(IFeature feature) {
        String name = "feature_" + feature.getVersionedIdentifier();
        if (InstallRegistry.getInstance().get(name) == null) {
            InstallRegistry.getInstance().put(name, name);
            InstallRegistry.getInstance().save();
        }
    }

    public static synchronized void registerPlugin(IPluginEntry pluginEntry) {
        String name = "plugin_" + pluginEntry.getVersionedIdentifier();
        if (InstallRegistry.getInstance().get(name) == null) {
            InstallRegistry.getInstance().put(name, name);
            InstallRegistry.getInstance().save();
        }
        InstallRegistry.getInstance().justInstalledPlugins.put(name, name);
    }

    public static synchronized void unregisterFeature(IFeature feature) {
        String name = "feature_" + feature.getVersionedIdentifier();
        InstallRegistry.getInstance().remove(name);
    }

    public static synchronized void unregisterPlugin(IPluginEntry pluginEntry) {
        String name = "plugin_" + pluginEntry.getVersionedIdentifier();
        InstallRegistry.getInstance().remove(name);
        InstallRegistry.getInstance().justInstalledPlugins.remove(name);
    }

    public boolean isPluginJustInstalled(IPluginEntry pluginEntry) {
        String name = "plugin_" + pluginEntry.getVersionedIdentifier();
        return InstallRegistry.getInstance().justInstalledPlugins.get(name) != null;
    }

    public static void cleanup() {
        InstallRegistry.getInstance().justInstalledPlugins.clear();
    }
}

