/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ViewFilterAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewPart;

public class ShowSystemThreadsAction
extends ViewFilterAction
implements IDebugEventSetListener {
    protected String getPreferenceKey() {
        return IJDIPreferencesConstants.PREF_SHOW_SYSTEM_THREADS;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!this.getValue() && element instanceof IJavaThread) {
            try {
                IJavaThread thread = (IJavaThread)element;
                return !thread.isSystemThread() || thread.isSuspended();
            }
            catch (DebugException e) {
                // empty catch block
            }
        }
        return true;
    }

    public void init(IViewPart view) {
        super.init(view);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.getValue()) {
            return;
        }
        block4: for (int i = 0; i < events.length; ++i) {
            DebugEvent event = events[i];
            switch (event.getKind()) {
                case 2: {
                    if (event.getDetail() != 16) continue block4;
                    this.refresh(event.getSource(), true);
                    continue block4;
                }
                case 1: {
                    if (event.getDetail() != 32) continue block4;
                    this.refresh(event.getSource(), false);
                }
            }
        }
    }

    private void refresh(Object source, final boolean select) {
        if (source instanceof IJavaThread) {
            final IJavaThread thread = (IJavaThread)source;
            try {
                if (thread.isSystemThread()) {
                    Runnable r = new Runnable(){

                        public void run() {
                            ShowSystemThreadsAction.this.getStructuredViewer().refresh();
                            if (select) {
                                try {
                                    IStackFrame tos = thread.getTopStackFrame();
                                    ShowSystemThreadsAction.this.getStructuredViewer().setSelection((ISelection)new StructuredSelection((Object)tos));
                                }
                                catch (DebugException debugException) {
                                    // empty catch block
                                }
                            }
                        }
                    };
                    JDIDebugUIPlugin.getStandardDisplay().asyncExec(r);
                    return;
                }
            }
            catch (DebugException e) {
                // empty catch block
            }
        }
    }
}

