/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ControlEnableState {
    private List exceptions = null;
    private List states = new ArrayList();

    protected ControlEnableState(Control w) {
        this(w, null);
    }

    protected ControlEnableState(Control w, List exceptions) {
        this.exceptions = exceptions;
        this.readStateForAndDisable(w);
    }

    public static ControlEnableState disable(Control w) {
        return new ControlEnableState(w);
    }

    public static ControlEnableState disable(Control w, List exceptions) {
        return new ControlEnableState(w, exceptions);
    }

    private void readStateForAndDisable(Control control) {
        if (this.exceptions != null && this.exceptions.contains(control)) {
            return;
        }
        if (control instanceof Composite) {
            Composite c = (Composite)control;
            Control[] children = c.getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.readStateForAndDisable(children[i]);
            }
        }
        this.states.add(new ItemState(control, control.getEnabled()));
        control.setEnabled(false);
    }

    public void restore() {
        int size = this.states.size();
        for (int i = 0; i < size; ++i) {
            ((ItemState)this.states.get(i)).restore();
        }
    }

    private class ItemState {
        protected Control item;
        protected boolean state;

        public ItemState(Control item, boolean state) {
            this.item = item;
            this.state = state;
        }

        public void restore() {
            if (this.item == null || this.item.isDisposed()) {
                return;
            }
            this.item.setEnabled(this.state);
        }
    }
}

