/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBarManager
extends ContributionManager
implements IToolBarManager {
    private int itemStyle = 0;
    private ToolBar toolBar = null;
    private MenuManager contextMenuManager = null;

    public ToolBarManager() {
    }

    public ToolBarManager(int style) {
        this.itemStyle = style;
    }

    public ToolBarManager(ToolBar toolbar) {
        this();
        this.toolBar = toolbar;
    }

    public ToolBar createControl(Composite parent) {
        if (!this.toolBarExist() && parent != null) {
            this.toolBar = new ToolBar(parent, this.itemStyle);
            this.toolBar.setMenu(this.getContextMenuControl());
            this.update(false);
        }
        return this.toolBar;
    }

    public void dispose() {
        if (this.toolBarExist()) {
            this.toolBar.dispose();
        }
        this.toolBar = null;
        IContributionItem[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        if (this.getContextMenuManager() != null) {
            this.getContextMenuManager().dispose();
            this.setContextMenuManager(null);
        }
    }

    public ToolBar getControl() {
        return this.toolBar;
    }

    protected void relayout(ToolBar toolBar, int oldCount, int newCount) {
        if (oldCount == 0 != (newCount == 0)) {
            toolBar.getParent().layout();
        }
    }

    private boolean toolBarExist() {
        return this.toolBar != null && !this.toolBar.isDisposed();
    }

    public void update(boolean force) {
        if ((this.isDirty() || force) && this.toolBarExist()) {
            boolean useRedraw;
            int oldCount = this.toolBar.getItemCount();
            IContributionItem[] items = this.getItems();
            ArrayList<IContributionItem> clean = new ArrayList<IContributionItem>(items.length);
            IContributionItem separator = null;
            for (int i = 0; i < items.length; ++i) {
                IContributionItem ci = items[i];
                if (!ci.isVisible()) continue;
                if (ci.isSeparator()) {
                    separator = ci;
                    continue;
                }
                if (separator != null) {
                    if (clean.size() > 0) {
                        clean.add(separator);
                    }
                    separator = null;
                }
                clean.add(ci);
            }
            ToolItem[] mi = this.toolBar.getItems();
            ArrayList<ToolItem> toRemove = new ArrayList<ToolItem>(mi.length);
            for (int i = 0; i < mi.length; ++i) {
                Object data = mi[i].getData();
                if (data != null && clean.contains(data) && (!(data instanceof IContributionItem) || !((IContributionItem)data).isDynamic())) continue;
                toRemove.add(mi[i]);
            }
            boolean bl = useRedraw = clean.size() - (mi.length - toRemove.size()) >= 3;
            if (useRedraw) {
                this.toolBar.setRedraw(false);
            }
            int i = toRemove.size();
            while (--i >= 0) {
                ToolItem item = (ToolItem)toRemove.get(i);
                if (item.isDisposed()) continue;
                Control ctrl = item.getControl();
                if (ctrl != null) {
                    item.setControl(null);
                    ctrl.dispose();
                }
                item.dispose();
            }
            mi = this.toolBar.getItems();
            int srcIx = 0;
            int destIx = 0;
            Iterator e = clean.iterator();
            while (e.hasNext()) {
                IContributionItem src = (IContributionItem)e.next();
                IContributionItem dest = srcIx < mi.length ? (IContributionItem)mi[srcIx].getData() : null;
                if (dest != null && src.equals(dest)) {
                    ++srcIx;
                    ++destIx;
                    continue;
                }
                if (dest != null && dest.isSeparator() && src.isSeparator()) {
                    mi[srcIx].setData((Object)src);
                    ++srcIx;
                    ++destIx;
                    continue;
                }
                int start = this.toolBar.getItemCount();
                src.fill(this.toolBar, destIx);
                int newItems = this.toolBar.getItemCount() - start;
                for (int i2 = 0; i2 < newItems; ++i2) {
                    ToolItem item = this.toolBar.getItem(destIx++);
                    item.setData((Object)src);
                }
            }
            int i3 = mi.length;
            while (--i3 >= srcIx) {
                ToolItem item = mi[i3];
                if (item.isDisposed()) continue;
                Control ctrl = item.getControl();
                if (ctrl != null) {
                    item.setControl(null);
                    ctrl.dispose();
                }
                item.dispose();
            }
            this.setDirty(false);
            if (useRedraw) {
                this.toolBar.setRedraw(true);
            }
            int newCount = this.toolBar.getItemCount();
            this.relayout(this.toolBar, oldCount, newCount);
        }
    }

    private Menu getContextMenuControl() {
        if (this.contextMenuManager != null && this.toolBar != null) {
            Menu menuWidget = this.contextMenuManager.getMenu();
            if (menuWidget == null || menuWidget.isDisposed()) {
                menuWidget = this.contextMenuManager.createContextMenu((Control)this.toolBar);
            }
            return menuWidget;
        }
        return null;
    }

    public MenuManager getContextMenuManager() {
        return this.contextMenuManager;
    }

    public void setContextMenuManager(MenuManager contextMenuManager) {
        this.contextMenuManager = contextMenuManager;
        if (this.toolBar != null) {
            this.toolBar.setMenu(this.getContextMenuControl());
        }
    }
}

