/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.util.Iterator;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.actions.NewProjectAction;

public abstract class AbstractOpenWizardAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private Class[] fActivatedOnTypes;
    private boolean fAcceptEmptySelection;
    private boolean fNoChecking;

    public AbstractOpenWizardAction(String label, boolean acceptEmptySelection) {
        this(label, null, acceptEmptySelection);
    }

    public AbstractOpenWizardAction(String label, Class[] activatedOnTypes, boolean acceptEmptySelection) {
        super(label);
        this.fActivatedOnTypes = activatedOnTypes;
        this.fAcceptEmptySelection = acceptEmptySelection;
        this.fNoChecking = false;
    }

    protected AbstractOpenWizardAction() {
        this.fActivatedOnTypes = null;
        this.fAcceptEmptySelection = true;
        this.fNoChecking = true;
    }

    protected IWorkbench getWorkbench() {
        return JavaPlugin.getDefault().getWorkbench();
    }

    private boolean isOfAcceptedType(Object obj) {
        if (this.fActivatedOnTypes != null) {
            for (int i = 0; i < this.fActivatedOnTypes.length; ++i) {
                if (!this.fActivatedOnTypes[i].isInstance(obj)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isEnabled(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (this.isOfAcceptedType(obj) && this.shouldAcceptElement(obj)) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldAcceptElement(Object obj) {
        return true;
    }

    protected abstract Wizard createWizard() throws CoreException;

    protected IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = JavaPlugin.getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public void run() {
        if (!this.fNoChecking && !this.canActionBeAdded()) {
            return;
        }
        if (!this.checkWorkspaceNotEmpty()) {
            return;
        }
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        try {
            Wizard wizard = this.createWizard();
            if (wizard instanceof IWorkbenchWizard) {
                ((IWorkbenchWizard)wizard).init(this.getWorkbench(), this.getCurrentSelection());
            }
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            PixelConverter converter = new PixelConverter((Control)JavaPlugin.getActiveWorkbenchShell());
            dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            dialog.create();
            int res = dialog.open();
            this.notifyResult(res == 0);
        }
        catch (CoreException e) {
            String title = NewWizardMessages.getString("AbstractOpenWizardAction.createerror.title");
            String message = NewWizardMessages.getString("AbstractOpenWizardAction.createerror.message");
            ExceptionHandler.handle(e, shell, title, message);
        }
    }

    public boolean canActionBeAdded() {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null || selection.isEmpty()) {
            return this.fAcceptEmptySelection;
        }
        return this.isEnabled(selection);
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected boolean checkWorkspaceNotEmpty() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().getProjects().length == 0) {
            String message;
            String title;
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)(title = NewWizardMessages.getString("AbstractOpenWizardAction.noproject.title")), (String)(message = NewWizardMessages.getString("AbstractOpenWizardAction.noproject.message")))) {
                IWorkbenchWindow window = JavaPlugin.getActiveWorkbenchWindow();
                new NewProjectAction(window).run();
                return workspace.getRoot().getProjects().length != 0;
            }
            return false;
        }
        return true;
    }

    protected static boolean isOnBuildPath(Object obj) {
        if (obj instanceof IJavaElement) {
            IJavaElement elem = (IJavaElement)obj;
            return elem.getJavaProject().isOnClasspath(elem);
        }
        return false;
    }

    protected static boolean isInArchive(Object obj) {
        if (obj instanceof IJavaElement) {
            IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)obj);
            return root != null && root.isArchive();
        }
        return false;
    }
}

