/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.JavadocHelpContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;

public class JavaUIHelp {
    public static void setHelp(StructuredViewer viewer, String contextId) {
        JavaUIHelpListener listener = new JavaUIHelpListener(viewer, contextId);
        viewer.getControl().addHelpListener((HelpListener)listener);
    }

    public static void setHelp(JavaEditor editor, StyledText text, String contextId) {
        JavaUIHelpListener listener = new JavaUIHelpListener(editor, contextId);
        text.addHelpListener((HelpListener)listener);
    }

    private static class JavaUIHelpListener
    implements HelpListener {
        private StructuredViewer fViewer;
        private String fContextId;
        private JavaEditor fEditor;

        public JavaUIHelpListener(StructuredViewer viewer, String contextId) {
            this.fViewer = viewer;
            this.fContextId = contextId;
        }

        public JavaUIHelpListener(JavaEditor editor, String contextId) {
            this.fContextId = contextId;
            this.fEditor = editor;
        }

        public void helpRequested(HelpEvent e) {
            try {
                IJavaElement input;
                Object[] selected = null;
                if (this.fViewer != null) {
                    ISelection selection = this.fViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        selected = ((IStructuredSelection)selection).toArray();
                    }
                } else if (this.fEditor != null && ActionUtil.isOnBuildPath(input = SelectionConverter.getInput(this.fEditor))) {
                    selected = SelectionConverter.codeResolve(this.fEditor);
                }
                JavadocHelpContext.displayHelp(this.fContextId, selected);
            }
            catch (CoreException x) {
                JavaPlugin.log(x);
            }
        }
    }
}

