/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.changes.AddToClasspathChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreatePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectMainTypeNameProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectPackageDeclarationProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class ReorgCorrectionsSubProcessor {
    public static void getWrongTypeNameProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        String[] args = problem.getProblemArguments();
        if (args.length == 2) {
            ICompilationUnit cu = context.getCompilationUnit();
            boolean isLinked = cu.getResource().isLinked();
            proposals.add(new CorrectMainTypeNameProposal(cu, args[1], 5));
            String newCUName = args[1] + ".java";
            ICompilationUnit newCU = ((IPackageFragment)cu.getParent()).getCompilationUnit(newCUName);
            if (!(newCU.exists() || isLinked || JavaConventions.validateCompilationUnitName((String)newCUName).matches(4))) {
                RenameCompilationUnitChange change = new RenameCompilationUnitChange(cu, newCUName);
                String label = CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.renamecu.description", newCUName);
                proposals.add(new ChangeCorrectionProposal(label, change, 6, JavaPluginImages.get("org.eclipse.jdt.ui.correction_rename.gif")));
            }
        }
    }

    public static void getWrongPackageDeclNameProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        String[] args = problem.getProblemArguments();
        if (args.length == 1) {
            ICompilationUnit cu = context.getCompilationUnit();
            boolean isLinked = cu.getResource().isLinked();
            int relevance = cu.getPackageDeclarations().length == 0 ? 7 : 5;
            proposals.add(new CorrectPackageDeclarationProposal(cu, problem, relevance));
            IPackageDeclaration[] packDecls = cu.getPackageDeclarations();
            String newPackName = packDecls.length > 0 ? packDecls[0].getElementName() : "";
            IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)cu);
            IPackageFragment newPack = root.getPackageFragment(newPackName);
            ICompilationUnit newCU = newPack.getCompilationUnit(cu.getElementName());
            if (!newCU.exists() && !isLinked) {
                String label = newPack.isDefaultPackage() ? CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.movecu.default.description", cu.getElementName()) : CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.movecu.description", new Object[]{cu.getElementName(), newPack.getElementName()});
                CompositeChange composite = new CompositeChange(label);
                composite.add((Change)new CreatePackageChange(newPack));
                composite.add((Change)new MoveCompilationUnitChange(cu, newPack));
                proposals.add(new ChangeCorrectionProposal(label, (Change)composite, 6, JavaPluginImages.get("org.eclipse.jdt.ui.correction_move.gif")));
            }
        }
    }

    public static void removeImportStatementProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ASTNode node;
        final ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode != null && (node = ASTNodes.getParent(selectedNode, 26)) instanceof ImportDeclaration) {
            ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
            rewrite.remove(node, null);
            String label = CorrectionMessages.getString("ReorgCorrectionsSubProcessor.unusedimport.description");
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_delete_import.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
            proposals.add(proposal);
        }
        String name = CorrectionMessages.getString("ReorgCorrectionsSubProcessor.organizeimports.description");
        ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(name, null, 5, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif")){

            public void apply(IDocument document) {
                FileEditorInput input = new FileEditorInput((IFile)cu.getResource());
                IWorkbenchPage p = JavaPlugin.getActivePage();
                if (p == null) {
                    return;
                }
                IEditorPart part = p.findEditor((IEditorInput)input);
                if (part instanceof JavaEditor) {
                    OrganizeImportsAction action = new OrganizeImportsAction((JavaEditor)part);
                    action.run(cu);
                }
            }
        };
        proposals.add(proposal);
    }

    public static void importNotFoundProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        IJavaProject project = cu.getJavaProject();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode != null) {
            char[] packageName;
            ImportDeclaration importDeclaration = (ImportDeclaration)ASTNodes.getParent(selectedNode, 26);
            if (importDeclaration == null) {
                return;
            }
            String name = ASTNodes.asString((ASTNode)importDeclaration.getName());
            char[] typeName = null;
            if (importDeclaration.isOnDemand()) {
                packageName = name.toCharArray();
            } else {
                packageName = Signature.getQualifier((String)name).toCharArray();
                typeName = Signature.getSimpleName((String)name).toCharArray();
            }
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            ArrayList res = new ArrayList();
            TypeInfoRequestor requestor = new TypeInfoRequestor(res);
            new SearchEngine().searchAllTypeNames(packageName, typeName, 8, 0, scope, (ITypeNameRequestor)requestor, 3, null);
            if (res.isEmpty()) {
                return;
            }
            HashSet<Object> addedClaspaths = new HashSet<Object>();
            for (int i = 0; i < res.size(); ++i) {
                AddToClasspathChange change;
                String label;
                IPackageFragmentRoot root;
                IClasspathEntry entry;
                TypeInfo curr = (TypeInfo)res.get(i);
                IType type = curr.resolveType(scope);
                if (type == null || (entry = (root = (IPackageFragmentRoot)type.getAncestor(3)).getRawClasspathEntry()) == null) continue;
                IJavaProject other = root.getJavaProject();
                int entryKind = entry.getEntryKind();
                if ((entry.isExported() || entryKind == 3) && addedClaspaths.add(other)) {
                    Object[] args = new String[]{other.getElementName(), project.getElementName()};
                    String label2 = CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.addcp.project.description", args);
                    IClasspathEntry newEntry = JavaCore.newProjectEntry((IPath)other.getPath());
                    AddToClasspathChange change2 = new AddToClasspathChange(project, newEntry);
                    if (!change2.entryAlreadyExists()) {
                        ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(label2, change2, 8, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
                        proposals.add(proposal);
                    }
                }
                if (entryKind != 1 && entryKind != 4 && entryKind != 5 || !addedClaspaths.add(entry) || (label = ReorgCorrectionsSubProcessor.getAddClasspathLabel(entry, root, project)) == null || (change = new AddToClasspathChange(project, entry)).entryAlreadyExists()) continue;
                ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(label, change, 7, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
                proposals.add(proposal);
            }
        }
    }

    private static String getAddClasspathLabel(IClasspathEntry entry, IPackageFragmentRoot root, IJavaProject project) {
        switch (entry.getEntryKind()) {
            case 1: {
                if (root.isArchive()) {
                    Object[] args = new String[]{JavaElementLabels.getElementLabel((IJavaElement)root, 0), project.getElementName()};
                    return CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.addcp.archive.description", args);
                }
                Object[] args = new String[]{JavaElementLabels.getElementLabel((IJavaElement)root, 0), project.getElementName()};
                return CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.addcp.classfolder.description", args);
            }
            case 4: {
                Object[] args = new String[]{JavaElementLabels.getElementLabel((IJavaElement)root, 0), project.getElementName()};
                return CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.addcp.variable.description", args);
            }
            case 5: {
                try {
                    Object[] args = new String[]{JavaElementLabels.getContainerEntryLabel(entry.getPath(), root.getJavaProject()), project.getElementName()};
                    return CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.addcp.library.description", args);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

