/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Arrays;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;

public class ContributedProcessorDescriptor {
    private IConfigurationElement fConfigurationElement;
    private Object fProcessorInstance;
    private ICompilationUnit fLastCUnit;
    private Boolean fStatus;
    private boolean fLastResult;
    private static final String ID = "id";
    private static final String CLASS = "class";

    public ContributedProcessorDescriptor(IConfigurationElement element) {
        this.fConfigurationElement = element;
        this.fProcessorInstance = null;
        this.fLastCUnit = null;
        this.fStatus = null;
        if (this.fConfigurationElement.getChildren("enablement").length == 0) {
            this.fStatus = Boolean.TRUE;
        }
    }

    public IStatus checkSyntax() {
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length > 1) {
            String id = this.fConfigurationElement.getAttribute(ID);
            return new StatusInfo(4, "Only one <enablement> element allowed. Disabling " + id);
        }
        return new StatusInfo(0, "Syntactically correct quick assist/fix processor");
    }

    private boolean matches(ICompilationUnit cunit) {
        if (this.fStatus != null) {
            return this.fStatus;
        }
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length == 1) {
            if (cunit.equals(this.fLastCUnit)) {
                return this.fLastResult;
            }
            try {
                ExpressionConverter parser = ExpressionConverter.getDefault();
                Expression expression = parser.perform(children[0]);
                EvaluationContext evalContext = new EvaluationContext(null, (Object)cunit);
                evalContext.addVariable("compilationUnit", (Object)cunit);
                String[] natures = cunit.getJavaProject().getProject().getDescription().getNatureIds();
                evalContext.addVariable("projectNatures", Arrays.asList(natures));
                this.fLastResult = expression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
                this.fLastCUnit = cunit;
                return this.fLastResult;
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        this.fStatus = Boolean.FALSE;
        return false;
    }

    public Object getProcessor(ICompilationUnit cunit) throws CoreException {
        if (this.matches(cunit)) {
            if (this.fProcessorInstance == null) {
                this.fProcessorInstance = this.fConfigurationElement.createExecutableExtension(CLASS);
            }
            return this.fProcessorInstance;
        }
        return null;
    }
}

