/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.FieldReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.ui.search.JavaElementMatch;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;

public class NewSearchResultCollector
extends SearchRequestor {
    private JavaSearchResult fSearch;
    private boolean fIgnorePotentials;

    public NewSearchResultCollector(JavaSearchResult search, boolean ignorePotentials) {
        this.fSearch = search;
        this.fIgnorePotentials = ignorePotentials;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        IJavaElement enclosingElement = (IJavaElement)match.getElement();
        if (enclosingElement != null) {
            if (this.fIgnorePotentials && match.getAccuracy() == 1) {
                return;
            }
            boolean isWriteAccess = false;
            boolean isReadAccess = false;
            if (match instanceof FieldReferenceMatch) {
                FieldReferenceMatch fieldRef = (FieldReferenceMatch)match;
                isWriteAccess = fieldRef.isWriteAccess();
                isReadAccess = fieldRef.isReadAccess();
            }
            this.fSearch.addMatch(new JavaElementMatch(enclosingElement, match.getOffset(), match.getLength(), match.getAccuracy(), isReadAccess, isWriteAccess, match.isInsideDocComment()));
        }
    }

    public void beginReporting() {
    }

    public void endReporting() {
    }

    public void enterParticipant(SearchParticipant participant) {
    }

    public void exitParticipant(SearchParticipant participant) {
    }
}

