/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Assert;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.ui.refactoring.ChangeExceptionHandler;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class RefactoringExecutionHelper {
    private final Refactoring fRefactoring;
    private final Shell fParent;
    private final IRunnableContext fExecContext;
    private final int fStopSeverity;
    private final boolean fNeedsSavedEditors;

    public RefactoringExecutionHelper(Refactoring refactoring, int stopSevertity, boolean needsSavedEditors, Shell parent, IRunnableContext context) {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)context);
        this.fRefactoring = refactoring;
        this.fStopSeverity = stopSevertity;
        this.fParent = parent;
        this.fExecContext = context;
        this.fNeedsSavedEditors = needsSavedEditors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform() throws InterruptedException, InvocationTargetException {
        Assert.isTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        final IJobManager manager = Platform.getJobManager();
        try {
            try {
                Runnable r = new Runnable(){

                    public void run() {
                        manager.suspend((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), null);
                    }
                };
                BusyIndicator.showWhile((Display)this.fParent.getDisplay(), (Runnable)r);
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            RefactoringSaveHelper saveHelper = new RefactoringSaveHelper();
            if (this.fNeedsSavedEditors && !saveHelper.saveEditors(this.fParent)) {
                throw new InterruptedException();
            }
            Operation op = new Operation();
            this.fRefactoring.setValidationContext((Object)this.fParent);
            try {
                this.fExecContext.run(false, false, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op));
                RefactoringStatus validationStatus = op.fPerformChangeOperation.getValidationStatus();
                if (validationStatus != null && validationStatus.hasFatalError()) {
                    MessageDialog.openError((Shell)this.fParent, (String)this.fRefactoring.getName(), (String)RefactoringMessages.getFormattedString("RefactoringExecutionHelper.cannot_execute", validationStatus.getMessageMatchingSeverity(4)));
                    boolean bl = false;
                    return bl;
                }
            }
            catch (InvocationTargetException e) {
                PerformChangeOperation pco = op.fPerformChangeOperation;
                if (pco == null) throw e;
                if (!pco.changeExecutionFailed()) throw e;
                ChangeExceptionHandler handler = new ChangeExceptionHandler(this.fParent, this.fRefactoring);
                Throwable inner = e.getTargetException();
                if (inner instanceof RuntimeException) {
                    handler.handle(pco.getChange(), (RuntimeException)inner);
                } else {
                    if (!(inner instanceof CoreException)) throw e;
                    handler.handle(pco.getChange(), (CoreException)inner);
                }
            }
            finally {
                saveHelper.triggerBuild();
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            manager.resume((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            this.fRefactoring.setValidationContext(null);
            throw throwable;
        }
        manager.resume((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this.fRefactoring.setValidationContext(null);
        return true;
    }

    private class Operation
    implements IWorkspaceRunnable {
        public Change fChange;
        public PerformChangeOperation fPerformChangeOperation;

        private Operation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor pm) throws CoreException {
            try {
                Dialog dialog;
                pm.beginTask("", 11);
                pm.subTask("");
                RefactoringStatus status = RefactoringExecutionHelper.this.fRefactoring.checkAllConditions((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
                if (status.getSeverity() >= RefactoringExecutionHelper.this.fStopSeverity && (dialog = RefactoringUI.createRefactoringStatusDialog((RefactoringStatus)status, (Shell)RefactoringExecutionHelper.this.fParent, (String)RefactoringExecutionHelper.this.fRefactoring.getName(), (boolean)false)).open() == 1) {
                    throw new OperationCanceledException();
                }
                this.fChange = RefactoringExecutionHelper.this.fRefactoring.createChange((IProgressMonitor)new SubProgressMonitor(pm, 2, 4));
                this.fChange.initializeValidationData((IProgressMonitor)new SubProgressMonitor(pm, 1, 4));
                this.fPerformChangeOperation = RefactoringUI.createUIAwareChangeOperation((Change)this.fChange);
                this.fPerformChangeOperation.setUndoManager(RefactoringCore.getUndoManager(), RefactoringExecutionHelper.this.fRefactoring.getName());
                this.fPerformChangeOperation.run((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
            }
            finally {
                pm.done();
            }
        }
    }
}

