/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeTypeRefactoring;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class ChangeTypeContentProvider
implements ITreeContentProvider {
    private ChangeTypeRefactoring fGeneralizeType;

    ChangeTypeContentProvider(ChangeTypeRefactoring gt) {
        this.fGeneralizeType = gt;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof RootType) {
            return ((RootType)element).getChildren();
        }
        Object[] superTypes = this.fGeneralizeType.getTypeHierarchy().getSupertypes((IType)element);
        Arrays.sort(superTypes, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((IType)o1).getFullyQualifiedName();
                String name2 = ((IType)o2).getFullyQualifiedName();
                return name1.compareTo(name2);
            }
        });
        return superTypes;
    }

    public Object[] getElements(Object element) {
        Assert.isTrue((boolean)(element instanceof RootType));
        return ((RootType)element).getChildren();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object getParent(Object element) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    static class RootType {
        private IType fRoot;

        RootType(IType root) {
            this.fRoot = root;
        }

        public IType[] getChildren() {
            return new IType[]{this.fRoot};
        }
    }
}

