/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.preferences.EditTemplateDialog;
import org.eclipse.jdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.TemplateEditorSourceViewerConfiguration;
import org.eclipse.jdt.internal.ui.text.template.preferences.TemplateVariableProcessor;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;

public class JavaTemplatePreferencePage
extends TemplatePreferencePage
implements IWorkbenchPreferencePage {
    private TemplateVariableProcessor fTemplateProcessor;

    public JavaTemplatePreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setTemplateStore(JavaPlugin.getDefault().getTemplateStore());
        this.setContextTypeRegistry(JavaPlugin.getDefault().getTemplateContextRegistry());
        this.fTemplateProcessor = new TemplateVariableProcessor();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.java_editor_preference_page_context");
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        JavaPlugin.getDefault().savePluginPreferences();
        return ok;
    }

    protected String getFormatterPreferenceKey() {
        return "org.eclipse.jdt.ui.template.format";
    }

    protected Dialog createTemplateEditDialog(Template template, boolean edit, boolean isNameModifiable) {
        return new EditTemplateDialog(this.getShell(), template, edit, isNameModifiable, this.getContextTypeRegistry());
    }

    protected SourceViewer createViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PreferencesMessages.getString("CodeTemplateBlock.preview"));
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        Document document = new Document();
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        tools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        JavaSourceViewer viewer = new JavaSourceViewer(parent, null, null, false, 2816, store);
        TemplateEditorSourceViewerConfiguration configuration = new TemplateEditorSourceViewerConfiguration(tools.getColorManager(), store, null, this.fTemplateProcessor);
        viewer.configure(configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        viewer.getTextWidget().setFont(font);
        new JavaSourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        Control control = viewer.getControl();
        data = new GridData(1296);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        SourceViewer viewer = this.getViewer();
        if (selection.size() == 1 && selection.getFirstElement() instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
            Template template = data.getTemplate();
            String contextId = template.getContextTypeId();
            TemplateContextType type = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType(contextId);
            this.fTemplateProcessor.setContextType(type);
            IDocument doc = viewer.getDocument();
            String start = null;
            start = "javadoc".equals(contextId) ? "/**" + doc.getLegalLineDelimiters()[0] : "";
            doc.set(start + template.getPattern());
            int startLen = start.length();
            viewer.setDocument(doc, startLen, doc.getLength() - startLen);
        } else {
            viewer.getDocument().set("");
        }
    }
}

