/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlighting;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingManager;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingPresenter;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticToken;
import org.eclipse.jdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class SemanticHighlightingReconciler
implements IJavaReconcilingListener,
ITextInputListener {
    private PositionCollector fCollector = new PositionCollector();
    private JavaEditor fEditor;
    private ISourceViewer fSourceViewer;
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlighting[] fSemanticHighlightings;
    private SemanticHighlightingManager.Highlighting[] fHighlightings;
    private List fAddedPositions = new ArrayList();
    private List fRemovedPositions = new ArrayList();
    private int fNOfRemovedPositions;
    private Job fJob;
    private boolean fCancelJobs;
    private Object fJobLock = new Object();
    private SemanticHighlightingPresenter fJobPresenter;
    private SemanticHighlighting[] fJobSemanticHighlightings;
    private SemanticHighlightingManager.Highlighting[] fJobHighlightings;

    public void aboutToBeReconciled() {
    }

    public void reconciled(CompilationUnit ast, boolean forced, IProgressMonitor progressMonitor) {
        this.fJobPresenter = this.fPresenter;
        this.fJobSemanticHighlightings = this.fSemanticHighlightings;
        this.fJobHighlightings = this.fHighlightings;
        if (this.fJobPresenter == null || this.fJobSemanticHighlightings == null || this.fJobHighlightings == null) {
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            return;
        }
        this.fJobPresenter.setCanceled(progressMonitor.isCanceled());
        if (ast == null || this.fJobPresenter.isCanceled()) {
            return;
        }
        ASTNode[] subtrees = this.getAffectedSubtrees((ASTNode)ast);
        if (subtrees.length == 0) {
            return;
        }
        this.startReconcilingPositions();
        if (!this.fJobPresenter.isCanceled()) {
            this.reconcilePositions(subtrees);
        }
        if (!this.fJobPresenter.isCanceled()) {
            // empty if block
        }
        TextPresentation textPresentation = this.fJobPresenter.createPresentation(this.fAddedPositions, this.fRemovedPositions);
        if (!this.fJobPresenter.isCanceled()) {
            this.updatePresentation(textPresentation, this.fAddedPositions, this.fRemovedPositions);
        }
        this.stopReconcilingPositions();
        this.fJobPresenter = null;
        this.fJobSemanticHighlightings = null;
        this.fJobHighlightings = null;
    }

    private ASTNode[] getAffectedSubtrees(ASTNode node) {
        return new ASTNode[]{node};
    }

    private void startReconcilingPositions() {
        this.fJobPresenter.addAllPositions(this.fRemovedPositions);
        this.fNOfRemovedPositions = this.fRemovedPositions.size();
    }

    private void reconcilePositions(ASTNode[] subtrees) {
        int n = subtrees.length;
        for (int i = 0; i < n; ++i) {
            subtrees[i].accept((ASTVisitor)this.fCollector);
        }
        List oldPositions = this.fRemovedPositions;
        ArrayList newPositions = new ArrayList(this.fNOfRemovedPositions);
        int n2 = oldPositions.size();
        for (int i = 0; i < n2; ++i) {
            Object current = oldPositions.get(i);
            if (current == null) continue;
            newPositions.add(current);
        }
        this.fRemovedPositions = newPositions;
    }

    private void updatePresentation(TextPresentation textPresentation, List addedPositions, List removedPositions) {
        Runnable runnable = this.fJobPresenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        JavaEditor editor = this.fEditor;
        if (editor == null) {
            return;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    private void stopReconcilingPositions() {
        this.fRemovedPositions.clear();
        this.fNOfRemovedPositions = 0;
        this.fAddedPositions.clear();
    }

    public void install(JavaEditor editor, ISourceViewer sourceViewer, SemanticHighlightingPresenter presenter, SemanticHighlighting[] semanticHighlightings, SemanticHighlightingManager.Highlighting[] highlightings) {
        this.fPresenter = presenter;
        this.fSemanticHighlightings = semanticHighlightings;
        this.fHighlightings = highlightings;
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        if (this.fEditor instanceof CompilationUnitEditor) {
            ((CompilationUnitEditor)this.fEditor).addReconcileListener(this);
        } else {
            this.fSourceViewer.addTextInputListener((ITextInputListener)this);
            this.scheduleJob();
        }
    }

    public void uninstall() {
        if (this.fPresenter != null) {
            this.fPresenter.setCanceled(true);
        }
        if (this.fEditor != null) {
            if (this.fEditor instanceof CompilationUnitEditor) {
                ((CompilationUnitEditor)this.fEditor).removeReconcileListener(this);
            } else {
                this.fSourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            this.fEditor = null;
        }
        this.fSourceViewer = null;
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
        this.fPresenter = null;
    }

    private void scheduleJob() {
        final IJavaElement element = this.fEditor.getInputJavaElement();
        if (element != null) {
            Job job = new Job(JavaEditorMessages.getString("SemanticHighlighting.job")){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    Object object = SemanticHighlightingReconciler.this.fJobLock;
                    synchronized (object) {
                        if (SemanticHighlightingReconciler.this.fJob != null) {
                            try {
                                SemanticHighlightingReconciler.this.fJobLock.wait();
                            }
                            catch (InterruptedException e) {
                                JavaPlugin.log(e);
                            }
                        }
                        if (SemanticHighlightingReconciler.this.fCancelJobs || SemanticHighlightingReconciler.this.fJob != null) {
                            return Status.CANCEL_STATUS;
                        }
                        SemanticHighlightingReconciler.this.fJob = this;
                    }
                    CompilationUnit ast = JavaPlugin.getDefault().getASTProvider().getAST(element, true, monitor);
                    SemanticHighlightingReconciler.this.reconciled(ast, false, monitor);
                    Object object2 = SemanticHighlightingReconciler.this.fJobLock;
                    synchronized (object2) {
                        SemanticHighlightingReconciler.this.fJob = null;
                        SemanticHighlightingReconciler.this.fJobLock.notifyAll();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setPriority(50);
            job.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        Object object = this.fJobLock;
        synchronized (object) {
            this.fCancelJobs = true;
            if (this.fJob != null) {
                this.fJob.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        Object object = this.fJobLock;
        synchronized (object) {
            this.fCancelJobs = false;
        }
        if (newInput != null) {
            this.scheduleJob();
        }
    }

    private class PositionCollector
    extends GenericVisitor {
        private SemanticToken fToken = new SemanticToken();

        private PositionCollector() {
        }

        protected boolean visitNode(ASTNode node) {
            if ((node.getFlags() & 1) == 1) {
                this.retainPositions(node.getStartPosition(), node.getLength());
                return false;
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            this.fToken.update(node);
            int n = SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length;
            for (int i = 0; i < n; ++i) {
                SemanticHighlighting semanticHighlighting = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[i];
                if (!SemanticHighlightingReconciler.this.fJobHighlightings[i].isEnabled() || !semanticHighlighting.consumes(this.fToken)) continue;
                this.addPosition(node.getStartPosition(), node.getLength(), SemanticHighlightingReconciler.this.fJobHighlightings[i]);
                break;
            }
            this.fToken.clear();
            return false;
        }

        private void addPosition(int offset, int length, SemanticHighlightingManager.Highlighting highlighting) {
            boolean isExisting = false;
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            for (int i = 0; i < n; ++i) {
                SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)SemanticHighlightingReconciler.this.fRemovedPositions.get(i));
                if (position == null || !position.isEqual(offset, length, highlighting)) continue;
                isExisting = true;
                SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                SemanticHighlightingReconciler.this.fNOfRemovedPositions--;
                break;
            }
            if (!isExisting) {
                SemanticHighlightingManager.HighlightedPosition position = SemanticHighlightingReconciler.this.fJobPresenter.createHighlightedPosition(offset, length, highlighting);
                SemanticHighlightingReconciler.this.fAddedPositions.add(position);
            }
        }

        private void retainPositions(int offset, int length) {
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            for (int i = 0; i < n; ++i) {
                SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)SemanticHighlightingReconciler.this.fRemovedPositions.get(i));
                if (position == null || !position.isContained(offset, length)) continue;
                SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                SemanticHighlightingReconciler.this.fNOfRemovedPositions--;
            }
        }
    }
}

