/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyContentProvider;
import org.eclipse.jdt.internal.ui.callhierarchy.TreeTermination;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

class DeferredMethodWrapper
implements IDeferredWorkbenchAdapter {
    private final CallHierarchyContentProvider fProvider;
    private MethodWrapper fMethodWrapper;
    static /* synthetic */ Class class$org$eclipse$ui$progress$IDeferredWorkbenchAdapter;

    DeferredMethodWrapper(CallHierarchyContentProvider provider, MethodWrapper methodWrapper) {
        this.fMethodWrapper = methodWrapper;
        this.fProvider = provider;
    }

    private Object getCalls(IProgressMonitor monitor) {
        return this.fMethodWrapper.getCalls(monitor);
    }

    private MethodWrapper getMethodWrapper() {
        return this.fMethodWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        try {
            this.fProvider.startFetching();
            DeferredMethodWrapper methodWrapper = (DeferredMethodWrapper)object;
            collector.add((Object[])methodWrapper.getCalls(monitor), monitor);
            collector.done();
        }
        catch (OperationCanceledException e) {
            collector.add(new Object[]{TreeTermination.SEARCH_CANCELED}, monitor);
        }
        catch (Exception e) {
            JavaPlugin.log(e);
        }
        finally {
            this.fProvider.doneFetching();
        }
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object o) {
        return new BatchSimilarSchedulingRule("org.eclipse.jdt.ui.callhierarchy.methodwrapper");
    }

    public Object[] getChildren(Object o) {
        return this.fProvider.fetchChildren(((DeferredMethodWrapper)o).getMethodWrapper());
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.fMethodWrapper.getMember().getElementName();
    }

    public Object getParent(Object o) {
        return this.fMethodWrapper.getParent();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == (class$org$eclipse$ui$progress$IDeferredWorkbenchAdapter == null ? (class$org$eclipse$ui$progress$IDeferredWorkbenchAdapter = DeferredMethodWrapper.class$("org.eclipse.ui.progress.IDeferredWorkbenchAdapter")) : class$org$eclipse$ui$progress$IDeferredWorkbenchAdapter)) {
            return this;
        }
        return null;
    }

    public boolean equals(Object obj) {
        return this.fMethodWrapper.equals(obj);
    }

    public int hashCode() {
        return this.fMethodWrapper.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BatchSimilarSchedulingRule
    implements ISchedulingRule {
        public String id;

        public BatchSimilarSchedulingRule(String id) {
            this.id = id;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof BatchSimilarSchedulingRule) {
                return ((BatchSimilarSchedulingRule)rule).id.equals(this.id);
            }
            return false;
        }

        public boolean contains(ISchedulingRule rule) {
            return false;
        }
    }
}

