/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.NewWizardMenu;

public class NewWizardsActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;

    public NewWizardsActionGroup(IWorkbenchSite site) {
        this.fSite = site;
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection sel;
        super.fillContextMenu(menu);
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() <= 1 && this.isNewTarget(sel.getFirstElement())) {
            MenuManager newMenu = new MenuManager(ActionMessages.getString("NewWizardsActionGroup.new"));
            menu.appendToGroup("group.new", (IContributionItem)newMenu);
            new NewWizardMenu((IMenuManager)newMenu, this.fSite.getWorkbenchWindow(), false);
        }
    }

    private boolean isNewTarget(Object element) {
        if (element == null) {
            return true;
        }
        if (element instanceof IResource) {
            return true;
        }
        if (element instanceof IJavaElement) {
            int type = ((IJavaElement)element).getElementType();
            return type == 2 || type == 3 || type == 4 || type == 5 || type == 7;
        }
        return false;
    }
}

