/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public abstract class JavaRenameProcessor
extends RenameProcessor
implements INameUpdating {
    private String fNewElementName;

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RenameArguments arguments = new RenameArguments(this.getNewElementName(), this.getUpdateReferences());
        String[] natures = this.getAffectedProjectNatures();
        ArrayList result = new ArrayList();
        this.loadElementParticipants(status, result, arguments, natures, sharedParticipants);
        this.loadDerivedParticipants(status, result, natures, sharedParticipants);
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    protected void loadElementParticipants(RefactoringStatus status, List result, RenameArguments arguments, String[] natures, SharableParticipants shared) throws CoreException {
        Object[] elements = this.getElements();
        for (int i = 0; i < elements.length; ++i) {
            result.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)elements[i], (RenameArguments)arguments, (String[])natures, (SharableParticipants)shared)));
        }
    }

    protected abstract void loadDerivedParticipants(RefactoringStatus var1, List var2, String[] var3, SharableParticipants var4) throws CoreException;

    protected void loadDerivedParticipants(RefactoringStatus status, List result, Object[] derivedElements, RenameArguments arguments, ResourceModifications resourceModifications, String[] natures, SharableParticipants shared) throws CoreException {
        if (derivedElements != null) {
            for (int i = 0; i < derivedElements.length; ++i) {
                RenameParticipant[] participants = ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)derivedElements[i], (RenameArguments)arguments, (String[])natures, (SharableParticipants)shared);
                result.addAll(Arrays.asList(participants));
            }
        }
        if (resourceModifications != null) {
            result.addAll(Arrays.asList(resourceModifications.getParticipants(status, (RefactoringProcessor)this, natures, shared)));
        }
    }

    public void setNewElementName(String newName) {
        Assert.isNotNull(newName);
        this.fNewElementName = newName;
    }

    public String getNewElementName() {
        return this.fNewElementName;
    }

    protected abstract String[] getAffectedProjectNatures() throws CoreException;

    public abstract boolean getUpdateReferences();
}

