/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code.flow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;

public abstract class FlowInfo {
    protected static final int NOT_POSSIBLE = 0;
    protected static final int UNDEFINED = 1;
    protected static final int NO_RETURN = 2;
    protected static final int PARTIAL_RETURN = 3;
    protected static final int VOID_RETURN = 4;
    protected static final int VALUE_RETURN = 5;
    protected static final int THROW = 6;
    public static final int UNUSED = 1;
    public static final int READ = 2;
    public static final int READ_POTENTIAL = 4;
    public static final int WRITE = 8;
    public static final int WRITE_POTENTIAL = 16;
    public static final int UNKNOWN = 32;
    private static final int[][] ACCESS_MODE_CONDITIONAL_TABLE = new int[][]{{1, 4, 4, 16, 16, 32}, {4, 2, 4, 32, 32, 32}, {4, 4, 4, 32, 32, 32}, {16, 32, 32, 8, 16, 32}, {16, 32, 32, 16, 16, 32}, {32, 32, 32, 32, 32, 32}};
    private static final int[] ACCESS_MODE_OPEN_BRANCH_TABLE = new int[]{1, 4, 4, 16, 16, 32};
    private static final int[][] RETURN_KIND_CONDITIONAL_TABLE = new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 1, 2, 3, 4, 5, 6}, {0, 2, 2, 3, 3, 3, 2}, {0, 3, 3, 3, 3, 3, 3}, {0, 4, 3, 3, 4, 0, 4}, {0, 5, 3, 3, 0, 5, 5}, {0, 6, 2, 3, 4, 5, 6}};
    private static final int[][] RETURN_KIND_SEQUENTIAL_TABLE = new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 1, 2, 3, 4, 5, 6}, {0, 2, 2, 3, 4, 5, 6}, {0, 3, 3, 3, 4, 5, 6}, {0, 4, 4, 3, 4, 0, 0}, {0, 5, 5, 3, 0, 5, 0}, {0, 6, 6, 3, 4, 5, 6}};
    protected static final String UNLABELED = "@unlabeled";
    protected static final IVariableBinding[] EMPTY_ARRAY = new IVariableBinding[0];
    protected int fReturnKind;
    protected int[] fAccessModes;
    protected HashSet fBranches;
    protected HashSet fExceptions;

    protected FlowInfo() {
        this(1);
    }

    protected FlowInfo(int returnKind) {
        this.fReturnKind = returnKind;
    }

    protected void assignExecutionFlow(FlowInfo right) {
        this.fReturnKind = right.fReturnKind;
        this.fBranches = right.fBranches;
        this.fExceptions = right.fExceptions;
    }

    protected void assignAccessMode(FlowInfo right) {
        this.fAccessModes = right.fAccessModes;
    }

    protected void assign(FlowInfo right) {
        this.assignExecutionFlow(right);
        this.assignAccessMode(right);
    }

    protected void mergeConditional(FlowInfo info, FlowContext context) {
        this.mergeAccessModeConditional(info, context);
        this.mergeExecutionFlowConditional(info, context);
    }

    protected void mergeSequential(FlowInfo info, FlowContext context) {
        this.mergeAccessModeSequential(info, context);
        this.mergeExecutionFlowSequential(info, context);
    }

    public void setNoReturn() {
        this.fReturnKind = 2;
    }

    public boolean isUndefined() {
        return this.fReturnKind == 1;
    }

    public boolean isNoReturn() {
        return this.fReturnKind == 2;
    }

    public boolean isPartialReturn() {
        return this.fReturnKind == 3;
    }

    public boolean isVoidReturn() {
        return this.fReturnKind == 4;
    }

    public boolean isValueReturn() {
        return this.fReturnKind == 5;
    }

    public boolean isThrow() {
        return this.fReturnKind == 6;
    }

    public boolean isReturn() {
        return this.fReturnKind == 4 || this.fReturnKind == 5;
    }

    public boolean branches() {
        return this.fBranches != null && !this.fBranches.isEmpty();
    }

    protected HashSet getBranches() {
        return this.fBranches;
    }

    protected void removeLabel(SimpleName label) {
        if (this.fBranches != null) {
            this.fBranches.remove(FlowInfo.makeString(label));
            if (this.fBranches.isEmpty()) {
                this.fBranches = null;
            }
        }
    }

    protected static String makeString(SimpleName label) {
        if (label == null) {
            return UNLABELED;
        }
        return label.getIdentifier();
    }

    public ITypeBinding[] getExceptions() {
        if (this.fExceptions == null) {
            return new ITypeBinding[0];
        }
        return this.fExceptions.toArray(new ITypeBinding[this.fExceptions.size()]);
    }

    protected boolean hasUncaughtException() {
        return this.fExceptions != null && !this.fExceptions.isEmpty();
    }

    protected void addException(ITypeBinding type) {
        if (this.fExceptions == null) {
            this.fExceptions = new HashSet(2);
        }
        this.fExceptions.add(type);
    }

    protected void removeExceptions(TryStatement node) {
        if (this.fExceptions == null) {
            return;
        }
        List catchClauses = node.catchClauses();
        if (catchClauses.isEmpty()) {
            return;
        }
        ITypeBinding[] exceptions = this.fExceptions.toArray(new ITypeBinding[this.fExceptions.size()]);
        for (int i = 0; i < exceptions.length; ++i) {
            this.handleException(catchClauses, exceptions[i]);
        }
        if (this.fExceptions.isEmpty()) {
            this.fExceptions = null;
        }
    }

    private void handleException(List catchClauses, ITypeBinding type) {
        Iterator iter = catchClauses.iterator();
        while (iter.hasNext()) {
            IVariableBinding binding = ((CatchClause)iter.next()).getException().resolveBinding();
            if (binding == null) continue;
            for (ITypeBinding catchedType = binding.getType(); catchedType != null; catchedType = catchedType.getSuperclass()) {
                if (catchedType != type) continue;
                this.fExceptions.remove(type);
                return;
            }
        }
    }

    private void mergeExecutionFlowSequential(FlowInfo otherInfo, FlowContext context) {
        int other = otherInfo.fReturnKind;
        if (this.branches() && other == 5) {
            other = 3;
        }
        this.fReturnKind = RETURN_KIND_SEQUENTIAL_TABLE[this.fReturnKind][other];
        this.mergeBranches(otherInfo, context);
        this.mergeExceptions(otherInfo, context);
    }

    private void mergeExecutionFlowConditional(FlowInfo otherInfo, FlowContext context) {
        this.fReturnKind = RETURN_KIND_CONDITIONAL_TABLE[this.fReturnKind][otherInfo.fReturnKind];
        this.mergeBranches(otherInfo, context);
        this.mergeExceptions(otherInfo, context);
    }

    private void mergeBranches(FlowInfo otherInfo, FlowContext context) {
        this.fBranches = FlowInfo.mergeHashSets(this.fBranches, otherInfo.fBranches);
    }

    private void mergeExceptions(FlowInfo otherInfo, FlowContext context) {
        this.fExceptions = FlowInfo.mergeHashSets(this.fExceptions, otherInfo.fExceptions);
    }

    private static HashSet mergeHashSets(HashSet thisSet, HashSet otherSet) {
        if (otherSet != null) {
            if (thisSet == null) {
                thisSet = otherSet;
            } else {
                Iterator iter = otherSet.iterator();
                while (iter.hasNext()) {
                    thisSet.add(iter.next());
                }
            }
        }
        return thisSet;
    }

    public IVariableBinding[] get(FlowContext context, int mode) {
        ArrayList<IVariableBinding> result = new ArrayList<IVariableBinding>();
        int[] locals = this.getAccessModes();
        if (locals == null) {
            return EMPTY_ARRAY;
        }
        for (int i = 0; i < locals.length; ++i) {
            int accessMode = locals[i];
            if ((accessMode & mode) == 0) continue;
            result.add(context.getLocalFromIndex(i));
        }
        return result.toArray(new IVariableBinding[result.size()]);
    }

    public boolean hasAccessMode(FlowContext context, IVariableBinding local, int mode) {
        boolean unusedMode;
        boolean bl = unusedMode = (mode & 1) != 0;
        if (this.fAccessModes == null && unusedMode) {
            return true;
        }
        int index = context.getIndexFromLocal(local);
        if (index == -1) {
            return unusedMode;
        }
        return (this.fAccessModes[index] & mode) != 0;
    }

    public int getAccessMode(FlowContext context, IVariableBinding local) {
        if (this.fAccessModes == null) {
            return 1;
        }
        int index = context.getIndexFromLocal(local);
        if (index == -1) {
            return 1;
        }
        return this.fAccessModes[index];
    }

    protected int[] getAccessModes() {
        return this.fAccessModes;
    }

    protected void clearAccessMode(IVariableBinding binding, FlowContext context) {
        if (this.fAccessModes == null) {
            return;
        }
        this.fAccessModes[binding.getVariableId() - context.getStartingIndex()] = 1;
    }

    protected void mergeAccessModeSequential(FlowInfo otherInfo, FlowContext context) {
        if (!context.considerAccessMode()) {
            return;
        }
        int[] others = otherInfo.fAccessModes;
        if (others == null) {
            return;
        }
        if (this.branches() || this.hasUncaughtException()) {
            for (int i = 0; i < others.length; ++i) {
                others[i] = ACCESS_MODE_OPEN_BRANCH_TABLE[FlowInfo.getIndex(others[i])];
            }
        }
        if (this.fAccessModes == null) {
            this.fAccessModes = others;
            return;
        }
        if (context.computeArguments()) {
            this.handleComputeArguments(others);
        } else if (context.computeReturnValues()) {
            this.handleComputeReturnValues(others);
        } else if (context.computeMerge()) {
            this.handleMergeValues(others);
        }
    }

    private void handleComputeReturnValues(int[] others) {
        for (int i = 0; i < this.fAccessModes.length; ++i) {
            int accessmode = this.fAccessModes[i];
            int othermode = others[i];
            if (accessmode == 8) continue;
            if (accessmode == 16) {
                if (othermode != 8) continue;
                this.fAccessModes[i] = 8;
                continue;
            }
            if (others[i] == 1) continue;
            this.fAccessModes[i] = othermode;
        }
    }

    private void handleComputeArguments(int[] others) {
        for (int i = 0; i < this.fAccessModes.length; ++i) {
            int accessMode = this.fAccessModes[i];
            int otherMode = others[i];
            if (accessMode == 1) {
                this.fAccessModes[i] = otherMode;
                continue;
            }
            if (accessMode == 16 && otherMode == 2) {
                this.fAccessModes[i] = 2;
                continue;
            }
            if (accessMode != 16 || otherMode != 8) continue;
            this.fAccessModes[i] = 8;
        }
    }

    private void handleMergeValues(int[] others) {
        for (int i = 0; i < this.fAccessModes.length; ++i) {
            this.fAccessModes[i] = ACCESS_MODE_CONDITIONAL_TABLE[FlowInfo.getIndex(this.fAccessModes[i])][FlowInfo.getIndex(others[i])];
        }
    }

    protected void createAccessModeArray(FlowContext context) {
        this.fAccessModes = new int[context.getArrayLength()];
        for (int i = 0; i < this.fAccessModes.length; ++i) {
            this.fAccessModes[i] = 1;
        }
    }

    protected void mergeAccessModeConditional(FlowInfo otherInfo, FlowContext context) {
        if (!context.considerAccessMode()) {
            return;
        }
        int[] others = otherInfo.fAccessModes;
        if (this.fAccessModes == null) {
            if (others != null) {
                this.fAccessModes = others;
            } else {
                this.createAccessModeArray(context);
            }
            return;
        }
        if (others == null) {
            for (int i = 0; i < this.fAccessModes.length; ++i) {
                int unused_index = FlowInfo.getIndex(1);
                this.fAccessModes[i] = ACCESS_MODE_CONDITIONAL_TABLE[FlowInfo.getIndex(this.fAccessModes[i])][unused_index];
            }
        } else {
            for (int i = 0; i < this.fAccessModes.length; ++i) {
                this.fAccessModes[i] = ACCESS_MODE_CONDITIONAL_TABLE[FlowInfo.getIndex(this.fAccessModes[i])][FlowInfo.getIndex(others[i])];
            }
        }
    }

    protected void mergeEmptyCondition(FlowContext context) {
        if (this.fReturnKind == 5 || this.fReturnKind == 4) {
            this.fReturnKind = 3;
        }
        if (!context.considerAccessMode()) {
            return;
        }
        if (this.fAccessModes == null) {
            this.createAccessModeArray(context);
            return;
        }
        int unused_index = FlowInfo.getIndex(1);
        for (int i = 0; i < this.fAccessModes.length; ++i) {
            this.fAccessModes[i] = ACCESS_MODE_CONDITIONAL_TABLE[FlowInfo.getIndex(this.fAccessModes[i])][unused_index];
        }
    }

    private static int getIndex(int accessMode) {
        switch (accessMode) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
        }
        return -1;
    }
}

