/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaRefactorings;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.code.ConstantChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ExtractConstantRefactoring
extends Refactoring {
    private static final char UNDERSCORE = '_';
    public static final String PUBLIC = "public";
    public static final String PROTECTED = "protected";
    public static final String PACKAGE = "";
    public static final String PRIVATE = "private";
    private static final String MODIFIER = "static final";
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is"};
    private final int fSelectionStart;
    private final int fSelectionLength;
    private final ICompilationUnit fCu;
    private IExpressionFragment fSelectedExpression;
    private boolean fReplaceAllOccurrences = true;
    private boolean fQualifyReferencesWithDeclaringClassName = false;
    private String fAccessModifier = "private";
    private String fConstantName = "";
    private CompilationUnit fCompilationUnitNode;
    private boolean fSelectionAllStaticFinal;
    private boolean fAllStaticFinalCheckPerformed = false;
    private List fBodyDeclarations;
    private BodyDeclaration fToInsertAfter;
    private boolean fInsertFirst;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TypeDeclaration;

    private ExtractConstantRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        Assert.isNotNull(settings);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = cu;
    }

    public static boolean isAvailable(ASTNode[] selectedNodes, ASTNode coveringNode) {
        return Checks.isExtractableExpression(selectedNodes, coveringNode);
    }

    public static ExtractConstantRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) {
        return new ExtractConstantRefactoring(cu, selectionStart, selectionLength, settings);
    }

    public String getName() {
        return RefactoringCoreMessages.getString("ExtractConstantRefactoring.name");
    }

    public boolean replaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.fReplaceAllOccurrences = replaceAllOccurrences;
    }

    public void setAccessModifier(String am) {
        Assert.isTrue(am == PRIVATE || am == PROTECTED || am == PACKAGE || am == PUBLIC);
        this.fAccessModifier = am;
    }

    public String getAccessModifier() {
        return this.fAccessModifier;
    }

    public boolean qualifyReferencesWithDeclaringClassName() {
        return this.fQualifyReferencesWithDeclaringClassName;
    }

    public void setQualifyReferencesWithDeclaringClassName(boolean qualify) {
        this.fQualifyReferencesWithDeclaringClassName = qualify;
    }

    public String guessConstantName() throws JavaModelException {
        String candidate;
        IExpressionFragment selectedFragment = this.getSelectedExpression();
        if (selectedFragment == null) {
            return this.fConstantName;
        }
        Expression selected = selectedFragment.getAssociatedExpression();
        if (selected instanceof MethodInvocation) {
            String candidate2 = ExtractConstantRefactoring.guessContantName((MethodInvocation)selected);
            if (candidate2 != null) {
                return candidate2;
            }
        } else if (selected instanceof StringLiteral && (candidate = ExtractConstantRefactoring.guessContantName((StringLiteral)selected)) != null) {
            return candidate;
        }
        return this.fConstantName;
    }

    private static String guessContantName(StringLiteral literal) {
        return ExtractConstantRefactoring.convertNonLettersToUnderscores(literal.getLiteralValue()).toUpperCase();
    }

    private static String convertNonLettersToUnderscores(String string) {
        if (string.length() == 0) {
            return PACKAGE;
        }
        StringBuffer result = new StringBuffer(string.length());
        if (Character.isJavaIdentifierStart(string.charAt(0))) {
            result.append(string.charAt(0));
        } else {
            result.append('_');
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) {
                result.append(string.charAt(i));
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }

    private static String guessContantName(MethodInvocation selectedNode) {
        for (int i = 0; i < KNOWN_METHOD_NAME_PREFIXES.length; ++i) {
            String proposal = ExtractConstantRefactoring.tryTempNamePrefix(KNOWN_METHOD_NAME_PREFIXES[i], selectedNode.getName().getIdentifier());
            if (proposal == null) continue;
            return proposal;
        }
        return null;
    }

    private static String tryTempNamePrefix(String prefix, String methodName) {
        if (ExtractConstantRefactoring.isPrefixOk(prefix, methodName)) {
            return ExtractConstantRefactoring.splitByUpperCaseChars(methodName.substring(prefix.length())).toUpperCase();
        }
        return null;
    }

    private static boolean isPrefixOk(String prefix, String methodName) {
        if (!methodName.startsWith(prefix)) {
            return false;
        }
        if (methodName.length() <= prefix.length()) {
            return false;
        }
        return Character.isUpperCase(methodName.charAt(prefix.length()));
    }

    private static String splitByUpperCaseChars(String string) {
        StringBuffer buff = new StringBuffer(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (i != 0 && Character.isUpperCase(c)) {
                buff.append('_');
            }
            buff.append(c);
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(PACKAGE, 8);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            if (!this.fCu.isStructureKnown()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractConstantRefactoring.syntax_error"));
                return refactoringStatus;
            }
            pm.worked(1);
            this.initializeAST((IProgressMonitor)new SubProgressMonitor(pm, 1));
            result.merge(this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 5)));
            if (!result.hasFatalError() && this.isLiteralNodeSelected()) {
                this.fReplaceAllOccurrences = false;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public boolean selectionAllStaticFinal() {
        Assert.isTrue(this.fAllStaticFinalCheckPerformed);
        return this.fSelectionAllStaticFinal;
    }

    private void checkAllStaticFinal() throws JavaModelException {
        this.fSelectionAllStaticFinal = ConstantChecks.isStaticFinalConstant(this.getSelectedExpression());
        this.fAllStaticFinalCheckPerformed = true;
    }

    private String getModifier() {
        return this.getAccessModifier() + " " + MODIFIER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        try {
            pm.beginTask(PACKAGE, 2);
            IExpressionFragment selectedExpression = this.getSelectedExpression();
            if (selectedExpression == null) {
                String message = RefactoringCoreMessages.getString("ExtractConstantRefactoring.select_expression");
                RefactoringStatus refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCompilationUnitNode, message);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkExpression());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkExpressionBinding() throws JavaModelException {
        return this.checkExpressionFragmentIsRValue();
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaModelException {
        switch (Checks.checkExpressionIsRValue(this.getSelectedExpression().getAssociatedExpression())) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("ExtractConstantRefactoring.select_expression"), null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("ExtractConstantRefactoring.no_void"), null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue(false);
        return null;
    }

    private boolean isLiteralNodeSelected() throws JavaModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        if (fragment == null) {
            return false;
        }
        Expression expression = fragment.getAssociatedExpression();
        if (expression == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    private void initializeAST(IProgressMonitor pm) {
        this.fCompilationUnitNode = new RefactoringASTParser(2).parse(this.fCu, true, pm);
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkExpressionBinding());
        if (result.hasFatalError()) {
            return result;
        }
        this.checkAllStaticFinal();
        IExpressionFragment selectedExpression = this.getSelectedExpression();
        Expression associatedExpression = selectedExpression.getAssociatedExpression();
        if (associatedExpression instanceof NullLiteral) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractConstantRefactoring.null_literals")));
        } else if (!ConstantChecks.isLoadTimeConstant(selectedExpression)) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractConstantRefactoring.not_load_time_constant")));
        } else if (associatedExpression instanceof SimpleName && (associatedExpression.getParent() instanceof QualifiedName && associatedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || associatedExpression.getParent() instanceof FieldAccess && associatedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractConstantRefactoring.select_expression"));
        }
        return result;
    }

    public void setConstantName(String newName) {
        Assert.isNotNull(newName);
        this.fConstantName = newName;
    }

    public String getConstantName() {
        return this.fConstantName;
    }

    public RefactoringStatus checkConstantNameOnChange() throws JavaModelException {
        if (this.fieldExistsInThisType()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getFormattedString("ExtractConstantRefactoring.field_exists", this.getConstantName()));
        }
        return Checks.checkConstantName(this.getConstantName());
    }

    private boolean fieldExistsInThisType() throws JavaModelException {
        return this.getContainingType().getField(this.getConstantName()).exists();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.getString("ExtractConstantRefactoring.checking_preconditions"), 1);
        RefactoringStatus result = this.checkCompilation();
        pm.done();
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus checkCompilation() throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block7: {
            TextBuffer buffer = null;
            try {
                RefactoringStatus result = new RefactoringStatus();
                buffer = TextBuffer.acquire((IFile)WorkingCopyUtil.getOriginal(this.fCu).getResource());
                TextEdit[] edits = this.getAllEdits(buffer);
                DocumentChange change = new DocumentChange(RefactoringCoreMessages.getString("ExtractConstantRefactoring.rename"), (IDocument)new Document(this.fCu.getSource()));
                TextChangeCompatibility.addTextEdit((TextChange)change, PACKAGE, edits);
                String newCuSource = change.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
                ASTParser p = ASTParser.newParser((int)2);
                p.setSource(newCuSource.toCharArray());
                p.setUnitName(this.fCu.getElementName());
                p.setProject(this.fCu.getJavaProject());
                p.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)this.fCu));
                CompilationUnit newCUNode = (CompilationUnit)p.createAST(null);
                IProblem[] newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fCompilationUnitNode);
                for (int i = 0; i < newProblems.length; ++i) {
                    IProblem problem = newProblems[i];
                    if (!problem.isError()) continue;
                    result.addEntry(JavaRefactorings.createStatusEntry(problem, newCuSource));
                }
                refactoringStatus = result;
                if (buffer == null) break block7;
            }
            catch (JavaModelException e) {
                try {
                    throw e;
                    catch (CoreException e2) {
                        throw new JavaModelException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (buffer != null) {
                        TextBuffer.release(buffer);
                    }
                    throw throwable;
                }
            }
            TextBuffer.release(buffer);
        }
        return refactoringStatus;
    }

    public String getConstantSignaturePreview() throws JavaModelException {
        return this.getModifier() + " " + this.getConstantTypeName() + " " + this.fConstantName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        CompilationUnitChange compilationUnitChange;
        block3: {
            TextBuffer buffer = null;
            try {
                buffer = TextBuffer.acquire((IFile)WorkingCopyUtil.getOriginal(this.fCu).getResource());
                pm.beginTask(RefactoringCoreMessages.getString("ExtractConstantRefactoring.preview"), 3);
                CompilationUnitChange result = new CompilationUnitChange(RefactoringCoreMessages.getString("ExtractConstantRefactoring.extract_constant"), this.fCu);
                this.addConstantDeclaration((TextChange)result);
                pm.worked(1);
                this.addImportIfNeeded((TextChange)result, buffer);
                pm.worked(1);
                this.addReplaceExpressionWithConstant((TextChange)result);
                pm.worked(1);
                compilationUnitChange = result;
                Object var6_5 = null;
                if (buffer == null) break block3;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (buffer != null) {
                    TextBuffer.release(buffer);
                }
                pm.done();
                throw throwable;
            }
            TextBuffer.release(buffer);
        }
        pm.done();
        return compilationUnitChange;
    }

    private TextEdit[] getAllEdits(TextBuffer buffer) throws CoreException {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>(3);
        edits.add(this.createConstantDeclarationEdit());
        TextEdit importEdit = this.createImportEditIfNeeded(buffer);
        if (importEdit != null) {
            edits.add(importEdit);
        }
        TextEdit[] replaceEdits = this.createReplaceExpressionWithConstantEdits();
        for (int i = 0; i < replaceEdits.length; ++i) {
            edits.add(replaceEdits[i]);
        }
        return edits.toArray(new TextEdit[edits.size()]);
    }

    private TextEdit createConstantDeclarationEdit() throws CoreException {
        if (this.insertFirst()) {
            return this.createInsertDeclarationFirstEdit();
        }
        return this.createInsertDeclarationAfterEdit(this.getNodeToInsertConstantDeclarationAfter());
    }

    private TextEdit createInsertDeclarationFirstEdit() throws JavaModelException, CoreException {
        BodyDeclaration first = (BodyDeclaration)this.getBodyDeclarations().next();
        int insertOffset = first.getStartPosition();
        String text = this.createConstantDeclarationSource() + this.getLineDelimiter() + this.getIndent((ASTNode)first);
        return new InsertEdit(insertOffset, text);
    }

    private TextEdit createInsertDeclarationAfterEdit(BodyDeclaration toInsertAfter) throws JavaModelException, CoreException {
        Assert.isNotNull(toInsertAfter);
        if (this.isOtherDeclOrClassEndOnSameLine(toInsertAfter)) {
            return this.createInsertDeclarationOnSameLineEdit(toInsertAfter);
        }
        return this.createInsertDeclarationOnNextLineEdit(toInsertAfter);
    }

    private boolean isOtherDeclOrClassEndOnSameLine(BodyDeclaration toInsertAfter) throws JavaModelException {
        TypeDeclaration typeDecl;
        int typeDeclClose;
        int indexToInsertAtOrAfter = toInsertAfter.getStartPosition() + toInsertAfter.getLength();
        BodyDeclaration nextBodyDecl = this.getNextBodyDeclaration(toInsertAfter);
        return nextBodyDecl != null ? this.isOnSameLine(indexToInsertAtOrAfter, nextBodyDecl.getStartPosition()) : this.isOnSameLine(indexToInsertAtOrAfter, typeDeclClose = (typeDecl = this.getContainingTypeDeclarationNode()).getStartPosition() + typeDecl.getLength() - 1);
    }

    private boolean isOnSameLine(int firstOffset, int secondOffset) {
        return this.lineNumber(firstOffset) == this.lineNumber(secondOffset);
    }

    private int lineNumber(int offset) {
        return this.fCompilationUnitNode.lineNumber(offset);
    }

    private BodyDeclaration getNextBodyDeclaration(BodyDeclaration bodyDeclaration) throws JavaModelException {
        Assert.isNotNull(bodyDeclaration);
        Iterator it = this.getBodyDeclarations();
        while (it.hasNext()) {
            if (!bodyDeclaration.equals(it.next()) || !it.hasNext()) continue;
            return (BodyDeclaration)it.next();
        }
        return null;
    }

    private TextEdit createInsertDeclarationOnNextLineEdit(BodyDeclaration toInsertAfter) throws JavaModelException, CoreException {
        Assert.isNotNull(toInsertAfter);
        int insertOffset = this.getStartOfFollowingLine(toInsertAfter);
        String text = this.getIndent((ASTNode)toInsertAfter) + this.createConstantDeclarationSource() + this.getLineDelimiter();
        return new InsertEdit(insertOffset, text);
    }

    private int getStartOfFollowingLine(BodyDeclaration declaration) {
        CompilationUnit cu = this.fCompilationUnitNode;
        int declEnd = this.getNodeInclusiveEnd((ASTNode)declaration);
        int declLine = cu.lineNumber(declEnd);
        int i = declEnd;
        while (cu.lineNumber(i) == declLine) {
            ++i;
        }
        return i;
    }

    private int getNodeInclusiveEnd(ASTNode node) {
        return this.getNodeExclusiveEnd(node) - 1;
    }

    private int getNodeExclusiveEnd(ASTNode node) {
        return node.getStartPosition() + node.getLength();
    }

    private TextEdit createInsertDeclarationOnSameLineEdit(BodyDeclaration toInsertAfter) throws JavaModelException, CoreException {
        Assert.isNotNull(toInsertAfter);
        int insertOffset = this.getNodeExclusiveEnd((ASTNode)toInsertAfter);
        String text = " " + this.createConstantDeclarationSource();
        return new InsertEdit(insertOffset, text);
    }

    private TextEdit createImportEditIfNeeded(TextBuffer buffer) throws CoreException {
        ITypeBinding type = this.getSelectedExpression().getAssociatedExpression().resolveTypeBinding();
        if (type.isPrimitive()) {
            return null;
        }
        if (type.isArray() && type.getElementType().isPrimitive()) {
            return null;
        }
        ImportRewrite rewrite = new ImportRewrite(this.fCu);
        rewrite.addImport(type);
        if (rewrite.isEmpty()) {
            return null;
        }
        return rewrite.createEdit(buffer.getDocument());
    }

    private TextEdit[] createReplaceExpressionWithConstantEdits() throws JavaModelException {
        IASTFragment[] fragmentsToReplace = this.getFragmentsToReplace();
        TextEdit[] result = new TextEdit[fragmentsToReplace.length];
        for (int i = 0; i < fragmentsToReplace.length; ++i) {
            IASTFragment fragment = fragmentsToReplace[i];
            int offset = fragment.getStartPosition();
            int length = fragment.getLength();
            result[i] = this.createReplaceEdit(offset, length);
        }
        return result;
    }

    private TextEdit createReplaceEdit(int offset, int length) throws JavaModelException {
        String constantReference = this.getConstantNameForReference();
        return new ReplaceEdit(offset, length, constantReference);
    }

    private String getConstantNameForReference() throws JavaModelException {
        return this.getReferenceQualifier() + this.fConstantName;
    }

    private String getReferenceQualifier() throws JavaModelException {
        if (this.qualifyReferencesWithDeclaringClassName()) {
            return this.getContainingTypeBinding().getName() + ".";
        }
        return PACKAGE;
    }

    private void addConstantDeclaration(TextChange change) throws CoreException {
        TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.getString("ExtractConstantRefactoring.declare_constant"), this.createConstantDeclarationEdit());
    }

    private void addImportIfNeeded(TextChange change, TextBuffer buffer) throws CoreException {
        TextEdit importEdit = this.createImportEditIfNeeded(buffer);
        if (importEdit != null) {
            TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.getString("ExtractConstantRefactoring.update_imports"), importEdit);
        }
    }

    private void addReplaceExpressionWithConstant(TextChange change) throws JavaModelException {
        TextEdit[] edits = this.createReplaceExpressionWithConstantEdits();
        for (int i = 0; i < edits.length; ++i) {
            TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.getString("ExtractConstantRefactoring.replace"), edits[i]);
        }
    }

    private void computeConstantDeclarationLocation() throws JavaModelException {
        if (this.isDeclarationLocationComputed()) {
            return;
        }
        BodyDeclaration lastStaticDependency = null;
        Iterator decls = this.getBodyDeclarations();
        Assert.isTrue(decls.hasNext());
        while (decls.hasNext()) {
            int modifiers;
            BodyDeclaration decl = (BodyDeclaration)decls.next();
            if (decl instanceof FieldDeclaration) {
                modifiers = ((FieldDeclaration)decl).getModifiers();
            } else {
                if (!(decl instanceof Initializer)) continue;
                modifiers = ((Initializer)decl).getModifiers();
            }
            if (!Modifier.isStatic((int)modifiers) || !ExtractConstantRefactoring.depends(this.getSelectedExpression(), decl)) continue;
            lastStaticDependency = decl;
        }
        if (lastStaticDependency == null) {
            this.fInsertFirst = true;
        } else {
            this.fToInsertAfter = lastStaticDependency;
        }
    }

    private static boolean depends(IExpressionFragment selected, BodyDeclaration bd) {
        if (bd instanceof FieldDeclaration) {
            FieldDeclaration fieldDecl = (FieldDeclaration)bd;
            Iterator fragments = fieldDecl.fragments().iterator();
            while (fragments.hasNext()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.next();
                SimpleName staticFieldName = fragment.getName();
                if (selected.getSubFragmentsMatching(ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)staticFieldName)).length == 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDeclarationLocationComputed() {
        return this.fInsertFirst || this.fToInsertAfter != null;
    }

    private boolean insertFirst() throws JavaModelException {
        if (!this.isDeclarationLocationComputed()) {
            this.computeConstantDeclarationLocation();
        }
        return this.fInsertFirst;
    }

    private BodyDeclaration getNodeToInsertConstantDeclarationAfter() throws JavaModelException {
        if (!this.isDeclarationLocationComputed()) {
            this.computeConstantDeclarationLocation();
        }
        return this.fToInsertAfter;
    }

    private Iterator getBodyDeclarations() throws JavaModelException {
        if (this.fBodyDeclarations == null) {
            this.fBodyDeclarations = this.getContainingTypeDeclarationNode().bodyDeclarations();
        }
        return this.fBodyDeclarations.iterator();
    }

    private String createConstantDeclarationSource() throws JavaModelException, CoreException {
        return this.createConstantDeclarationSource(this.getInitializerSource());
    }

    private String createConstantDeclarationSource(String initializerSource) throws CoreException {
        String dummyInitializer = "0";
        String semicolon = ";";
        String dummyDeclaration = this.getModifier() + " " + this.getConstantTypeName() + " " + this.fConstantName + " = " + dummyInitializer + semicolon;
        int[] position = new int[]{dummyDeclaration.length() - dummyInitializer.length() - semicolon.length()};
        String formattedDeclaration = CodeFormatterUtil.format(4, dummyDeclaration, 0, position, this.getLineDelimiter(), this.fCu.getJavaProject());
        StringBuffer formattedDummyDeclaration = new StringBuffer(formattedDeclaration);
        return formattedDummyDeclaration.replace(position[0], position[0] + dummyInitializer.length(), initializerSource).toString();
    }

    private String getConstantTypeName() throws JavaModelException {
        IExpressionFragment selection = this.getSelectedExpression();
        Expression expression = selection.getAssociatedExpression();
        String name = expression.resolveTypeBinding().getName();
        if (!PACKAGE.equals(name) || !(expression instanceof ClassInstanceCreation)) {
            return name;
        }
        ClassInstanceCreation cic = (ClassInstanceCreation)expression;
        Assert.isNotNull(cic.getAnonymousClassDeclaration());
        return ASTNodes.asString((ASTNode)cic.getName());
    }

    private String getInitializerSource() throws JavaModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        return ExtractConstantRefactoring.removeTrailingSemicolons(this.fCu.getBuffer().getText(fragment.getStartPosition(), fragment.getLength()));
    }

    private static String removeTrailingSemicolons(String s) {
        String arg = s.trim();
        if (!arg.endsWith(";")) {
            return arg;
        }
        return ExtractConstantRefactoring.removeTrailingSemicolons(arg.substring(0, arg.length() - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIndent(ASTNode insertAfter) throws CoreException {
        TextBuffer buffer = null;
        try {
            buffer = TextBuffer.acquire(this.getFile());
            int startLine = buffer.getLineOfOffset(insertAfter.getStartPosition());
            String string = CodeFormatterUtil.createIndentString(buffer.getLineIndent(startLine, CodeFormatterUtil.getTabWidth()));
            return string;
        }
        finally {
            if (buffer != null) {
                TextBuffer.release(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLineDelimiter() throws CoreException {
        TextBuffer buffer = null;
        try {
            buffer = TextBuffer.acquire(this.getFile());
            String string = buffer.getLineDelimiter(buffer.getLineOfOffset(this.fSelectionStart));
            return string;
        }
        finally {
            if (buffer != null) {
                TextBuffer.release(buffer);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isStaticFieldOrStaticInitializer(BodyDeclaration node) {
        void var1_1;
        int modifiers;
        if (node instanceof MethodDeclaration || node instanceof TypeDeclaration) {
            return false;
        }
        if (node instanceof FieldDeclaration) {
            modifiers = ((FieldDeclaration)node).getModifiers();
        } else if (node instanceof Initializer) {
            modifiers = ((Initializer)node).getModifiers();
        } else {
            Assert.isTrue(false);
            return false;
        }
        return Modifier.isStatic((int)var1_1);
    }

    private Iterator getReplacementScope() throws JavaModelException {
        boolean declPredecessorReached = false;
        ArrayList<BodyDeclaration> scope = new ArrayList<BodyDeclaration>();
        Iterator bodyDeclarations = this.getBodyDeclarations();
        while (bodyDeclarations.hasNext()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.next();
            if (bodyDeclaration == this.getNodeToInsertConstantDeclarationAfter()) {
                declPredecessorReached = true;
            }
            if (!this.insertFirst() && !declPredecessorReached && ExtractConstantRefactoring.isStaticFieldOrStaticInitializer(bodyDeclaration)) continue;
            scope.add(bodyDeclaration);
        }
        return scope.iterator();
    }

    private IASTFragment[] getFragmentsToReplace() throws JavaModelException {
        ArrayList<IASTFragment> toReplace = new ArrayList<IASTFragment>();
        if (this.fReplaceAllOccurrences) {
            Iterator replacementScope = this.getReplacementScope();
            while (replacementScope.hasNext()) {
                BodyDeclaration bodyDecl = (BodyDeclaration)replacementScope.next();
                IASTFragment[] allMatches = ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)bodyDecl).getSubFragmentsMatching(this.getSelectedExpression());
                IASTFragment[] replaceableMatches = ExtractConstantRefactoring.retainOnlyReplacableMatches(allMatches);
                for (int i = 0; i < replaceableMatches.length; ++i) {
                    toReplace.add(replaceableMatches[i]);
                }
            }
        } else if (ExtractConstantRefactoring.canReplace(this.getSelectedExpression())) {
            toReplace.add(this.getSelectedExpression());
        }
        return toReplace.toArray(new IASTFragment[toReplace.size()]);
    }

    private static IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] allMatches) {
        ArrayList<IASTFragment> result = new ArrayList<IASTFragment>(allMatches.length);
        for (int i = 0; i < allMatches.length; ++i) {
            if (!ExtractConstantRefactoring.canReplace(allMatches[i])) continue;
            result.add(allMatches[i]);
        }
        return result.toArray(new IASTFragment[result.size()]);
    }

    private static boolean canReplace(IASTFragment fragment) {
        VariableDeclarationFragment vdf;
        ASTNode node = fragment.getAssociatedNode();
        if (node.getParent() instanceof VariableDeclarationFragment && node.equals((Object)(vdf = (VariableDeclarationFragment)node.getParent()).getName())) {
            return false;
        }
        return !(node.getParent() instanceof ExpressionStatement);
    }

    private IExpressionFragment getSelectedExpression() throws JavaModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        IASTFragment selectedFragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fCompilationUnitNode, this.fCu);
        if (selectedFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc(selectedFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)selectedFragment;
        }
        return this.fSelectedExpression;
    }

    private TypeDeclaration getContainingTypeDeclarationNode() throws JavaModelException {
        TypeDeclaration result = (TypeDeclaration)ASTNodes.getParent(this.getSelectedExpression().getAssociatedNode(), class$org$eclipse$jdt$core$dom$TypeDeclaration == null ? (class$org$eclipse$jdt$core$dom$TypeDeclaration = ExtractConstantRefactoring.class$("org.eclipse.jdt.core.dom.TypeDeclaration")) : class$org$eclipse$jdt$core$dom$TypeDeclaration);
        Assert.isNotNull(result);
        return result;
    }

    private ITypeBinding getContainingTypeBinding() throws JavaModelException {
        ITypeBinding result = this.getContainingTypeDeclarationNode().resolveBinding();
        Assert.isNotNull(result);
        return result;
    }

    private IType getContainingType() throws JavaModelException {
        IType type = (IType)this.fCu.getElementAt(this.getContainingTypeDeclarationNode().getName().getStartPosition());
        Assert.isNotNull(type);
        return type;
    }

    private IFile getFile() {
        return ResourceUtil.getFile(this.fCu);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

