/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class ConvertAnonymousToNestedRefactoring
extends Refactoring {
    private final int fSelectionStart;
    private final int fSelectionLength;
    private final ICompilationUnit fCu;
    private int fVisibility;
    private boolean fDeclareFinal;
    private boolean fDeclareStatic;
    private String fClassName;
    private CompilationUnit fCompilationUnitNode;
    private AnonymousClassDeclaration fAnonymousInnerClassNode;
    private Set fClassNamesUsed;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TypeDeclaration;

    private ConvertAnonymousToNestedRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = cu;
    }

    public static boolean isAvailable(IType type) throws JavaModelException {
        return type.isAnonymous();
    }

    public static ConvertAnonymousToNestedRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength) {
        return new ConvertAnonymousToNestedRefactoring(cu, selectionStart, selectionLength);
    }

    public int[] getAvailableVisibilities() {
        if (this.isLocalInnerType()) {
            return new int[]{0};
        }
        return new int[]{1, 4, 0, 2};
    }

    private boolean isLocalInnerType() {
        return ASTNodes.getParent((ASTNode)this.getTypeDeclaration(), 1) != null;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        Assert.isTrue(visibility == 2 || visibility == 0 || visibility == 4 || visibility == 1);
        this.fVisibility = visibility;
    }

    public void setClassName(String className) {
        Assert.isNotNull(className);
        this.fClassName = className;
    }

    public boolean canEnableSettingFinal() {
        return true;
    }

    public boolean getDeclareFinal() {
        return this.fDeclareFinal;
    }

    public boolean getDeclareStatic() {
        return this.fDeclareStatic;
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setDeclareStatic(boolean declareStatic) {
        this.fDeclareStatic = declareStatic;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.name");
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
        if (result.hasFatalError()) {
            return result;
        }
        this.initAST(pm);
        if (this.fAnonymousInnerClassNode == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.place_caret"));
        }
        this.initializeDefaults();
        if (this.getSuperConstructorBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.compile_errors"));
        }
        if (this.getSuperTypeBinding().isLocal()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.extends_local_class"));
        }
        return new RefactoringStatus();
    }

    private void initializeDefaults() {
        this.fVisibility = this.isLocalInnerType() ? 0 : 2;
        this.fClassName = "";
        this.fDeclareFinal = true;
        this.fDeclareStatic = this.mustInnerClassBeStatic();
    }

    private void initAST(IProgressMonitor pm) {
        this.fCompilationUnitNode = new RefactoringASTParser(2).parse(this.fCu, true, pm);
        this.fAnonymousInnerClassNode = ConvertAnonymousToNestedRefactoring.getAnonymousInnerClass(NodeFinder.perform((ASTNode)this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength));
        if (this.fAnonymousInnerClassNode != null) {
            TypeDeclaration[] nestedtypes = this.getTypeDeclaration().getTypes();
            this.fClassNamesUsed = new HashSet(nestedtypes.length);
            for (int i = 0; i < nestedtypes.length; ++i) {
                this.fClassNamesUsed.add(nestedtypes[i].getName().getIdentifier());
            }
        }
    }

    private static AnonymousClassDeclaration getAnonymousInnerClass(ASTNode node) {
        AnonymousClassDeclaration anon;
        if (node == null) {
            return null;
        }
        if (node instanceof AnonymousClassDeclaration) {
            return (AnonymousClassDeclaration)node;
        }
        if (node instanceof ClassInstanceCreation && (anon = ((ClassInstanceCreation)node).getAnonymousClassDeclaration()) != null) {
            return anon;
        }
        if (node.getParent() instanceof ClassInstanceCreation && (anon = ((ClassInstanceCreation)node.getParent()).getAnonymousClassDeclaration()) != null) {
            return anon;
        }
        return (AnonymousClassDeclaration)ASTNodes.getParent(node, class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration == null ? (class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration = ConvertAnonymousToNestedRefactoring.class$("org.eclipse.jdt.core.dom.AnonymousClassDeclaration")) : class$org$eclipse$jdt$core$dom$AnonymousClassDeclaration);
    }

    public RefactoringStatus validateInput() {
        RefactoringStatus result = Checks.checkTypeName(this.fClassName);
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fClassNamesUsed.contains(this.fClassName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.type_exists"));
        }
        IMethodBinding superConstructorBinding = this.getSuperConstructorBinding();
        if (superConstructorBinding == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.compile_errors"));
        }
        if (this.fClassName.equals(superConstructorBinding.getDeclaringClass().getName())) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.another_name"));
        }
        if (this.classNameHidesEnclosingType()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.name_hides"));
        }
        return result;
    }

    private boolean accessesAnonymousFields() {
        List anonymousInnerFieldTypes = this.getAllEnclosingAnonymousTypesField();
        List accessedField = this.getAllAccessedFields();
        Iterator it = anonymousInnerFieldTypes.iterator();
        while (it.hasNext()) {
            IVariableBinding variableBinding = (IVariableBinding)it.next();
            Iterator it2 = accessedField.iterator();
            while (it2.hasNext()) {
                IVariableBinding variableBinding2 = (IVariableBinding)it2.next();
                if (!Bindings.equals((IBinding)variableBinding, (IBinding)variableBinding2)) continue;
                return true;
            }
        }
        return false;
    }

    private List getAllAccessedFields() {
        final ArrayList accessedFields = new ArrayList();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(SimpleName node) {
                IBinding binding = node.resolveBinding();
                if (binding != null && binding instanceof IVariableBinding) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }

            public boolean visit(FieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                if (binding != null) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }

            public boolean visit(QualifiedName node) {
                IBinding binding = node.resolveBinding();
                if (binding != null && binding instanceof IVariableBinding) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }

            public boolean visit(SuperFieldAccess node) {
                IVariableBinding binding = node.resolveFieldBinding();
                if (binding != null) {
                    accessedFields.add(binding);
                }
                return super.visit(node);
            }
        };
        this.fAnonymousInnerClassNode.accept(visitor);
        return accessedFields;
    }

    private List getAllEnclosingAnonymousTypesField() {
        ArrayList<IVariableBinding> ans = new ArrayList<IVariableBinding>();
        TypeDeclaration typeDeclaration = this.getTypeDeclaration();
        AnonymousClassDeclaration current = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, 1);
        while (current != null && ASTNodes.isParent((ASTNode)current, (ASTNode)typeDeclaration)) {
            ITypeBinding binding = current.resolveBinding();
            if (binding != null) {
                ans.addAll(Arrays.asList(binding.getDeclaredFields()));
            }
            current = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)current, 1);
        }
        return ans;
    }

    private boolean classNameHidesEnclosingType() {
        for (ITypeBinding type = this.getTypeDeclaration().resolveBinding(); type != null; type = type.getDeclaringClass()) {
            if (!this.fClassName.equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            RefactoringStatus status = this.validateInput();
            if (this.accessesAnonymousFields()) {
                status.merge(RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.anonymous_field_access")));
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            OldASTRewrite rewrite = new OldASTRewrite((ASTNode)this.fCompilationUnitNode);
            this.addNestedClass(rewrite);
            this.modifyConstructorCall(rewrite);
            Change change = this.createChange(rewrite);
            return change;
        }
        finally {
            pm.done();
        }
    }

    private Change createChange(OldASTRewrite rewrite) throws CoreException {
        CompilationUnitChange change = new CompilationUnitChange("", this.fCu);
        TextBuffer textBuffer = TextBuffer.create(this.fCu.getBuffer().getContents());
        MultiTextEdit resultingEdits = new MultiTextEdit();
        rewrite.rewriteNode(textBuffer, (TextEdit)resultingEdits);
        TextChangeCompatibility.addTextEdit((TextChange)change, RefactoringCoreMessages.getString("ConvertAnonymousToNestedRefactoring.edit_name"), (TextEdit)resultingEdits);
        rewrite.removeModifications();
        return change;
    }

    private void modifyConstructorCall(OldASTRewrite rewrite) {
        rewrite.replace((ASTNode)this.getClassInstanceCreation(), this.createNewClassInstanceCreation(rewrite), null);
    }

    private ASTNode createNewClassInstanceCreation(OldASTRewrite rewrite) {
        ClassInstanceCreation newClassCreation = this.getAST().newClassInstanceCreation();
        newClassCreation.setAnonymousClassDeclaration(null);
        newClassCreation.setName((Name)this.getAST().newSimpleName(this.fClassName));
        this.copyArguments(rewrite, newClassCreation);
        this.addArgumentsForLocalsUsedInInnerClass(rewrite, newClassCreation);
        return newClassCreation;
    }

    private void addArgumentsForLocalsUsedInInnerClass(OldASTRewrite rewrite, ClassInstanceCreation newClassCreation) {
        IVariableBinding[] usedLocals = this.getUsedLocalVariables();
        for (int i = 0; i < usedLocals.length; ++i) {
            IVariableBinding local = usedLocals[i];
            SimpleName expression = this.getAST().newSimpleName(local.getName());
            rewrite.markAsInserted((ASTNode)expression);
            newClassCreation.arguments().add(expression);
        }
    }

    private void copyArguments(OldASTRewrite rewrite, ClassInstanceCreation newClassCreation) {
        Iterator iter = this.getClassInstanceCreation().arguments().iterator();
        while (iter.hasNext()) {
            Expression arg = (Expression)iter.next();
            Expression copy = (Expression)rewrite.createCopyTarget((ASTNode)arg);
            rewrite.markAsInserted((ASTNode)copy);
            newClassCreation.arguments().add(copy);
        }
    }

    private void addNestedClass(OldASTRewrite rewrite) throws JavaModelException {
        TypeDeclaration type = this.getTypeDeclaration();
        List bodyDeclarations = type.bodyDeclarations();
        int index = ConvertAnonymousToNestedRefactoring.findIndexOfFistNestedClass(bodyDeclarations);
        if (index == -1) {
            index = 0;
        }
        TypeDeclaration newNestedClass = this.createNewNestedClass(rewrite);
        rewrite.markAsInserted((ASTNode)newNestedClass);
        bodyDeclarations.add(index, newNestedClass);
    }

    private static int findIndexOfFistNestedClass(List bodyDeclarations) {
        int n = bodyDeclarations.size();
        for (int i = 0; i < n; ++i) {
            BodyDeclaration each = (BodyDeclaration)bodyDeclarations.get(i);
            if (!ConvertAnonymousToNestedRefactoring.isNestedType(each)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isNestedType(BodyDeclaration each) {
        if (!(each instanceof TypeDeclaration)) {
            return false;
        }
        return each.getParent() instanceof TypeDeclaration;
    }

    private TypeDeclaration createNewNestedClass(OldASTRewrite rewrite) throws JavaModelException {
        TypeDeclaration newType = this.getAST().newTypeDeclaration();
        newType.setInterface(false);
        newType.setJavadoc(null);
        newType.setModifiers(this.createModifiersForNestedClass());
        newType.setName(this.getAST().newSimpleName(this.fClassName));
        this.setSuperType(newType);
        this.removeInitializationFromDeclaredFields(rewrite);
        this.copyBodyDeclarationsToNestedClass(rewrite, newType);
        this.createFieldsForAccessedLocals(rewrite, newType);
        this.createNewConstructorIfNeeded(rewrite, newType);
        return newType;
    }

    private void removeInitializationFromDeclaredFields(OldASTRewrite rewrite) {
        Iterator iter = this.getFieldsToInitializeInConstructor().iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
            Assert.isNotNull(fragment.getInitializer());
            rewrite.remove((ASTNode)fragment.getInitializer(), null);
        }
    }

    private void createFieldsForAccessedLocals(OldASTRewrite rewrite, TypeDeclaration newType) {
        IVariableBinding[] usedLocals = this.getUsedLocalVariables();
        for (int i = 0; i < usedLocals.length; ++i) {
            IVariableBinding local = usedLocals[i];
            VariableDeclarationFragment fragment = this.getAST().newVariableDeclarationFragment();
            fragment.setExtraDimensions(0);
            fragment.setInitializer(null);
            fragment.setName(this.getAST().newSimpleName(local.getName()));
            FieldDeclaration field = this.getAST().newFieldDeclaration(fragment);
            field.setType(ASTNodeFactory.newType(this.getAST(), local.getType(), false));
            field.setModifiers(18);
            newType.bodyDeclarations().add(ConvertAnonymousToNestedRefactoring.findIndexOfLastField(newType.bodyDeclarations()) + 1, field);
            rewrite.markAsInserted((ASTNode)field);
        }
    }

    private IVariableBinding[] getUsedLocalVariables() {
        HashSet result = new HashSet(0);
        this.fAnonymousInnerClassNode.accept(this.createTempUsageFinder(result));
        return result.toArray(new IVariableBinding[result.size()]);
    }

    private ASTVisitor createTempUsageFinder(final Set result) {
        return new ASTVisitor(){

            public boolean visit(SimpleName node) {
                IBinding binding = node.resolveBinding();
                if (ConvertAnonymousToNestedRefactoring.this.isBindingToTemp(binding)) {
                    result.add(binding);
                }
                return true;
            }
        };
    }

    private boolean isBindingToTemp(IBinding binding) {
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        if (!Modifier.isFinal((int)binding.getModifiers())) {
            return false;
        }
        ASTNode declaringNode = this.fCompilationUnitNode.findDeclaringNode(binding);
        if (declaringNode == null) {
            return false;
        }
        return !ASTNodes.isParent(declaringNode, (ASTNode)this.fAnonymousInnerClassNode);
    }

    private void createNewConstructorIfNeeded(OldASTRewrite rewrite, TypeDeclaration newType) throws JavaModelException {
        IVariableBinding[] usedLocals = this.getUsedLocalVariables();
        if (this.getClassInstanceCreation().arguments().isEmpty() && usedLocals.length == 0) {
            return;
        }
        MethodDeclaration newConstructor = this.getAST().newMethodDeclaration();
        newConstructor.setConstructor(true);
        newConstructor.setExtraDimensions(0);
        newConstructor.setJavadoc(null);
        newConstructor.setModifiers(this.fVisibility);
        newConstructor.setName(this.getAST().newSimpleName(this.fClassName));
        this.addParametersToNewConstructor(newConstructor, rewrite);
        int paramCount = newConstructor.parameters().size();
        this.addParametersForLocalsUsedInInnerClass(rewrite, usedLocals, newConstructor);
        Block constructorBody = this.getAST().newBlock();
        SuperConstructorInvocation superConstructorInvocation = this.getAST().newSuperConstructorInvocation();
        for (int i = 0; i < paramCount; ++i) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)newConstructor.parameters().get(i);
            superConstructorInvocation.arguments().add(this.getAST().newSimpleName(param.getName().getIdentifier()));
        }
        constructorBody.statements().add(superConstructorInvocation);
        Map options = this.fCu.getJavaProject().getOptions(true);
        for (int i = 0; i < usedLocals.length; ++i) {
            IVariableBinding local = usedLocals[i];
            String unformattedAssigmentCode = "this." + local.getName() + "=" + local.getName();
            String assignmentCode = CodeFormatterUtil.format(1, unformattedAssigmentCode, 0, null, this.getLineSeparator(), options);
            Expression assignmentExpression = (Expression)rewrite.createStringPlaceholder(assignmentCode, 32);
            ExpressionStatement assignmentStatement = this.getAST().newExpressionStatement(assignmentExpression);
            constructorBody.statements().add(assignmentStatement);
        }
        this.addFieldInitialization(rewrite, constructorBody);
        newConstructor.setBody(constructorBody);
        this.addExceptionsToNewConstructor(newConstructor);
        rewrite.markAsInserted((ASTNode)newConstructor);
        int index = 1 + usedLocals.length + ConvertAnonymousToNestedRefactoring.findIndexOfLastField(this.fAnonymousInnerClassNode.bodyDeclarations());
        newType.bodyDeclarations().add(index, newConstructor);
    }

    private void addFieldInitialization(OldASTRewrite rewrite, Block constructorBody) {
        Iterator iter = this.getFieldsToInitializeInConstructor().iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
            Assignment assignmentExpression = this.getAST().newAssignment();
            assignmentExpression.setOperator(Assignment.Operator.ASSIGN);
            assignmentExpression.setLeftHandSide((Expression)this.getAST().newSimpleName(fragment.getName().getIdentifier()));
            Expression rhs = (Expression)rewrite.createCopyTarget((ASTNode)fragment.getInitializer());
            assignmentExpression.setRightHandSide(rhs);
            ExpressionStatement assignmentStatement = this.getAST().newExpressionStatement((Expression)assignmentExpression);
            constructorBody.statements().add(assignmentStatement);
        }
    }

    private List getFieldsToInitializeInConstructor() {
        ArrayList<VariableDeclarationFragment> result = new ArrayList<VariableDeclarationFragment>(0);
        Iterator iter = this.fAnonymousInnerClassNode.bodyDeclarations().iterator();
        while (iter.hasNext()) {
            BodyDeclaration element = (BodyDeclaration)iter.next();
            if (!(element instanceof FieldDeclaration)) continue;
            FieldDeclaration field = (FieldDeclaration)element;
            Iterator fragmentIter = field.fragments().iterator();
            while (fragmentIter.hasNext()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragmentIter.next();
                if (!this.isToBeInitializerInConstructor(fragment)) continue;
                result.add(fragment);
            }
        }
        return result;
    }

    private boolean isToBeInitializerInConstructor(VariableDeclarationFragment fragment) {
        if (fragment.getInitializer() == null) {
            return false;
        }
        return this.areLocalsUsedIn(fragment.getInitializer());
    }

    private boolean areLocalsUsedIn(Expression fieldInitializer) {
        HashSet localsUsed = new HashSet(0);
        fieldInitializer.accept(this.createTempUsageFinder(localsUsed));
        return !localsUsed.isEmpty();
    }

    private void addParametersForLocalsUsedInInnerClass(OldASTRewrite rewrite, IVariableBinding[] usedLocals, MethodDeclaration newConstructor) {
        for (int i = 0; i < usedLocals.length; ++i) {
            IVariableBinding local = usedLocals[i];
            SingleVariableDeclaration param = this.createNewParamDeclarationNode(local.getName(), local.getType());
            rewrite.markAsInserted((ASTNode)param);
            newConstructor.parameters().add(param);
        }
    }

    private IMethodBinding getSuperConstructorBinding() {
        IMethodBinding anonConstr = this.getClassInstanceCreation().resolveConstructorBinding();
        if (anonConstr == null) {
            return null;
        }
        ITypeBinding superClass = anonConstr.getDeclaringClass().getSuperclass();
        IMethodBinding[] superMethods = superClass.getDeclaredMethods();
        for (int i = 0; i < superMethods.length; ++i) {
            IMethodBinding superMethod = superMethods[i];
            if (!superMethod.isConstructor() || !ConvertAnonymousToNestedRefactoring.parameterTypesMatch(superMethod, anonConstr)) continue;
            return superMethod;
        }
        Assert.isTrue(false);
        return null;
    }

    private static boolean parameterTypesMatch(IMethodBinding m1, IMethodBinding m2) {
        ITypeBinding[] m2Params;
        ITypeBinding[] m1Params = m1.getParameterTypes();
        if (m1Params.length != (m2Params = m2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < m2Params.length; ++i) {
            if (m1Params[i].equals(m2Params[i])) continue;
            return false;
        }
        return true;
    }

    private void addExceptionsToNewConstructor(MethodDeclaration newConstructor) {
        IMethodBinding constructorBinding = this.getSuperConstructorBinding();
        if (constructorBinding == null) {
            return;
        }
        ITypeBinding[] exceptions = constructorBinding.getExceptionTypes();
        for (int i = 0; i < exceptions.length; ++i) {
            Name exceptionTypeName = this.getAST().newName(Bindings.getNameComponents(exceptions[i]));
            newConstructor.thrownExceptions().add(exceptionTypeName);
        }
    }

    private void addParametersToNewConstructor(MethodDeclaration newConstructor, OldASTRewrite rewrite) throws JavaModelException {
        IMethodBinding constructorBinding = this.getSuperConstructorBinding();
        if (constructorBinding == null) {
            return;
        }
        ITypeBinding[] paramTypes = constructorBinding.getParameterTypes();
        IMethod method = Bindings.findMethod(constructorBinding, this.fCu.getJavaProject());
        if (method == null) {
            return;
        }
        String[] parameterNames = method.getParameterNames();
        for (int i = 0; i < parameterNames.length; ++i) {
            SingleVariableDeclaration param = this.createNewParamDeclarationNode(parameterNames[i], paramTypes[i]);
            rewrite.markAsInserted((ASTNode)param);
            newConstructor.parameters().add(param);
        }
    }

    private SingleVariableDeclaration createNewParamDeclarationNode(String paramName, ITypeBinding paramType) {
        SingleVariableDeclaration param = this.getAST().newSingleVariableDeclaration();
        param.setExtraDimensions(0);
        param.setInitializer(null);
        param.setModifiers(0);
        param.setName(this.getAST().newSimpleName(paramName));
        param.setType(ASTNodeFactory.newType(this.getAST(), paramType, false));
        return param;
    }

    private void copyBodyDeclarationsToNestedClass(OldASTRewrite rewrite, TypeDeclaration newType) {
        Iterator iter = this.fAnonymousInnerClassNode.bodyDeclarations().iterator();
        while (iter.hasNext()) {
            BodyDeclaration element = (BodyDeclaration)iter.next();
            BodyDeclaration copy = (BodyDeclaration)rewrite.createCopyTarget((ASTNode)element);
            rewrite.markAsInserted((ASTNode)copy);
            newType.bodyDeclarations().add(copy);
        }
    }

    private void setSuperType(TypeDeclaration newType) throws JavaModelException {
        ITypeBinding binding = this.getClassInstanceCreation().resolveTypeBinding();
        if (binding == null) {
            return;
        }
        if (binding.getSuperclass().getQualifiedName().equals("java.lang.Object")) {
            Assert.isTrue(binding.getInterfaces().length <= 1);
            if (binding.getInterfaces().length == 0) {
                return;
            }
            newType.superInterfaces().add(0, this.getSuperTypeName());
        } else {
            newType.setSuperclass(this.getSuperTypeName());
        }
    }

    private Name getSuperTypeName() throws JavaModelException {
        return this.getAST().newName(Strings.splitByToken(this.getNodeSourceCode((ASTNode)this.getClassInstanceCreation().getName()), "."));
    }

    private ITypeBinding getSuperTypeBinding() {
        ITypeBinding types = this.fAnonymousInnerClassNode.resolveBinding();
        ITypeBinding[] interfaces = types.getInterfaces();
        if (interfaces.length > 0) {
            return interfaces[0];
        }
        return types.getSuperclass();
    }

    private String getNodeSourceCode(ASTNode node) throws JavaModelException {
        return this.fCu.getBuffer().getText(node.getStartPosition(), node.getLength());
    }

    private int createModifiersForNestedClass() {
        int flags = this.fVisibility;
        if (this.fDeclareFinal) {
            flags |= 0x10;
        }
        if (this.mustInnerClassBeStatic() || this.fDeclareStatic) {
            flags |= 8;
        }
        return flags;
    }

    private AST getAST() {
        return this.fAnonymousInnerClassNode.getAST();
    }

    private ClassInstanceCreation getClassInstanceCreation() {
        return (ClassInstanceCreation)this.fAnonymousInnerClassNode.getParent();
    }

    private TypeDeclaration getTypeDeclaration() {
        return (TypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnonymousInnerClassNode, class$org$eclipse$jdt$core$dom$TypeDeclaration == null ? (class$org$eclipse$jdt$core$dom$TypeDeclaration = ConvertAnonymousToNestedRefactoring.class$("org.eclipse.jdt.core.dom.TypeDeclaration")) : class$org$eclipse$jdt$core$dom$TypeDeclaration);
    }

    public boolean isStaticModifierOptional() {
        return !this.mustInnerClassBeStatic() && !this.isLocalInnerType();
    }

    private boolean mustInnerClassBeStatic() {
        ITypeBinding typeBinding = this.getTypeDeclaration().resolveBinding();
        boolean ans = false;
        block6: for (ASTNode current = this.fAnonymousInnerClassNode.getParent(); current != null; current = current.getParent()) {
            switch (current.getNodeType()) {
                case 1: {
                    AnonymousClassDeclaration enclosingAnonymousClassDeclaration = (AnonymousClassDeclaration)current;
                    ITypeBinding binding = enclosingAnonymousClassDeclaration.resolveBinding();
                    if (binding == null || !Bindings.isSuperType(typeBinding, binding.getSuperclass())) continue block6;
                    return false;
                }
                case 23: {
                    FieldDeclaration enclosingFieldDeclaration = (FieldDeclaration)current;
                    if (!Modifier.isStatic((int)enclosingFieldDeclaration.getModifiers())) continue block6;
                    ans = true;
                    continue block6;
                }
                case 31: {
                    MethodDeclaration enclosingMethodDeclaration = (MethodDeclaration)current;
                    if (!Modifier.isStatic((int)enclosingMethodDeclaration.getModifiers())) continue block6;
                    ans = true;
                    continue block6;
                }
                case 55: {
                    return ans;
                }
            }
        }
        return ans;
    }

    private String getLineSeparator() {
        try {
            return StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu);
        }
        catch (JavaModelException e) {
            return System.getProperty("line.separator", "\n");
        }
    }

    private static int findIndexOfLastField(List bodyDeclarations) {
        for (int i = bodyDeclarations.size() - 1; i >= 0; --i) {
            BodyDeclaration each = (BodyDeclaration)bodyDeclarations.get(i);
            if (!(each instanceof FieldDeclaration)) continue;
            return i;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

