/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameResourceChange
extends JDTChange {
    private IPath fResourcePath;
    private String fNewName;

    public RenameResourceChange(IResource resource, String newName) {
        this(resource.getFullPath(), newName);
    }

    private RenameResourceChange(IPath resourcePath, String newName) {
        this.fResourcePath = resourcePath;
        this.fNewName = newName;
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.getString("RenameResourceChange.rename_resource"), 1);
            this.getResource().move(RenameResourceChange.renamedResourcePath(this.fResourcePath, this.fNewName), this.getCoreRenameFlags(), pm);
            String oldName = this.fResourcePath.lastSegment();
            IPath newPath = RenameResourceChange.renamedResourcePath(this.fResourcePath, this.fNewName);
            RenameResourceChange renameResourceChange = new RenameResourceChange(newPath, oldName);
            return renameResourceChange;
        }
        finally {
            pm.done();
        }
    }

    private int getCoreRenameFlags() {
        if (this.getResource().isLinked()) {
            return 32;
        }
        return 0;
    }

    public static IPath renamedResourcePath(IPath path, String newName) {
        return path.removeLastSegments(1).append(newName);
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("RenameResourceChange.name", new String[]{this.fResourcePath.toString(), this.fNewName});
    }

    public Object getModifiedElement() {
        return this.getResource();
    }
}

