/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;

public class Expressions {
    public static final boolean TRACING;
    private static final Object[] EMPTY_ARGS;

    private Expressions() {
    }

    public static boolean isInstanceOf(Object element, String type) {
        if (element == null) {
            return false;
        }
        return Expressions.isSubtype(element.getClass(), type);
    }

    private static boolean isSubtype(Class clazz, String type) {
        if (clazz.getName().equals(type)) {
            return true;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && Expressions.isSubtype(superClass, type)) {
            return true;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!Expressions.isSubtype(interfaces[i], type)) continue;
            return true;
        }
        return false;
    }

    public static void checkAttribute(String name, String value) throws CoreException {
        if (value == null) {
            throw new CoreException((IStatus)new ExpressionStatus(50, ExpressionMessages.getFormattedString("Expression.attribute.missing", name)));
        }
    }

    public static void checkAttribute(String name, String value, String[] validValues) throws CoreException {
        Expressions.checkAttribute(name, value);
        for (int i = 0; i < validValues.length; ++i) {
            if (!value.equals(validValues[i])) continue;
            return;
        }
        throw new CoreException((IStatus)new ExpressionStatus(51, ExpressionMessages.getFormattedString("Expression.attribute.invalid_value", value)));
    }

    public static void checkCollection(Object var, Expression expression) throws CoreException {
        if (var instanceof Collection) {
            return;
        }
        throw new CoreException((IStatus)new ExpressionStatus(3, ExpressionMessages.getFormattedString("Expression.variable.not_a_collection", expression.toString())));
    }

    public static void checkList(Object var, Expression expression) throws CoreException {
        if (var instanceof List) {
            return;
        }
        throw new CoreException((IStatus)new ExpressionStatus(4, ExpressionMessages.getFormattedString("Expression.variable.not_a_list", expression.toString())));
    }

    public static Object[] getArguments(IConfigurationElement element, String attributeName) throws CoreException {
        String args = element.getAttribute(attributeName);
        if (args != null) {
            return Expressions.parseArguments(args);
        }
        return EMPTY_ARGS;
    }

    public static Object[] parseArguments(String args) throws CoreException {
        int comma;
        ArrayList<Object> result = new ArrayList<Object>();
        int start = 0;
        while ((comma = Expressions.findNextComma(args, start)) != -1) {
            result.add(Expressions.convertArgument(args.substring(start, comma).trim()));
            start = comma + 1;
        }
        result.add(Expressions.convertArgument(args.substring(start).trim()));
        return result.toArray();
    }

    private static int findNextComma(String str, int start) throws CoreException {
        boolean inString = false;
        for (int i = start; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == ',' && !inString) {
                return i;
            }
            if (ch == '\'') {
                if (!inString) {
                    inString = true;
                    continue;
                }
                if (i + 1 < str.length() && str.charAt(i + 1) == '\'') {
                    ++i;
                    continue;
                }
                inString = false;
                continue;
            }
            if (ch != ',' || inString) continue;
            return i;
        }
        if (inString) {
            throw new CoreException((IStatus)new ExpressionStatus(303, ExpressionMessages.getFormattedString("Expression.string_not_terminated", str)));
        }
        return -1;
    }

    public static Object convertArgument(String arg) throws CoreException {
        if (arg == null) {
            return null;
        }
        if (arg.length() == 0) {
            return arg;
        }
        if (arg.charAt(0) == '\'' && arg.charAt(arg.length() - 1) == '\'') {
            return Expressions.unEscapeString(arg.substring(1, arg.length() - 1));
        }
        if ("true".equals(arg)) {
            return Boolean.TRUE;
        }
        if ("false".equals(arg)) {
            return Boolean.FALSE;
        }
        if (arg.indexOf(46) != -1) {
            try {
                return Float.valueOf(arg);
            }
            catch (NumberFormatException e) {
                return arg;
            }
        }
        try {
            return Integer.valueOf(arg);
        }
        catch (NumberFormatException e) {
            return arg;
        }
    }

    public static String unEscapeString(String str) throws CoreException {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\'') {
                if (i == str.length() - 1 || str.charAt(i + 1) != '\'') {
                    throw new CoreException((IStatus)new ExpressionStatus(302, ExpressionMessages.getFormattedString("Expression.string_not_correctly_escaped", str)));
                }
                result.append('\'');
                ++i;
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.core.expressions/tracePropertyResolving");
        TRACING = value != null && value.equalsIgnoreCase("true");
        EMPTY_ARGS = new Object[0];
    }
}

