/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.graphics.TextLayout;

class WrappedContent
implements StyledTextContent {
    static final int LINE_OFFSET = 0;
    static final int LINE_LENGTH = 1;
    StyledTextRenderer renderer;
    StyledTextContent logicalContent;
    int[][] visualLines;
    int visualLineCount = 0;

    WrappedContent(StyledTextRenderer renderer, StyledTextContent logicalContent) {
        this.renderer = renderer;
        this.logicalContent = logicalContent;
    }

    public void addTextChangeListener(TextChangeListener listener) {
        this.logicalContent.addTextChangeListener(listener);
    }

    private void ensureSize(int numLines) {
        int size = this.visualLines.length;
        if (size >= numLines) {
            return;
        }
        int[][] newLines = new int[Math.max(size * 2, numLines)][2];
        System.arraycopy(this.visualLines, 0, newLines, 0, size);
        this.visualLines = newLines;
        this.resetVisualLines(size, this.visualLines.length - size);
    }

    public int getCharCount() {
        return this.logicalContent.getCharCount();
    }

    public String getLine(int lineIndex) {
        String line;
        if (this.visualLineCount == 0) {
            line = this.logicalContent.getLine(lineIndex);
        } else {
            if (lineIndex >= this.visualLineCount || lineIndex < 0) {
                SWT.error(5);
            }
            line = this.logicalContent.getTextRange(this.visualLines[lineIndex][0], this.visualLines[lineIndex][1]);
        }
        return line;
    }

    public int getLineAtOffset(int offset) {
        int lastLine = this.visualLineCount - 1;
        if (this.visualLineCount == 0) {
            return this.logicalContent.getLineAtOffset(offset);
        }
        int lastChar = this.visualLines[lastLine][0] + this.visualLines[lastLine][1];
        if (offset < 0 || offset > 0 && offset > lastChar) {
            SWT.error(5);
        }
        if (offset == lastChar) {
            return lastLine;
        }
        int high = this.visualLineCount;
        int low = -1;
        int index = this.visualLineCount;
        while (high - low > 1) {
            index = (high + low) / 2;
            int lineStart = this.visualLines[index][0];
            if (offset >= lineStart) {
                int lineEnd = lineStart + this.visualLines[index][1];
                low = index;
                if (offset > lineEnd) continue;
                break;
            }
            high = index;
        }
        if (low > 0 && offset == this.visualLines[low - 1][0] + this.visualLines[low - 1][1]) {
            --low;
        }
        return low;
    }

    public int getLineCount() {
        int lineCount = this.visualLineCount;
        if (this.visualLineCount == 0) {
            lineCount = this.logicalContent.getLineCount();
        }
        return lineCount;
    }

    public String getLineDelimiter() {
        return this.logicalContent.getLineDelimiter();
    }

    public int getOffsetAtLine(int lineIndex) {
        int offset;
        if (this.visualLineCount == 0) {
            offset = this.logicalContent.getOffsetAtLine(lineIndex);
        } else {
            if (lineIndex >= this.visualLineCount || lineIndex < 0) {
                SWT.error(5);
            }
            offset = this.visualLines[lineIndex][0];
        }
        return offset;
    }

    public String getTextRange(int start, int length) {
        return this.logicalContent.getTextRange(start, length);
    }

    int getVisualLineCount() {
        return this.visualLineCount;
    }

    public void removeTextChangeListener(TextChangeListener listener) {
        this.logicalContent.removeTextChangeListener(listener);
    }

    void reset(int startLine, int lineCount) {
        if (lineCount <= 0 || this.visualLineCount == 0) {
            return;
        }
        this.reset(startLine, lineCount, true);
    }

    private int reset(int startLine, int lineCount, boolean wrap) {
        if (lineCount <= 0) {
            return startLine;
        }
        int visualFirstLineOffset = this.getOffsetAtLine(startLine);
        int logicalFirstLine = this.logicalContent.getLineAtOffset(visualFirstLineOffset);
        int logicalFirstLineOffset = this.logicalContent.getOffsetAtLine(logicalFirstLine);
        int visualFirstLine = this.getLineAtOffset(logicalFirstLineOffset);
        lineCount += startLine - visualFirstLine;
        startLine = visualFirstLine;
        int lastLine = startLine + lineCount - 1;
        int lastLineEnd = this.visualLines[lastLine][0] + this.visualLines[lastLine][1];
        int logicalEndLine = 0;
        while (lastLine < this.visualLineCount - 1 && lastLineEnd == this.visualLines[lastLine + 1][0]) {
            lastLineEnd = this.visualLines[++lastLine][0] + this.visualLines[lastLine][1];
        }
        if (wrap) {
            logicalEndLine = lastLine == this.visualLineCount - 1 ? this.logicalContent.getLineCount() : this.logicalContent.getLineAtOffset(this.visualLines[lastLine + 1][0]);
        }
        lineCount = lastLine - startLine + 1;
        this.resetVisualLines(startLine, lineCount);
        this.visualLineCount -= lineCount;
        if (wrap) {
            this.wrapLineRange(logicalFirstLine, logicalEndLine, startLine);
        }
        return startLine;
    }

    private void resetVisualLines(int startLine, int lineCount) {
        int endLine = startLine + lineCount;
        for (int i = startLine; i < endLine; ++i) {
            this.visualLines[i] = new int[]{-1, -1};
        }
    }

    public void replaceTextRange(int start, int replaceLength, String text) {
        this.logicalContent.replaceTextRange(start, replaceLength, text);
    }

    public void setText(String text) {
        this.logicalContent.setText(text);
    }

    private void setVisualLine(int visualLineIndex, int visualLineOffset, int visualLineLength) {
        this.ensureSize(this.visualLineCount + 1);
        if (this.visualLines[visualLineIndex][0] != -1) {
            System.arraycopy(this.visualLines, visualLineIndex, this.visualLines, visualLineIndex + 1, this.visualLineCount - visualLineIndex);
            this.visualLines[visualLineIndex] = new int[2];
        }
        this.visualLines[visualLineIndex][0] = visualLineOffset;
        this.visualLines[visualLineIndex][1] = visualLineLength;
        ++this.visualLineCount;
    }

    void textChanged(int startOffset, int newLineCount, int replaceLineCount, int newCharCount, int replaceCharCount) {
        if (this.visualLineCount == 0) {
            return;
        }
        int logicalStartLine = this.logicalContent.getLineAtOffset(startOffset);
        int visualStartLine = this.getLineAtOffset(startOffset);
        int visualReplaceLastLine = this.visualLineCount - 1;
        int textChangeDelta = newCharCount - replaceCharCount;
        if (replaceLineCount > 0) {
            visualReplaceLastLine = this.getLineAtOffset(startOffset + replaceCharCount);
            if ((visualReplaceLastLine == 0 || this.visualLines[visualReplaceLastLine][0] == this.visualLines[visualReplaceLastLine - 1][0] + this.visualLines[visualReplaceLastLine - 1][1]) && visualReplaceLastLine != this.visualLineCount - 1) {
                ++visualReplaceLastLine;
            }
            visualStartLine = this.reset(visualStartLine, visualReplaceLastLine - visualStartLine + 1, false);
        } else {
            visualStartLine = this.reset(visualStartLine, 1, false);
        }
        for (int i = visualReplaceLastLine = this.wrapLineRange(logicalStartLine, logicalStartLine + 1 + newLineCount, visualStartLine); i < this.visualLineCount; ++i) {
            int[] nArray = this.visualLines[i];
            nArray[0] = nArray[0] + textChangeDelta;
        }
    }

    private int wrapLineRange(int startLine, int endLine, int visualLineIndex) {
        int emptyLineCount = 0;
        int width = this.renderer.getClientArea().width - this.renderer.getLeftMargin() - this.renderer.getRightMargin();
        int i = visualLineIndex = this.wrapLineRange(startLine, endLine, visualLineIndex, width);
        while (i < this.visualLines.length && this.visualLines[i][0] == -1) {
            ++i;
            ++emptyLineCount;
        }
        if (emptyLineCount > 0) {
            int copyLineCount = this.visualLineCount - visualLineIndex;
            System.arraycopy(this.visualLines, visualLineIndex + emptyLineCount, this.visualLines, visualLineIndex, copyLineCount);
            this.resetVisualLines(visualLineIndex + copyLineCount, emptyLineCount);
        }
        return visualLineIndex;
    }

    private int wrapLineRange(int startLine, int endLine, int visualLineIndex, int width) {
        if (this.visualLineCount == 0 && width == 0) {
            return visualLineIndex;
        }
        for (int i = startLine; i < endLine; ++i) {
            String line = this.logicalContent.getLine(i);
            int lineOffset = this.logicalContent.getOffsetAtLine(i);
            int lineLength = line.length();
            if (lineLength == 0) {
                this.setVisualLine(visualLineIndex, lineOffset, 0);
                ++visualLineIndex;
                continue;
            }
            TextLayout layout = this.renderer.getTextLayout(line, lineOffset);
            layout.setWidth(Math.max(1, width));
            int[] offsets = layout.getLineOffsets();
            for (int j = 0; j < offsets.length - 1; ++j) {
                this.setVisualLine(visualLineIndex++, lineOffset + offsets[j], offsets[j + 1] - offsets[j]);
            }
            this.renderer.disposeTextLayout(layout);
        }
        return visualLineIndex;
    }

    void wrapLines() {
        int width = this.renderer.getClientArea().width - this.renderer.getLeftMargin() - this.renderer.getRightMargin();
        this.wrapLines(width);
    }

    void wrapLines(int width) {
        int lineCount = this.logicalContent.getLineCount();
        this.visualLineCount = 0;
        this.visualLines = new int[lineCount][2];
        this.resetVisualLines(0, this.visualLines.length);
        this.wrapLineRange(0, lineCount, 0, width);
    }
}

