/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.projection;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;

public class ProjectionAnnotation
extends Annotation
implements IAnnotationPresentation {
    public static final String TYPE = "org.eclipse.projection";
    private static final int COLOR = 16;
    private static Image fgCollapsedImage;
    private static Image fgExpandedImage;
    private boolean fIsCollapsed = false;
    private boolean fIsRangeIndication = false;
    static /* synthetic */ Class class$org$eclipse$jface$text$source$projection$ProjectionAnnotation;

    public ProjectionAnnotation() {
        this(false);
    }

    public ProjectionAnnotation(boolean isCollapsed) {
        super(TYPE, false, null);
        this.fIsCollapsed = isCollapsed;
    }

    public void setRangeIndication(boolean rangeIndication) {
        this.fIsRangeIndication = rangeIndication;
    }

    private void drawRangeIndication(GC gc, Canvas canvas, Rectangle r) {
        int MARGIN = 3;
        Color fg = gc.getForeground();
        gc.setForeground(canvas.getDisplay().getSystemColor(16));
        gc.setLineWidth(1);
        gc.drawLine(r.x + 4, r.y + 12, r.x + 4, r.y + r.height - 3);
        gc.drawLine(r.x + 4, r.y + r.height - 3, r.x + r.width - 3, r.y + r.height - 3);
        gc.setForeground(fg);
    }

    public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
        Image image = this.getImage(canvas.getDisplay());
        if (image != null) {
            ImageUtilities.drawImage(image, gc, canvas, rectangle, 0x1000000, 128);
            if (this.fIsRangeIndication) {
                this.drawRangeIndication(gc, canvas, rectangle);
            }
        }
    }

    public int getLayer() {
        return 0;
    }

    private Image getImage(Display display) {
        this.initializeImages(display);
        return this.isCollapsed() ? fgCollapsedImage : fgExpandedImage;
    }

    private void initializeImages(Display display) {
        if (fgCollapsedImage == null) {
            ImageDescriptor descriptor = ImageDescriptor.createFromFile((Class)(class$org$eclipse$jface$text$source$projection$ProjectionAnnotation == null ? (class$org$eclipse$jface$text$source$projection$ProjectionAnnotation = ProjectionAnnotation.class$("org.eclipse.jface.text.source.projection.ProjectionAnnotation")) : class$org$eclipse$jface$text$source$projection$ProjectionAnnotation), (String)"images/collapsed.gif");
            fgCollapsedImage = descriptor.createImage((Device)display);
            descriptor = ImageDescriptor.createFromFile((Class)(class$org$eclipse$jface$text$source$projection$ProjectionAnnotation == null ? (class$org$eclipse$jface$text$source$projection$ProjectionAnnotation = ProjectionAnnotation.class$("org.eclipse.jface.text.source.projection.ProjectionAnnotation")) : class$org$eclipse$jface$text$source$projection$ProjectionAnnotation), (String)"images/expanded.gif");
            fgExpandedImage = descriptor.createImage((Device)display);
            display.disposeExec((Runnable)new DisplayDisposeRunnable());
        }
    }

    public boolean isCollapsed() {
        return this.fIsCollapsed;
    }

    public void markCollapsed() {
        this.fIsCollapsed = true;
    }

    public void markExpanded() {
        this.fIsCollapsed = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DisplayDisposeRunnable
    implements Runnable {
        private DisplayDisposeRunnable() {
        }

        public void run() {
            if (fgCollapsedImage != null) {
                fgCollapsedImage.dispose();
                fgCollapsedImage = null;
            }
            if (fgExpandedImage != null) {
                fgExpandedImage.dispose();
                fgExpandedImage = null;
            }
        }
    }
}

